/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.maps.zzr;
import com.google.android.gms.internal.maps.zzt;
import com.google.android.gms.internal.maps.zzu;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.zze;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class IndoorBuilding {
    private final zzr zza;
    private final zze zzb;

    public int getActiveLevelIndex() {
        int n;
        try {
            n = this.zza.zzd();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    public int getDefaultLevelIndex() {
        int n;
        try {
            n = this.zza.zze();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzf();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public List<IndoorLevel> getLevels() {
        try {
            boolean bl;
            Iterator this_ = ((IndoorBuilding)((Object)this_)).zza.zzg();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(this_.size());
            this_ = this_.iterator();
            while (bl = this_.hasNext()) {
                IBinder iBinder = (IBinder)this_.next();
                zzu zzu2 = zzt.zzb(iBinder);
                IndoorLevel indoorLevel = new IndoorLevel(zzu2);
                arrayList.add(indoorLevel);
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        RuntimeRemoteException runtimeRemoteException;
        if (!(other instanceof IndoorBuilding)) {
            return false;
        }
        try {
            bl = this.zza.zzh(((IndoorBuilding)((Object)runtimeRemoteException)).zza);
        }
        catch (RemoteException remoteException) {
            runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public boolean isUnderground() {
        boolean bl;
        try {
            bl = this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
        return bl;
    }

    public IndoorBuilding(zzr zzr2) {
        zze zze2 = zze.zza;
        this.zza = (zzr)Preconditions.checkNotNull((Object)zzr2, (Object)"delegate");
        this.zzb = (zze)Preconditions.checkNotNull((Object)zze2, (Object)"shim");
    }
}

