/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.Dash;
import com.google.android.gms.maps.model.Dot;
import com.google.android.gms.maps.model.Gap;
import com.google.android.gms.maps.model.zzj;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PatternItemCreator")
public class PatternItem
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<PatternItem> CREATOR;
    private static final String zza;
    @SafeParcelable.Field(id=2, getter="getType")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getLength")
    @Nullable
    private final Float zzc;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zzb, this.zzc};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String toString() {
        int n = this_.zzb;
        Object this_ = this_.zzc;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[PatternItem: type=");
        stringBuilder.append(n);
        stringBuilder.append(" length=");
        stringBuilder.append(this_);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    static {
        zzj zzj2;
        zza = PatternItem.class.getSimpleName();
        CREATOR = zzj2 = new zzj();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public PatternItem(@SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) @Nullable Float f) {
        boolean bl = n != 1 ? (f != null ? f.floatValue() >= 0.0f : false) : true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid PatternItem: type=");
        stringBuilder.append(n);
        stringBuilder.append(" length=");
        stringBuilder.append(f);
        Preconditions.checkArgument((boolean)bl, (Object)stringBuilder.toString());
        this.zzb = n;
        this.zzc = f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.zzb);
        SafeParcelWriter.writeFloatObject((Parcel)var1_1, (int)3, (Float)this.zzc, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        PatternItem patternItem;
        if (this == patternItem) {
            return true;
        }
        if (!(patternItem instanceof PatternItem)) {
            return false;
        }
        patternItem = patternItem;
        return this.zzb == patternItem.zzb && Objects.equal((Object)this.zzc, (Object)patternItem.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    static List zza(@Nullable List object) {
        if (object == null) {
            return null;
        }
        ArrayList<void> arrayList = new ArrayList<void>(object.size());
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            void var0_3;
            PatternItem patternItem = (PatternItem)((Object)iterator.next());
            if (patternItem == null) {
                Object var0_2 = null;
            } else {
                int n = patternItem.zzb;
                switch (n) {
                    default: {
                        String string = zza;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("Unknown PatternItem type: ");
                        stringBuilder.append(n);
                        Log.w((String)string, (String)stringBuilder.toString());
                        PatternItem patternItem2 = patternItem;
                        break;
                    }
                    case 2: {
                        void var0_7;
                        if (patternItem.zzc != null) {
                            boolean bl = true;
                        } else {
                            boolean bl = false;
                        }
                        Preconditions.checkState((boolean)var0_7, (Object)"length must not be null.");
                        Gap gap = new Gap(patternItem.zzc.floatValue());
                        break;
                    }
                    case 1: {
                        Dot dot = new Dot();
                        break;
                    }
                    case 0: {
                        void var0_12;
                        if (patternItem.zzc != null) {
                            boolean bl = true;
                        } else {
                            boolean bl = false;
                        }
                        Preconditions.checkState((boolean)var0_12, (Object)"length must not be null.");
                        Dash dash = new Dash(patternItem.zzc.floatValue());
                    }
                }
            }
            arrayList.add(var0_3);
        }
        return arrayList;
    }
}

