/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.zzq;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StreetViewPanoramaLinkCreator")
public class StreetViewPanoramaLink
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<StreetViewPanoramaLink> CREATOR;
    @SafeParcelable.Field(id=2)
    @NonNull
    public final String panoId;
    @SafeParcelable.Field(id=3)
    public final float bearing;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.panoId, Float.valueOf(this.bearing)};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("panoId", (Object)this.panoId).add("bearing", (Object)Float.valueOf(this.bearing)).toString();
    }

    static {
        zzq zzq2;
        CREATOR = zzq2 = new zzq();
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    public StreetViewPanoramaLink(@SafeParcelable.Param(id=2) @NonNull String string, @SafeParcelable.Param(id=3) float f) {
        this.panoId = string;
        float f2 = (double)f <= 0.0 ? f % 360.0f + 360.0f : f;
        this.bearing = f2 % 360.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int n) {
        void var1_1;
        n = SafeParcelWriter.beginObjectHeader((Parcel)out);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.panoId, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)var1_1, (int)3, (float)this.bearing);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        StreetViewPanoramaLink streetViewPanoramaLink;
        if (this == streetViewPanoramaLink) {
            return true;
        }
        if (!(streetViewPanoramaLink instanceof StreetViewPanoramaLink)) {
            return false;
        }
        streetViewPanoramaLink = streetViewPanoramaLink;
        return this.panoId.equals(streetViewPanoramaLink.panoId) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(streetViewPanoramaLink.bearing);
    }
}

