/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.StampStyle;
import com.google.android.gms.maps.model.zzu;
import com.google.android.gms.maps.model.zzv;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="StrokeStyleCreator")
public final class StrokeStyle
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<StrokeStyle> CREATOR;
    @SafeParcelable.Field(id=2, getter="getWidth")
    private final float zza;
    @SafeParcelable.Field(id=3, getter="getColor")
    private final int zzb;
    @SafeParcelable.Field(id=4, getter="getToColor")
    private final int zzc;
    @SafeParcelable.Field(id=5, getter="isVisible")
    private final boolean zzd;
    @SafeParcelable.Field(id=6, getter="getStamp")
    @Nullable
    private final StampStyle zze;

    @Nullable
    public StampStyle getStamp() {
        return this.zze;
    }

    @NonNull
    public static Builder colorBuilder(int color) {
        int n;
        Builder builder = new Builder(null);
        builder.zza(n);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Builder gradientBuilder(int fromColor, int toColor) {
        void var1_1;
        int n;
        Builder builder = new Builder(null);
        builder.zzb(n, (int)var1_1);
        return builder;
    }

    @NonNull
    public static Builder transparentColorBuilder() {
        Builder builder = new Builder(null);
        builder.zza(0);
        return builder;
    }

    static {
        zzv zzv2;
        CREATOR = zzv2 = new zzv();
    }

    @SafeParcelable.Constructor
    StrokeStyle(@SafeParcelable.Param(id=2) float f, @SafeParcelable.Param(id=3) int n, @SafeParcelable.Param(id=4) int n2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) @Nullable StampStyle stampStyle) {
        this.zza = f;
        this.zzb = n;
        this.zzc = n2;
        this.zzd = bl;
        this.zze = stampStyle;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)2, (float)this.zza);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)3, (int)this.zzb);
        SafeParcelWriter.writeInt((Parcel)parcel, (int)4, (int)this.zzc);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.isVisible());
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)6, (Parcelable)this.getStamp(), (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n2);
    }

    public boolean isVisible() {
        return this.zzd;
    }

    public final float zza() {
        return this.zza;
    }

    @NonNull
    public final Pair zzb() {
        Pair pair = new Pair((Object)this.zzb, (Object)this.zzc);
        return pair;
    }

    public static final class Builder {
        private float zza;
        private int zzb;
        private int zzc;
        private boolean zzd;
        @Nullable
        private StampStyle zze;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder stamp(@NonNull StampStyle stampStyle) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        @NonNull
        public StrokeStyle build() {
            StrokeStyle strokeStyle = new StrokeStyle(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
            return strokeStyle;
        }

        private Builder() {
        }

        public Builder(@NonNull StrokeStyle strokeStyle) {
            this.zza = strokeStyle.zza();
            Pair pair = strokeStyle.zzb();
            this.zzb = (Integer)pair.first;
            this.zzc = (Integer)pair.second;
            this.zzd = strokeStyle.isVisible();
            this.zze = strokeStyle.getStamp();
        }

        @NonNull
        public final Builder zza(int n) {
            this.zzb = n;
            this.zzc = n;
            return this;
        }

        @NonNull
        public final Builder zzb(int n, int n2) {
            this.zzb = n;
            this.zzc = n2;
            return this;
        }

        @NonNull
        public final Builder zzc(boolean bl) {
            this.zzd = bl;
            return this;
        }

        @NonNull
        public final Builder zzd(float f) {
            this.zza = f;
            return this;
        }

        /* synthetic */ Builder(zzu zzu2) {
        }
    }
}

