/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.StrictMode;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzca;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzat;

@VisibleForTesting
final class zzau
implements MapLifecycleDelegate {
    private final Fragment zza;
    private final IMapFragmentDelegate zzb;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final View onCreateView(LayoutInflater object, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        StrictMode.ThreadPolicy threadPolicy;
        Bundle bundle2;
        try {
            bundle2 = new Bundle();
            zzca.zzb(bundle, bundle2);
            threadPolicy = StrictMode.getThreadPolicy();
            StrictMode.ThreadPolicy.Builder builder = new StrictMode.ThreadPolicy.Builder(threadPolicy);
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)builder.permitAll().build());
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
        zzau zzau2 = zzau2.zzb.onCreateView(ObjectWrapper.wrap((Object)object), ObjectWrapper.wrap((Object)viewGroup), bundle2);
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        zzca.zzb(bundle2, bundle);
        return (View)ObjectWrapper.unwrap((IObjectWrapper)zzau2);
        catch (Throwable throwable) {}
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        throw throwable;
    }

    public zzau(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
        this.zzb = (IMapFragmentDelegate)Preconditions.checkNotNull((Object)iMapFragmentDelegate);
        this.zza = (Fragment)Preconditions.checkNotNull((Object)fragment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void getMapAsync(OnMapReadyCallback object) {
        IMapFragmentDelegate iMapFragmentDelegate;
        try {
            iMapFragmentDelegate = this.zzb;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
        {
            zzat zzat2 = new zzat(this, (OnMapReadyCallback)object);
            iMapFragmentDelegate.getMapAsync(zzat2);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onCreate(@Nullable Bundle object) {
        Bundle bundle;
        try {
            boolean bl;
            bundle = new Bundle();
            zzca.zzb(object, bundle);
            Bundle bundle2 = this.zza.getArguments();
            if (bundle2 != null && (bl = bundle2.containsKey("MapOptions"))) {
                zzca.zzc(bundle, "MapOptions", bundle2.getParcelable("MapOptions"));
            }
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
        {
            this.zzb.onCreate(bundle);
            zzca.zzb(bundle, object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onDestroy() {
        try {
            this.zzb.onDestroy();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onDestroyView() {
        try {
            this.zzb.onDestroyView();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zza(@Nullable Bundle object) {
        try {
            Bundle bundle = new Bundle();
            zzca.zzb(object, bundle);
            this.zzb.onEnterAmbient(bundle);
            zzca.zzb(bundle, object);
            return;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzb() {
        try {
            this.zzb.onExitAmbient();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onInflate(Activity object, Bundle object2, @Nullable Bundle bundle) {
        object2 = (GoogleMapOptions)object2.getParcelable("MapOptions");
        try {
            Bundle bundle2 = new Bundle();
            zzca.zzb(bundle, bundle2);
            this.zzb.onInflate(ObjectWrapper.wrap((Object)object), (GoogleMapOptions)((Object)object2), bundle2);
            zzca.zzb(bundle2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onLowMemory() {
        try {
            this.zzb.onLowMemory();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onPause() {
        try {
            this.zzb.onPause();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onResume() {
        try {
            this.zzb.onResume();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onSaveInstanceState(Bundle object) {
        try {
            Bundle bundle = new Bundle();
            zzca.zzb(object, bundle);
            this.zzb.onSaveInstanceState(bundle);
            zzca.zzb(bundle, object);
            return;
        }
        catch (RemoteException remoteException) {
            object = new RuntimeRemoteException(remoteException);
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onStart() {
        try {
            this.zzb.onStart();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onStop() {
        try {
            this.zzb.onStop();
            return;
        }
        catch (RemoteException remoteException) {
            RuntimeRemoteException runtimeRemoteException = new RuntimeRemoteException(remoteException);
            throw runtimeRemoteException;
        }
    }
}

