/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.graphics.Bitmap;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.maps.zzi;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.PinConfig;
import com.google.android.gms.maps.model.RuntimeRemoteException;

public final class BitmapDescriptorFactory {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;
    private static zzi zza;

    @NonNull
    public static BitmapDescriptor defaultMarker() {
        BitmapDescriptor bitmapDescriptor;
        try {
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzd());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor defaultMarker(float hue) {
        BitmapDescriptor bitmapDescriptor;
        try {
            float f;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zze(f));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromAsset(@NonNull String assetName) {
        BitmapDescriptor bitmapDescriptor;
        Preconditions.checkNotNull((Object)assetName, (Object)"assetName must not be null");
        try {
            String string;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzf(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromBitmap(@NonNull Bitmap image) {
        BitmapDescriptor bitmapDescriptor;
        Preconditions.checkNotNull((Object)image, (Object)"image must not be null");
        try {
            Bitmap bitmap;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzg(bitmap));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromFile(@NonNull String fileName) {
        BitmapDescriptor bitmapDescriptor;
        Preconditions.checkNotNull((Object)fileName, (Object)"fileName must not be null");
        try {
            String string;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzh(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromPath(@NonNull String absolutePath) {
        BitmapDescriptor bitmapDescriptor;
        Preconditions.checkNotNull((Object)absolutePath, (Object)"absolutePath must not be null");
        try {
            String string;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzi(string));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromPinConfig(@NonNull PinConfig pinConfig) {
        BitmapDescriptor bitmapDescriptor;
        try {
            PinConfig pinConfig2;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzj(pinConfig2));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    @NonNull
    public static BitmapDescriptor fromResource(int resourceId) {
        BitmapDescriptor bitmapDescriptor;
        try {
            int n;
            bitmapDescriptor = new BitmapDescriptor(BitmapDescriptorFactory.zzb().zzk(n));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bitmapDescriptor;
    }

    private BitmapDescriptorFactory() {
    }

    private static zzi zzb() {
        return (zzi)Preconditions.checkNotNull((Object)zza, (Object)"IBitmapDescriptorFactory is not initialized");
    }

    public static void zza(zzi zzi2) {
        if (zza != null) {
            return;
        }
        zza = (zzi)Preconditions.checkNotNull((Object)zzi2, (Object)"delegate must not be null");
    }
}

