/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.maps.zzaa;
import com.google.android.gms.internal.maps.zzab;
import com.google.android.gms.internal.maps.zzy;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.zzl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public final class IndoorBuilding {
    private final zzy zza;

    public int getActiveLevelIndex() {
        int n;
        try {
            n = this.zza.zzd();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public int getDefaultLevelIndex() {
        int n;
        try {
            n = this.zza.zze();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzf();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public List<IndoorLevel> getLevels() {
        try {
            boolean bl;
            Iterator this_ = ((IndoorBuilding)((Object)this_)).zza.zzg();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(this_.size());
            this_ = this_.iterator();
            while (bl = this_.hasNext()) {
                IBinder iBinder = (IBinder)this_.next();
                zzab zzab2 = zzaa.zzb(iBinder);
                IndoorLevel indoorLevel = new IndoorLevel(zzab2);
                arrayList.add(indoorLevel);
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof IndoorBuilding)) {
            return false;
        }
        try {
            void var1_3;
            bl = this.zza.zzh(((IndoorBuilding)var1_3).zza);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isUnderground() {
        boolean bl;
        try {
            bl = this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public IndoorBuilding(zzy zzy2) {
        this.zza = (zzy)Preconditions.checkNotNull((Object)zzy2, (Object)"delegate");
        zzl cfr_ignored_0 = (zzl)Preconditions.checkNotNull((Object)zzl.zza, (Object)"shim");
    }
}

