/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.zzc;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CircleOptionsCreator")
public final class CircleOptions
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<CircleOptions> CREATOR = new zzc();
    @Nullable
    @SafeParcelable.Field(id=2, getter="getCenter")
    private LatLng zza;
    @SafeParcelable.Field(id=3, getter="getRadius")
    private double zzb;
    @SafeParcelable.Field(id=4, getter="getStrokeWidth")
    private float zzc;
    @SafeParcelable.Field(id=5, getter="getStrokeColor")
    private int zzd;
    @SafeParcelable.Field(id=6, getter="getFillColor")
    private int zze;
    @SafeParcelable.Field(id=7, getter="getZIndex")
    private float zzf;
    @SafeParcelable.Field(id=8, getter="isVisible")
    private boolean zzg;
    @SafeParcelable.Field(id=9, getter="isClickable")
    private boolean zzh;
    @Nullable
    @SafeParcelable.Field(id=10, getter="getStrokePattern")
    private List zzi;

    public double getRadius() {
        return this.zzb;
    }

    public float getStrokeWidth() {
        return this.zzc;
    }

    public float getZIndex() {
        return this.zzf;
    }

    public int getFillColor() {
        return this.zze;
    }

    public int getStrokeColor() {
        return this.zzd;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions center(@NonNull LatLng center) {
        void var1_1;
        Preconditions.checkNotNull((Object)((Object)center), (Object)"center must not be null.");
        this.zza = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions clickable(boolean clickable) {
        void var1_1;
        this.zzh = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions fillColor(int color) {
        void var1_1;
        this.zze = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions radius(double radius) {
        void var1_1;
        this.zzb = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions strokeColor(int color) {
        void var1_1;
        this.zzd = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions strokePattern(@Nullable List<PatternItem> pattern) {
        void var1_1;
        this.zzi = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions strokeWidth(float width) {
        void var1_1;
        this.zzc = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions visible(boolean visible) {
        void var1_1;
        this.zzg = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CircleOptions zIndex(float zIndex) {
        void var1_1;
        this.zzf = var1_1;
        return this;
    }

    @Nullable
    public LatLng getCenter() {
        return this.zza;
    }

    @Nullable
    public List<PatternItem> getStrokePattern() {
        return this.zzi;
    }

    public CircleOptions() {
        this.zza = null;
        this.zzb = 0.0;
        this.zzc = 10.0f;
        this.zzd = -16777216;
        this.zze = 0;
        this.zzf = 0.0f;
        this.zzg = true;
        this.zzh = false;
        this.zzi = null;
    }

    @SafeParcelable.Constructor
    CircleOptions(@SafeParcelable.Param(id=2) LatLng latLng, @SafeParcelable.Param(id=3) double d, @SafeParcelable.Param(id=4) float f, @SafeParcelable.Param(id=5) int n, @SafeParcelable.Param(id=6) int n2, @SafeParcelable.Param(id=7) float f2, @SafeParcelable.Param(id=8) boolean bl, @SafeParcelable.Param(id=9) boolean bl2, @SafeParcelable.Param(id=10) @Nullable List list) {
        this.zza = latLng;
        this.zzb = d;
        this.zzc = f;
        this.zzd = n;
        this.zze = n2;
        this.zzf = f2;
        this.zzg = bl;
        this.zzh = bl2;
        this.zzi = list;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeParcelable((Parcel)parcel, (int)2, (Parcelable)this.getCenter(), (int)n, (boolean)false);
        SafeParcelWriter.writeDouble((Parcel)parcel, (int)3, (double)this.getRadius());
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)4, (float)this.getStrokeWidth());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)5, (int)this.getStrokeColor());
        SafeParcelWriter.writeInt((Parcel)parcel, (int)6, (int)this.getFillColor());
        SafeParcelWriter.writeFloat((Parcel)parcel, (int)7, (float)this.getZIndex());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)8, (boolean)this.isVisible());
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)9, (boolean)this.isClickable());
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)10, this.getStrokePattern(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean isClickable() {
        return this.zzh;
    }

    public boolean isVisible() {
        return this.zzg;
    }
}

