/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.maps.zzao;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PatternItem;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.List;

public final class Polygon {
    private final zzao zza;

    public float getStrokeWidth() {
        float f;
        try {
            f = this.zza.zzd();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return f;
    }

    public float getZIndex() {
        float f;
        try {
            f = this.zza.zze();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return f;
    }

    public int getFillColor() {
        int n;
        try {
            n = this.zza.zzf();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public int getStrokeColor() {
        int n;
        try {
            n = this.zza.zzg();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public int getStrokeJointType() {
        int n;
        try {
            n = this.zza.zzh();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    public int hashCode() {
        int n;
        try {
            n = this.zza.zzi();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return n;
    }

    @Nullable
    public Object getTag() {
        try {
            Object this_ = ObjectWrapper.unwrap((IObjectWrapper)((Polygon)this_).zza.zzj());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @NonNull
    public String getId() {
        try {
            String this_ = ((Polygon)((Object)this_)).zza.zzk();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @NonNull
    public List<List<LatLng>> getHoles() {
        try {
            List this_ = ((Polygon)((Object)this_)).zza.zzl();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @NonNull
    public List<LatLng> getPoints() {
        try {
            List this_ = ((Polygon)((Object)this_)).zza.zzm();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    @Nullable
    public List<PatternItem> getStrokePattern() {
        try {
            List this_ = PatternItem.zza(((Polygon)((Object)this_)).zza.zzn());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return this_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove() {
        try {
            this.zza.zzo();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setClickable(boolean clickable) {
        try {
            void var1_2;
            this.zza.zzp((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFillColor(int color) {
        try {
            void var1_2;
            this.zza.zzq((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGeodesic(boolean geodesic) {
        try {
            void var1_2;
            this.zza.zzr((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setHoles(@NonNull List<? extends List<LatLng>> holes) {
        try {
            void var1_2;
            this.zza.zzs((List)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setPoints(@NonNull List<LatLng> points) {
        try {
            void var1_2;
            Preconditions.checkNotNull((Object)var1_2, (Object)"points must not be null.");
            this.zza.zzt((List)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeColor(int color) {
        try {
            void var1_2;
            this.zza.zzu((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeJointType(int jointType) {
        try {
            void var1_2;
            this.zza.zzv((int)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokePattern(@Nullable List<PatternItem> pattern) {
        try {
            void var1_2;
            this.zza.zzw((List)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setStrokeWidth(float width) {
        try {
            void var1_2;
            this.zza.zzx((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTag(@Nullable Object tag) {
        try {
            void var1_2;
            this.zza.zzy(ObjectWrapper.wrap((Object)var1_2));
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setVisible(boolean visible) {
        try {
            void var1_2;
            this.zza.zzz((boolean)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setZIndex(float zIndex) {
        try {
            void var1_2;
            this.zza.zzA((float)var1_2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (!(other instanceof Polygon)) {
            return false;
        }
        try {
            void var1_3;
            bl = this.zza.zzB(((Polygon)var1_3).zza);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isClickable() {
        boolean bl;
        try {
            bl = this.zza.zzC();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isGeodesic() {
        boolean bl;
        try {
            bl = this.zza.zzD();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public boolean isVisible() {
        boolean bl;
        try {
            bl = this.zza.zzE();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        return bl;
    }

    public Polygon(zzao zzao2) {
        this.zza = (zzao)Preconditions.checkNotNull((Object)zzao2);
    }
}

