/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.os.RemoteException;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.dynamic.DeferredLifecycleHelper;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.dynamic.OnDelegateCreatedListener;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IMapViewDelegate;
import com.google.android.gms.maps.internal.zzcc;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.zzah;
import java.util.ArrayList;
import java.util.List;

@VisibleForTesting
final class zzai
extends DeferredLifecycleHelper {
    private final ViewGroup zzb;
    private final Context zzc;
    protected OnDelegateCreatedListener zza;
    @Nullable
    private final GoogleMapOptions zzd;
    private final List zze = new ArrayList();

    @VisibleForTesting
    zzai(ViewGroup viewGroup, Context context, @Nullable GoogleMapOptions googleMapOptions) {
        this.zzb = viewGroup;
        this.zzc = context;
        this.zzd = googleMapOptions;
    }

    protected final void createDelegate(OnDelegateCreatedListener onDelegateCreatedListener) {
        this.zza = onDelegateCreatedListener;
        this.zzb();
    }

    public final void zza(OnMapReadyCallback onMapReadyCallback) {
        if (this.getDelegate() != null) {
            ((zzah)this.getDelegate()).getMapAsync(onMapReadyCallback);
            return;
        }
        this.zze.add(onMapReadyCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public final void zzb() {
        if (this.zza == null) return;
        if (this.getDelegate() != null) return;
        try {
            Object object = this.zzc;
            MapsInitializer.initialize((Context)object);
            Object object2 = zzcc.zza((Context)object, null);
            object = object2.zzg(ObjectWrapper.wrap((Object)object), this.zzd);
            if (object == null) {
                return;
            }
            this.zza.onDelegateCreated((LifecycleDelegate)new zzah(this.zzb, (IMapViewDelegate)object));
            object = this.zze;
            object2 = object.iterator();
            while (true) {
                boolean bl;
                if (!(bl = object2.hasNext())) {
                    object.clear();
                    return;
                }
                OnMapReadyCallback onMapReadyCallback = (OnMapReadyCallback)object2.next();
                ((zzah)this.getDelegate()).getMapAsync(onMapReadyCallback);
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            return;
        }
    }
}

