/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.maps.model.IndoorLevel;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.internal.zzd;
import com.google.android.gms.maps.model.internal.zze;
import java.util.ArrayList;
import java.util.List;

public final class IndoorBuilding {
    private final zzd zzaKd;

    public IndoorBuilding(zzd delegate) {
        this.zzaKd = (zzd)zzx.zzw((Object)delegate);
    }

    public int getDefaultLevelIndex() {
        try {
            return this.zzaKd.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public int getActiveLevelIndex() {
        try {
            return this.zzaKd.getActiveLevelIndex();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public List<IndoorLevel> getLevels() {
        try {
            List<IBinder> list = this.zzaKd.getLevels();
            ArrayList<IndoorLevel> arrayList = new ArrayList<IndoorLevel>(list.size());
            for (IBinder iBinder : list) {
                arrayList.add(new IndoorLevel(zze.zza.zzcT(iBinder)));
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean isUnderground() {
        try {
            return this.zzaKd.isUnderground();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndoorBuilding)) {
            return false;
        }
        try {
            return this.zzaKd.zzb(((IndoorBuilding)other).zzaKd);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public int hashCode() {
        try {
            return this.zzaKd.hashCodeRemote();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }
}

