/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolygonOptions
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    private final int mVersionCode;
    private final List<LatLng> zzaKu;
    private final List<List<LatLng>> zzaKv;
    private float zzaJP = 10.0f;
    private int zzaJQ = -16777216;
    private int zzaJR = 0;
    private float zzaJS = 0.0f;
    private boolean zzaJT = true;
    private boolean zzaKw = false;

    public PolygonOptions() {
        this.mVersionCode = 1;
        this.zzaKu = new ArrayList<LatLng>();
        this.zzaKv = new ArrayList<List<LatLng>>();
    }

    PolygonOptions(int versionCode, List<LatLng> points, List holes, float strokeWidth, int strokeColor, int fillColor, float zIndex, boolean visible, boolean geodesic) {
        this.mVersionCode = versionCode;
        this.zzaKu = points;
        this.zzaKv = holes;
        this.zzaJP = strokeWidth;
        this.zzaJQ = strokeColor;
        this.zzaJR = fillColor;
        this.zzaJS = zIndex;
        this.zzaJT = visible;
        this.zzaKw = geodesic;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List zzya() {
        return this.zzaKv;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    public PolygonOptions add(LatLng point) {
        this.zzaKu.add(point);
        return this;
    }

    public PolygonOptions add(LatLng ... points) {
        this.zzaKu.addAll(Arrays.asList(points));
        return this;
    }

    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.zzaKu.add(latLng);
        }
        return this;
    }

    public PolygonOptions addHole(Iterable<LatLng> points) {
        ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
        for (LatLng latLng : points) {
            arrayList.add(latLng);
        }
        this.zzaKv.add(arrayList);
        return this;
    }

    public PolygonOptions strokeWidth(float width) {
        this.zzaJP = width;
        return this;
    }

    public PolygonOptions strokeColor(int color) {
        this.zzaJQ = color;
        return this;
    }

    public PolygonOptions fillColor(int color) {
        this.zzaJR = color;
        return this;
    }

    public PolygonOptions zIndex(float zIndex) {
        this.zzaJS = zIndex;
        return this;
    }

    public PolygonOptions visible(boolean visible) {
        this.zzaJT = visible;
        return this;
    }

    public PolygonOptions geodesic(boolean geodesic) {
        this.zzaKw = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.zzaKu;
    }

    public List<List<LatLng>> getHoles() {
        return this.zzaKv;
    }

    public float getStrokeWidth() {
        return this.zzaJP;
    }

    public int getStrokeColor() {
        return this.zzaJQ;
    }

    public int getFillColor() {
        return this.zzaJR;
    }

    public float getZIndex() {
        return this.zzaJS;
    }

    public boolean isVisible() {
        return this.zzaJT;
    }

    public boolean isGeodesic() {
        return this.zzaKw;
    }
}

