/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.graphics.Bitmap;
import android.location.Location;
import android.os.RemoteException;
import android.support.annotation.RequiresPermission;
import android.view.View;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.LocationSource;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.ILocationSourceDelegate;
import com.google.android.gms.maps.internal.zzab;
import com.google.android.gms.maps.internal.zzb;
import com.google.android.gms.maps.internal.zzd;
import com.google.android.gms.maps.internal.zze;
import com.google.android.gms.maps.internal.zzf;
import com.google.android.gms.maps.internal.zzg;
import com.google.android.gms.maps.internal.zzh;
import com.google.android.gms.maps.internal.zzi;
import com.google.android.gms.maps.internal.zzj;
import com.google.android.gms.maps.internal.zzk;
import com.google.android.gms.maps.internal.zzl;
import com.google.android.gms.maps.internal.zzm;
import com.google.android.gms.maps.internal.zzn;
import com.google.android.gms.maps.internal.zzp;
import com.google.android.gms.maps.internal.zzq;
import com.google.android.gms.maps.internal.zzr;
import com.google.android.gms.maps.internal.zzs;
import com.google.android.gms.maps.internal.zzu;
import com.google.android.gms.maps.internal.zzv;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.Circle;
import com.google.android.gms.maps.model.CircleOptions;
import com.google.android.gms.maps.model.GroundOverlay;
import com.google.android.gms.maps.model.GroundOverlayOptions;
import com.google.android.gms.maps.model.IndoorBuilding;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polygon;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import com.google.android.gms.maps.model.TileOverlay;
import com.google.android.gms.maps.model.TileOverlayOptions;
import com.google.android.gms.maps.model.internal.IPolylineDelegate;
import com.google.android.gms.maps.model.internal.zzc;
import com.google.android.gms.maps.model.internal.zzd;
import com.google.android.gms.maps.model.internal.zzf;
import com.google.android.gms.maps.model.internal.zzg;
import com.google.android.gms.maps.model.internal.zzh;

public final class GoogleMap {
    public static final int MAP_TYPE_NONE = 0;
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    public static final int MAP_TYPE_TERRAIN = 3;
    public static final int MAP_TYPE_HYBRID = 4;
    private final IGoogleMapDelegate zzaRr;
    private UiSettings zzaRs;

    protected GoogleMap(IGoogleMapDelegate map) {
        this.zzaRr = (IGoogleMapDelegate)zzx.zzz((Object)map);
    }

    IGoogleMapDelegate zzzJ() {
        return this.zzaRr;
    }

    public final CameraPosition getCameraPosition() {
        try {
            return this.zzaRr.getCameraPosition();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMaxZoomLevel() {
        try {
            return this.zzaRr.getMaxZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final float getMinZoomLevel() {
        try {
            return this.zzaRr.getMinZoomLevel();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void moveCamera(CameraUpdate update) {
        try {
            this.zzaRr.moveCamera(update.zzzH());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update) {
        try {
            this.zzaRr.animateCamera(update.zzzH());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update, CancelableCallback callback) {
        try {
            this.zzaRr.animateCameraWithCallback(update.zzzH(), callback == null ? null : new zza(callback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void animateCamera(CameraUpdate update, int durationMs, CancelableCallback callback) {
        try {
            this.zzaRr.animateCameraWithDurationAndCallback(update.zzzH(), durationMs, callback == null ? null : new zza(callback));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void stopAnimation() {
        try {
            this.zzaRr.stopAnimation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polyline addPolyline(PolylineOptions options) {
        try {
            return new Polyline(this.zzaRr.addPolyline(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Polygon addPolygon(PolygonOptions options) {
        try {
            return new Polygon(this.zzaRr.addPolygon(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Circle addCircle(CircleOptions options) {
        try {
            return new Circle(this.zzaRr.addCircle(options));
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Marker addMarker(MarkerOptions options) {
        try {
            zzf zzf2 = this.zzaRr.addMarker(options);
            if (zzf2 != null) {
                return new Marker(zzf2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final GroundOverlay addGroundOverlay(GroundOverlayOptions options) {
        try {
            zzc zzc2 = this.zzaRr.addGroundOverlay(options);
            if (zzc2 != null) {
                return new GroundOverlay(zzc2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final TileOverlay addTileOverlay(TileOverlayOptions options) {
        try {
            zzh zzh2 = this.zzaRr.addTileOverlay(options);
            if (zzh2 != null) {
                return new TileOverlay(zzh2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void clear() {
        try {
            this.zzaRr.clear();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public IndoorBuilding getFocusedBuilding() {
        try {
            zzd zzd2 = this.zzaRr.getFocusedBuilding();
            if (zzd2 != null) {
                return new IndoorBuilding(zzd2);
            }
            return null;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnIndoorStateChangeListener(final OnIndoorStateChangeListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnIndoorStateChangeListener(null);
            } else {
                this.zzaRr.setOnIndoorStateChangeListener(new zzg.zza(){

                    @Override
                    public void onIndoorBuildingFocused() {
                        listener.onIndoorBuildingFocused();
                    }

                    @Override
                    public void zza(zzd zzd2) {
                        listener.onIndoorLevelActivated(new IndoorBuilding(zzd2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final int getMapType() {
        try {
            return this.zzaRr.getMapType();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setMapType(int type) {
        try {
            this.zzaRr.setMapType(type);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isTrafficEnabled() {
        try {
            return this.zzaRr.isTrafficEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setTrafficEnabled(boolean enabled) {
        try {
            this.zzaRr.setTrafficEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isIndoorEnabled() {
        try {
            return this.zzaRr.isIndoorEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean setIndoorEnabled(boolean enabled) {
        try {
            return this.zzaRr.setIndoorEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isBuildingsEnabled() {
        try {
            return this.zzaRr.isBuildingsEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setBuildingsEnabled(boolean enabled) {
        try {
            this.zzaRr.setBuildingsEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final boolean isMyLocationEnabled() {
        try {
            return this.zzaRr.isMyLocationEnabled();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public final void setMyLocationEnabled(boolean enabled) {
        try {
            this.zzaRr.setMyLocationEnabled(enabled);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final Location getMyLocation() {
        try {
            return this.zzaRr.getMyLocation();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setLocationSource(final LocationSource source) {
        try {
            if (source == null) {
                this.zzaRr.setLocationSource(null);
            } else {
                this.zzaRr.setLocationSource(new ILocationSourceDelegate.zza(){

                    @Override
                    public void activate(final zzk listener) {
                        source.activate(new LocationSource.OnLocationChangedListener(){

                            @Override
                            public void onLocationChanged(Location location) {
                                try {
                                    listener.zzd(location);
                                }
                                catch (RemoteException remoteException) {
                                    throw new RuntimeRemoteException(remoteException);
                                }
                            }
                        });
                    }

                    @Override
                    public void deactivate() {
                        source.deactivate();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final UiSettings getUiSettings() {
        try {
            if (this.zzaRs == null) {
                this.zzaRs = new UiSettings(this.zzaRr.getUiSettings());
            }
            return this.zzaRs;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final Projection getProjection() {
        try {
            return new Projection(this.zzaRr.getProjection());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnCameraChangeListener(final OnCameraChangeListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnCameraChangeListener(null);
            } else {
                this.zzaRr.setOnCameraChangeListener(new zze.zza(){

                    @Override
                    public void onCameraChange(CameraPosition position) {
                        listener.onCameraChange(position);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapClickListener(final OnMapClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMapClickListener(null);
            } else {
                this.zzaRr.setOnMapClickListener(new zzl.zza(){

                    @Override
                    public void onMapClick(LatLng point) {
                        listener.onMapClick(point);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMapLongClickListener(final OnMapLongClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMapLongClickListener(null);
            } else {
                this.zzaRr.setOnMapLongClickListener(new zzn.zza(){

                    @Override
                    public void onMapLongClick(LatLng point) {
                        listener.onMapLongClick(point);
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerClickListener(final OnMarkerClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMarkerClickListener(null);
            } else {
                this.zzaRr.setOnMarkerClickListener(new zzp.zza(){

                    @Override
                    public boolean zzd(zzf zzf2) {
                        return listener.onMarkerClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMarkerDragListener(final OnMarkerDragListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMarkerDragListener(null);
            } else {
                this.zzaRr.setOnMarkerDragListener(new zzq.zza(){

                    @Override
                    public void zze(zzf zzf2) {
                        listener.onMarkerDragStart(new Marker(zzf2));
                    }

                    @Override
                    public void zzf(zzf zzf2) {
                        listener.onMarkerDragEnd(new Marker(zzf2));
                    }

                    @Override
                    public void zzg(zzf zzf2) {
                        listener.onMarkerDrag(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowClickListener(final OnInfoWindowClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnInfoWindowClickListener(null);
            } else {
                this.zzaRr.setOnInfoWindowClickListener(new zzh.zza(){

                    @Override
                    public void zzh(zzf zzf2) {
                        listener.onInfoWindowClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowLongClickListener(final OnInfoWindowLongClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnInfoWindowLongClickListener(null);
            } else {
                this.zzaRr.setOnInfoWindowLongClickListener(new zzj.zza(){

                    @Override
                    public void zzi(zzf zzf2) {
                        listener.onInfoWindowLongClick(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnInfoWindowCloseListener(final OnInfoWindowCloseListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnInfoWindowCloseListener(null);
            } else {
                this.zzaRr.setOnInfoWindowCloseListener(new zzi.zza(){

                    @Override
                    public void zza(zzf zzf2) {
                        listener.onInfoWindowClose(new Marker(zzf2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setInfoWindowAdapter(final InfoWindowAdapter adapter) {
        try {
            if (adapter == null) {
                this.zzaRr.setInfoWindowAdapter(null);
            } else {
                this.zzaRr.setInfoWindowAdapter(new zzd.zza(){

                    @Override
                    public com.google.android.gms.dynamic.zzd zzb(zzf zzf2) {
                        return zze.zzC((Object)adapter.getInfoWindow(new Marker(zzf2)));
                    }

                    @Override
                    public com.google.android.gms.dynamic.zzd zzc(zzf zzf2) {
                        return zze.zzC((Object)adapter.getInfoContents(new Marker(zzf2)));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    @Deprecated
    public final void setOnMyLocationChangeListener(final OnMyLocationChangeListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMyLocationChangeListener(null);
            } else {
                this.zzaRr.setOnMyLocationChangeListener(new zzs.zza(){

                    @Override
                    public void zzq(com.google.android.gms.dynamic.zzd zzd2) {
                        listener.onMyLocationChange((Location)zze.zzp((com.google.android.gms.dynamic.zzd)zzd2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnMyLocationButtonClickListener(final OnMyLocationButtonClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnMyLocationButtonClickListener(null);
            } else {
                this.zzaRr.setOnMyLocationButtonClickListener(new zzr.zza(){

                    @Override
                    public boolean onMyLocationButtonClick() throws RemoteException {
                        return listener.onMyLocationButtonClick();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public void setOnMapLoadedCallback(final OnMapLoadedCallback callback) {
        try {
            if (callback == null) {
                this.zzaRr.setOnMapLoadedCallback(null);
            } else {
                this.zzaRr.setOnMapLoadedCallback(new zzm.zza(){

                    @Override
                    public void onMapLoaded() throws RemoteException {
                        callback.onMapLoaded();
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnGroundOverlayClickListener(final OnGroundOverlayClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnGroundOverlayClickListener(null);
            } else {
                this.zzaRr.setOnGroundOverlayClickListener(new zzf.zza(){

                    @Override
                    public void zza(zzc zzc2) {
                        listener.onGroundOverlayClick(new GroundOverlay(zzc2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolygonClickListener(final OnPolygonClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnPolygonClickListener(null);
            } else {
                this.zzaRr.setOnPolygonClickListener(new zzu.zza(){

                    @Override
                    public void zza(zzg zzg2) {
                        listener.onPolygonClick(new Polygon(zzg2));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setOnPolylineClickListener(final OnPolylineClickListener listener) {
        try {
            if (listener == null) {
                this.zzaRr.setOnPolylineClickListener(null);
            } else {
                this.zzaRr.setOnPolylineClickListener(new zzv.zza(){

                    @Override
                    public void zza(IPolylineDelegate iPolylineDelegate) {
                        listener.onPolylineClick(new Polyline(iPolylineDelegate));
                    }
                });
            }
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void snapshot(SnapshotReadyCallback callback) {
        this.snapshot(callback, null);
    }

    public final void snapshot(final SnapshotReadyCallback callback, Bitmap bitmap) {
        zze zze2 = (zze)(bitmap != null ? zze.zzC((Object)bitmap) : null);
        try {
            this.zzaRr.snapshot(new zzab.zza(){

                @Override
                public void onSnapshotReady(Bitmap snapshot) throws RemoteException {
                    callback.onSnapshotReady(snapshot);
                }

                @Override
                public void zzr(com.google.android.gms.dynamic.zzd zzd2) throws RemoteException {
                    callback.onSnapshotReady((Bitmap)zze.zzp((com.google.android.gms.dynamic.zzd)zzd2));
                }
            }, (com.google.android.gms.dynamic.zzd)zze2);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        try {
            this.zzaRr.setPadding(left, top, right, bottom);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    public final void setContentDescription(String description) {
        try {
            this.zzaRr.setContentDescription(description);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
    }

    private static final class zza
    extends zzb.zza {
        private final CancelableCallback zzaRO;

        zza(CancelableCallback cancelableCallback) {
            this.zzaRO = cancelableCallback;
        }

        @Override
        public void onFinish() {
            this.zzaRO.onFinish();
        }

        @Override
        public void onCancel() {
            this.zzaRO.onCancel();
        }
    }

    public static interface OnGroundOverlayClickListener {
        public void onGroundOverlayClick(GroundOverlay var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMyLocationButtonClickListener {
        public boolean onMyLocationButtonClick();
    }

    @Deprecated
    public static interface OnMyLocationChangeListener {
        public void onMyLocationChange(Location var1);
    }

    public static interface InfoWindowAdapter {
        public View getInfoWindow(Marker var1);

        public View getInfoContents(Marker var1);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface CancelableCallback {
        public void onFinish();

        public void onCancel();
    }

    public static interface OnInfoWindowCloseListener {
        public void onInfoWindowClose(Marker var1);
    }

    public static interface OnInfoWindowLongClickListener {
        public void onInfoWindowLongClick(Marker var1);
    }

    public static interface OnInfoWindowClickListener {
        public void onInfoWindowClick(Marker var1);
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDragStart(Marker var1);

        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public void onPolylineClick(Polyline var1);
    }

    public static interface OnPolygonClickListener {
        public void onPolygonClick(Polygon var1);
    }

    public static interface OnCameraChangeListener {
        public void onCameraChange(CameraPosition var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);
    }

    public static interface OnIndoorStateChangeListener {
        public void onIndoorBuildingFocused();

        public void onIndoorLevelActivated(IndoorBuilding var1);
    }
}

