/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.dynamic.LifecycleDelegate;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamic.zzf;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapsInitializer;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.internal.IGoogleMapDelegate;
import com.google.android.gms.maps.internal.IMapFragmentDelegate;
import com.google.android.gms.maps.internal.MapLifecycleDelegate;
import com.google.android.gms.maps.internal.zzac;
import com.google.android.gms.maps.internal.zzad;
import com.google.android.gms.maps.internal.zzo;
import com.google.android.gms.maps.model.RuntimeRemoteException;
import java.util.ArrayList;
import java.util.List;

public class SupportMapFragment
extends Fragment {
    private final zzb zzbaf = new zzb(this);
    private GoogleMap zzaZt;

    public static SupportMapFragment newInstance() {
        return new SupportMapFragment();
    }

    public static SupportMapFragment newInstance(GoogleMapOptions googleMapOptions) {
        SupportMapFragment supportMapFragment = new SupportMapFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        supportMapFragment.setArguments(bundle);
        return supportMapFragment;
    }

    protected IMapFragmentDelegate zzDE() {
        this.zzbaf.zzDF();
        if (this.zzbaf.zzxd() == null) {
            return null;
        }
        return ((zza)this.zzbaf.zzxd()).zzDE();
    }

    @Deprecated
    public final GoogleMap getMap() {
        IGoogleMapDelegate iGoogleMapDelegate;
        IMapFragmentDelegate iMapFragmentDelegate = this.zzDE();
        if (iMapFragmentDelegate == null) {
            return null;
        }
        try {
            iGoogleMapDelegate = iMapFragmentDelegate.getMap();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeRemoteException(remoteException);
        }
        if (iGoogleMapDelegate == null) {
            return null;
        }
        if (this.zzaZt == null || this.zzaZt.zzDs().asBinder() != iGoogleMapDelegate.asBinder()) {
            this.zzaZt = new GoogleMap(iGoogleMapDelegate);
        }
        return this.zzaZt;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.zzbaf.setActivity(activity);
    }

    public void onInflate(Activity activity, AttributeSet attributeSet, Bundle bundle) {
        super.onInflate(activity, attributeSet, bundle);
        this.zzbaf.setActivity(activity);
        GoogleMapOptions googleMapOptions = GoogleMapOptions.createFromAttributes((Context)activity, attributeSet);
        Bundle bundle2 = new Bundle();
        bundle2.putParcelable("MapOptions", (Parcelable)googleMapOptions);
        this.zzbaf.onInflate(activity, bundle2, bundle);
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbaf.onCreate(bundle);
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        View view = this.zzbaf.onCreateView(layoutInflater, viewGroup, bundle);
        view.setClickable(true);
        return view;
    }

    public void onResume() {
        super.onResume();
        this.zzbaf.onResume();
    }

    public void onPause() {
        this.zzbaf.onPause();
        super.onPause();
    }

    public void onDestroyView() {
        this.zzbaf.onDestroyView();
        super.onDestroyView();
    }

    public void onDestroy() {
        this.zzbaf.onDestroy();
        super.onDestroy();
    }

    public void onLowMemory() {
        this.zzbaf.onLowMemory();
        super.onLowMemory();
    }

    public void onActivityCreated(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onActivityCreated(bundle);
    }

    public void onSaveInstanceState(Bundle bundle) {
        if (bundle != null) {
            bundle.setClassLoader(SupportMapFragment.class.getClassLoader());
        }
        super.onSaveInstanceState(bundle);
        this.zzbaf.onSaveInstanceState(bundle);
    }

    public final void onEnterAmbient(Bundle bundle) {
        zzaa.zzdc((String)"onEnterAmbient must be called on the main thread.");
        this.zzbaf.onEnterAmbient(bundle);
    }

    public final void onExitAmbient() {
        zzaa.zzdc((String)"onExitAmbient must be called on the main thread.");
        this.zzbaf.onExitAmbient();
    }

    public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
        zzaa.zzdc((String)"getMapAsync must be called on the main thread.");
        this.zzbaf.getMapAsync(onMapReadyCallback);
    }

    public void setArguments(Bundle bundle) {
        super.setArguments(bundle);
    }

    static class zzb
    extends com.google.android.gms.dynamic.zza<zza> {
        private final Fragment zzaCl;
        protected zzf<zza> zzaZx;
        private Activity mActivity;
        private final List<OnMapReadyCallback> zzaZy = new ArrayList<OnMapReadyCallback>();

        zzb(Fragment fragment) {
            this.zzaCl = fragment;
        }

        protected void zza(zzf<zza> zzf2) {
            this.zzaZx = zzf2;
            this.zzDF();
        }

        public void zzDF() {
            if (this.mActivity != null && this.zzaZx != null && this.zzxd() == null) {
                try {
                    MapsInitializer.initialize((Context)this.mActivity);
                    IMapFragmentDelegate iMapFragmentDelegate = zzad.zzaZ((Context)this.mActivity).zzA(zze.zzD((Object)this.mActivity));
                    if (iMapFragmentDelegate == null) {
                        return;
                    }
                    this.zzaZx.zza((LifecycleDelegate)new zza(this.zzaCl, iMapFragmentDelegate));
                    for (OnMapReadyCallback onMapReadyCallback : this.zzaZy) {
                        ((zza)this.zzxd()).getMapAsync(onMapReadyCallback);
                    }
                    this.zzaZy.clear();
                }
                catch (RemoteException remoteException) {
                    throw new RuntimeRemoteException(remoteException);
                }
                catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
                    // empty catch block
                }
            }
        }

        private void setActivity(Activity activity) {
            this.mActivity = activity;
            this.zzDF();
        }

        public void getMapAsync(OnMapReadyCallback onMapReadyCallback) {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).getMapAsync(onMapReadyCallback);
            } else {
                this.zzaZy.add(onMapReadyCallback);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).onEnterAmbient(bundle);
            }
        }

        public void onExitAmbient() {
            if (this.zzxd() != null) {
                ((zza)this.zzxd()).onExitAmbient();
            }
        }
    }

    static class zza
    implements MapLifecycleDelegate {
        private final Fragment zzaCl;
        private final IMapFragmentDelegate zzaZu;

        public zza(Fragment fragment, IMapFragmentDelegate iMapFragmentDelegate) {
            this.zzaZu = (IMapFragmentDelegate)zzaa.zzz((Object)iMapFragmentDelegate);
            this.zzaCl = (Fragment)zzaa.zzz((Object)fragment);
        }

        public void onInflate(Activity activity, Bundle bundle, Bundle bundle2) {
            GoogleMapOptions googleMapOptions = (GoogleMapOptions)bundle.getParcelable("MapOptions");
            try {
                this.zzaZu.onInflate(zze.zzD((Object)activity), googleMapOptions, bundle2);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onCreate(Bundle bundle) {
            try {
                Bundle bundle2;
                if (bundle == null) {
                    bundle = new Bundle();
                }
                if ((bundle2 = this.zzaCl.getArguments()) != null && bundle2.containsKey("MapOptions")) {
                    zzac.zza(bundle, "MapOptions", bundle2.getParcelable("MapOptions"));
                }
                this.zzaZu.onCreate(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
            zzd zzd2;
            try {
                zzd2 = this.zzaZu.onCreateView(zze.zzD((Object)layoutInflater), zze.zzD((Object)viewGroup), bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
            return (View)zze.zzx((zzd)zzd2);
        }

        public void onStart() {
        }

        public void onResume() {
            try {
                this.zzaZu.onResume();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onPause() {
            try {
                this.zzaZu.onPause();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onStop() {
        }

        public void onDestroyView() {
            try {
                this.zzaZu.onDestroyView();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onDestroy() {
            try {
                this.zzaZu.onDestroy();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onLowMemory() {
            try {
                this.zzaZu.onLowMemory();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onSaveInstanceState(Bundle bundle) {
            try {
                this.zzaZu.onSaveInstanceState(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public IMapFragmentDelegate zzDE() {
            return this.zzaZu;
        }

        @Override
        public void getMapAsync(final OnMapReadyCallback onMapReadyCallback) {
            try {
                this.zzaZu.getMapAsync(new zzo.zza(){

                    @Override
                    public void zza(IGoogleMapDelegate iGoogleMapDelegate) throws RemoteException {
                        onMapReadyCallback.onMapReady(new GoogleMap(iGoogleMapDelegate));
                    }
                });
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onEnterAmbient(Bundle bundle) {
            try {
                this.zzaZu.onEnterAmbient(bundle);
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }

        public void onExitAmbient() {
            try {
                this.zzaZu.onExitAmbient();
            }
            catch (RemoteException remoteException) {
                throw new RuntimeRemoteException(remoteException);
            }
        }
    }
}

