/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzk;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.zza;
import com.google.firebase.iid.FirebaseInstanceId;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class FirebaseAnalytics {
    private static volatile FirebaseAnalytics zzbsa;
    private final zzbt zzadj;
    private String zzbsb;
    private long zzbsc;
    private final Object zzbsd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @Keep
    @NonNull
    public static FirebaseAnalytics getInstance(@NonNull Context context) {
        if (zzbsa != null) return zzbsa;
        Class<FirebaseAnalytics> clazz = FirebaseAnalytics.class;
        synchronized (FirebaseAnalytics.class) {
            if (zzbsa != null) return zzbsa;
            zzbt zzbt2 = zzbt.zza((Context)context, null);
            zzbsa = new FirebaseAnalytics(zzbt2);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzbsa;
        }
    }

    public final void logEvent(@NonNull @Size(min=1L, max=40L) String string, @Nullable Bundle bundle) {
        this.zzadj.zzki().logEvent(string, bundle);
    }

    public final void setUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        this.zzadj.zzki().setUserProperty(string, string2);
    }

    @MainThread
    @Keep
    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!zzk.isMainThread()) {
            this.zzadj.zzgo().zzjg().zzbx("setCurrentScreen must be called from the main thread");
            return;
        }
        this.zzadj.zzgh().setCurrentScreen(activity, string, string2);
    }

    public final void setAnalyticsCollectionEnabled(boolean bl) {
        this.zzadj.zzki().setMeasurementEnabled(bl);
    }

    public final void setUserId(@Nullable String string) {
        String string2 = string;
        this.zzadj.zzki().setUserPropertyInternal("app", "_id", (Object)string2);
    }

    public final void setMinimumSessionDuration(long l) {
        this.zzadj.zzki().setMinimumSessionDuration(l);
    }

    public final void setSessionTimeoutDuration(long l) {
        this.zzadj.zzki().setSessionTimeoutDuration(l);
    }

    @NonNull
    public final Task<String> getAppInstanceId() {
        try {
            String string = this.zzfx();
            if (string != null) {
                return Tasks.forResult((Object)string);
            }
            return Tasks.call((Executor)this.zzadj.zzgn().zzkc(), (Callable)new zza(this));
        }
        catch (Exception exception) {
            this.zzadj.zzgo().zzjg().zzbx("Failed to schedule task for getAppInstanceId");
            return Tasks.forException((Exception)exception);
        }
    }

    private FirebaseAnalytics(zzbt zzbt2) {
        Preconditions.checkNotNull((Object)zzbt2);
        this.zzadj = zzbt2;
        this.zzbsd = new Object();
    }

    public final void resetAnalyticsData() {
        this.zzcm(null);
        this.zzadj.zzge().resetAnalyticsData(this.zzadj.zzbx().currentTimeMillis());
    }

    @Keep
    public final String getFirebaseInstanceId() {
        return FirebaseInstanceId.getInstance().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcm(String string) {
        Object object = this.zzbsd;
        synchronized (object) {
            this.zzbsb = string;
            this.zzbsc = this.zzadj.zzbx().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzfx() {
        Object object = this.zzbsd;
        synchronized (object) {
            if (Math.abs(this.zzadj.zzbx().elapsedRealtime() - this.zzbsc) < 1000L) {
                return this.zzbsb;
            }
            return null;
        }
    }

    static /* synthetic */ String zza(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzfx();
    }

    static /* synthetic */ zzbt zzb(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzadj;
    }

    static /* synthetic */ void zza(FirebaseAnalytics firebaseAnalytics, String string) {
        firebaseAnalytics.zzcm(string);
    }

    public static class UserProperty {
        public static final String SIGN_UP_METHOD = "sign_up_method";

        protected UserProperty() {
        }
    }

    public static class Param {
        public static final String ACHIEVEMENT_ID = "achievement_id";
        public static final String CHARACTER = "character";
        public static final String TRAVEL_CLASS = "travel_class";
        public static final String CONTENT_TYPE = "content_type";
        public static final String CURRENCY = "currency";
        public static final String COUPON = "coupon";
        public static final String START_DATE = "start_date";
        public static final String END_DATE = "end_date";
        public static final String FLIGHT_NUMBER = "flight_number";
        public static final String GROUP_ID = "group_id";
        public static final String ITEM_CATEGORY = "item_category";
        public static final String ITEM_ID = "item_id";
        public static final String ITEM_LOCATION_ID = "item_location_id";
        public static final String ITEM_NAME = "item_name";
        public static final String LOCATION = "location";
        public static final String LEVEL = "level";
        public static final String LEVEL_NAME = "level_name";
        @Deprecated
        public static final String SIGN_UP_METHOD = "sign_up_method";
        public static final String METHOD = "method";
        public static final String NUMBER_OF_NIGHTS = "number_of_nights";
        public static final String NUMBER_OF_PASSENGERS = "number_of_passengers";
        public static final String NUMBER_OF_ROOMS = "number_of_rooms";
        public static final String DESTINATION = "destination";
        public static final String ORIGIN = "origin";
        public static final String PRICE = "price";
        public static final String QUANTITY = "quantity";
        public static final String SCORE = "score";
        public static final String SHIPPING = "shipping";
        public static final String TRANSACTION_ID = "transaction_id";
        public static final String SEARCH_TERM = "search_term";
        public static final String SUCCESS = "success";
        public static final String TAX = "tax";
        public static final String VALUE = "value";
        public static final String VIRTUAL_CURRENCY_NAME = "virtual_currency_name";
        public static final String CAMPAIGN = "campaign";
        public static final String SOURCE = "source";
        public static final String MEDIUM = "medium";
        public static final String TERM = "term";
        public static final String CONTENT = "content";
        public static final String ACLID = "aclid";
        public static final String CP1 = "cp1";
        public static final String ITEM_BRAND = "item_brand";
        public static final String ITEM_VARIANT = "item_variant";
        public static final String ITEM_LIST = "item_list";
        public static final String CHECKOUT_STEP = "checkout_step";
        public static final String CHECKOUT_OPTION = "checkout_option";
        public static final String CREATIVE_NAME = "creative_name";
        public static final String CREATIVE_SLOT = "creative_slot";
        public static final String AFFILIATION = "affiliation";
        public static final String INDEX = "index";

        protected Param() {
        }
    }

    public static class Event {
        public static final String ADD_PAYMENT_INFO = "add_payment_info";
        public static final String ADD_TO_CART = "add_to_cart";
        public static final String ADD_TO_WISHLIST = "add_to_wishlist";
        public static final String APP_OPEN = "app_open";
        public static final String BEGIN_CHECKOUT = "begin_checkout";
        public static final String CAMPAIGN_DETAILS = "campaign_details";
        public static final String ECOMMERCE_PURCHASE = "ecommerce_purchase";
        public static final String GENERATE_LEAD = "generate_lead";
        public static final String JOIN_GROUP = "join_group";
        public static final String LEVEL_END = "level_end";
        public static final String LEVEL_START = "level_start";
        public static final String LEVEL_UP = "level_up";
        public static final String LOGIN = "login";
        public static final String POST_SCORE = "post_score";
        public static final String PRESENT_OFFER = "present_offer";
        public static final String PURCHASE_REFUND = "purchase_refund";
        public static final String SEARCH = "search";
        public static final String SELECT_CONTENT = "select_content";
        public static final String SHARE = "share";
        public static final String SIGN_UP = "sign_up";
        public static final String SPEND_VIRTUAL_CURRENCY = "spend_virtual_currency";
        public static final String TUTORIAL_BEGIN = "tutorial_begin";
        public static final String TUTORIAL_COMPLETE = "tutorial_complete";
        public static final String UNLOCK_ACHIEVEMENT = "unlock_achievement";
        public static final String VIEW_ITEM = "view_item";
        public static final String VIEW_ITEM_LIST = "view_item_list";
        public static final String VIEW_SEARCH_RESULTS = "view_search_results";
        public static final String EARN_VIRTUAL_CURRENCY = "earn_virtual_currency";
        public static final String REMOVE_FROM_CART = "remove_from_cart";
        public static final String CHECKOUT_PROGRESS = "checkout_progress";
        public static final String SET_CHECKOUT_OPTION = "set_checkout_option";

        protected Event() {
        }
    }
}

