/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zzd;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.analytics.connector.zzb;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzacb;
    @VisibleForTesting
    private final AppMeasurement zzacc;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zzacd;

    private AnalyticsConnectorImpl(AppMeasurement appMeasurement) {
        Preconditions.checkNotNull((Object)appMeasurement);
        this.zzacc = appMeasurement;
        this.zzacd = new ConcurrentHashMap<String, com.google.firebase.analytics.connector.internal.zza>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp, Context context, Subscriber subscriber) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzacb != null) return zzacb;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            if (zzacb != null) return zzacb;
            Bundle bundle = new Bundle(1);
            if (firebaseApp.isDefaultApp()) {
                subscriber.subscribe(DataCollectionDefaultChange.class, zzb.zzacf, zza.zzace);
                bundle.putBoolean("dataCollectionDefaultEnabled", firebaseApp.isDataCollectionDefaultEnabled());
            }
            zzacb = new AnalyticsConnectorImpl(AppMeasurement.zza((Context)context, (Bundle)bundle));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzacb;
        }
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    public static AnalyticsConnector getInstance(FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!zzd.zzdj(string)) {
            return;
        }
        if (!zzd.zza(string2, bundle)) {
            return;
        }
        if (!zzd.zzb(string, string2, bundle)) {
            return;
        }
        this.zzacc.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, Object object) {
        if (!zzd.zzdj(string)) {
            return;
        }
        if (!zzd.zzu(string, string2)) {
            return;
        }
        this.zzacc.setUserPropertyInternal(string, string2, object);
    }

    @WorkerThread
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzacc.getUserProperties(bl);
    }

    @WorkerThread
    @KeepForSdk
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @NonNull String string, AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        com.google.firebase.analytics.connector.internal.zza zza2;
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!zzd.zzdj(string)) {
            return null;
        }
        if (this.zzdi(string)) {
            return null;
        }
        AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener2 = analyticsConnectorListener;
        AppMeasurement appMeasurement = this.zzacc;
        String string2 = string;
        if (("fiam".equals(string2) ? new zzc(appMeasurement, analyticsConnectorListener2) : (zza2 = "crash".equals(string2) ? new zze(appMeasurement, analyticsConnectorListener2) : null)) != null) {
            this.zzacd.put(string, zza2);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){

                public void unregister() {
                    if (!AnalyticsConnectorImpl.this.zzdi(string)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zzacd.get(string).zzrr();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    AnalyticsConnectorImpl.this.zzacd.remove(string);
                }

                @KeepForSdk
                public void registerEventNames(Set<String> set) {
                    if (!AnalyticsConnectorImpl.this.zzdi(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzacd.get(string).registerEventNames(set);
                }

                @KeepForSdk
                public void unregisterEventNames() {
                    if (!AnalyticsConnectorImpl.this.zzdi(string) || !string.equals("fiam")) {
                        return;
                    }
                    AnalyticsConnectorImpl.this.zzacd.get(string).unregisterEventNames();
                }
            };
        }
        return null;
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!zzd.zza(conditionalUserProperty)) {
            return;
        }
        this.zzacc.setConditionalUserProperty(zzd.zzb(conditionalUserProperty));
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (string2 != null && !zzd.zza(string2, bundle)) {
            return;
        }
        this.zzacc.clearConditionalUserProperty(string, string2, bundle);
    }

    @WorkerThread
    @KeepForSdk
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Nullable @Size(min=1L, max=23L) String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzacc.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = zzd.zzb((AppMeasurement.ConditionalUserProperty)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzacc.getMaxUserProperties(string);
    }

    private final boolean zzdi(@NonNull String string) {
        return !string.isEmpty() && this.zzacd.containsKey(string) && this.zzacd.get(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            ((AnalyticsConnectorImpl)AnalyticsConnectorImpl.zzacb).zzacc.zza(bl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

