/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.zza;
import com.google.firebase.analytics.zzb;
import com.google.firebase.analytics.zzc;
import com.google.firebase.installations.FirebaseInstallations;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FirebaseAnalytics {
    private static volatile FirebaseAnalytics zza;
    private final zzbr zzb;
    private ExecutorService zzc;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @Keep
    @NonNull
    public static FirebaseAnalytics getInstance(@RecentlyNonNull Context context) {
        if (zza != null) return zza;
        Class<FirebaseAnalytics> clazz = FirebaseAnalytics.class;
        synchronized (clazz) {
            FirebaseAnalytics firebaseAnalytics = zza;
            if (firebaseAnalytics != null) return zza;
            context = zzbr.zza((Context)context, null, null, null, null);
            zza = firebaseAnalytics = new FirebaseAnalytics((zzbr)context);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public void logEvent(@RecentlyNonNull @Size(min=1L, max=40L) String string, @Nullable Bundle bundle) {
        this.zzb.zzg(string, bundle);
    }

    public void setDefaultEventParameters(@Nullable Bundle bundle) {
        this.zzb.zzJ(bundle);
    }

    public void setUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String string, @Nullable @Size(max=36L) String string2) {
        this.zzb.zzj(null, string, (Object)string2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setConsent(@RecentlyNonNull Map<ConsentType, ConsentStatus> object) {
        Bundle bundle = new Bundle();
        ConsentStatus consentStatus = (ConsentStatus)((Object)object.get((Object)ConsentType.AD_STORAGE));
        if (consentStatus != null) {
            switch (consentStatus.ordinal()) {
                case 1: {
                    bundle.putString("ad_storage", "denied");
                }
                default: {
                    break;
                }
                case 0: {
                    bundle.putString("ad_storage", "granted");
                }
            }
        }
        if ((object = (ConsentStatus)((Object)object.get((Object)ConsentType.ANALYTICS_STORAGE))) != null) {
            switch (((Enum)object).ordinal()) {
                case 1: {
                    bundle.putString("analytics_storage", "denied");
                }
                default: {
                    break;
                }
                case 0: {
                    bundle.putString("analytics_storage", "granted");
                }
            }
        }
        this.zzb.zzr(bundle);
    }

    @Deprecated
    @MainThread
    @Keep
    public void setCurrentScreen(@RecentlyNonNull Activity activity, @Nullable @Size(min=1L, max=36L) String string, @Nullable @Size(min=1L, max=36L) String string2) {
        this.zzb.zzo(activity, string, string2);
    }

    public void setAnalyticsCollectionEnabled(boolean bl) {
        this.zzb.zzp(Boolean.valueOf(bl));
    }

    public void setUserId(@Nullable String string) {
        this.zzb.zzn(string);
    }

    public void setSessionTimeoutDuration(long l) {
        this.zzb.zzt(l);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public Task<String> getAppInstanceId() {
        Object object;
        try {
            object = FirebaseAnalytics.class;
            // MONITORENTER : object
        }
        catch (Exception exception) {
            this.zzb.zzC(5, "Failed to schedule task for getAppInstanceId", null, null, null);
            return Tasks.forException((Exception)exception);
        }
        ExecutorService executorService = this.zzc;
        if (executorService == null) {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(100);
            this.zzc = executorService = new zza(this, 0, 1, 30L, timeUnit, arrayBlockingQueue);
        }
        executorService = this.zzc;
        // MONITOREXIT : object
        {
            catch (Throwable throwable) {}
            throw throwable;
        }
        object = new zzb(this);
        return Tasks.call((Executor)executorService, (Callable)object);
    }

    public void resetAnalyticsData() {
        this.zzb.zzs();
    }

    @Keep
    @RecentlyNonNull
    public String getFirebaseInstanceId() {
        Object object;
        try {
            object = FirebaseInstallations.getInstance().getId();
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            object = (String)Tasks.await((Task)object, (long)30000L, (TimeUnit)timeUnit);
        }
        catch (InterruptedException interruptedException) {
            IllegalStateException illegalStateException = new IllegalStateException(interruptedException);
            throw illegalStateException;
        }
        catch (ExecutionException executionException) {
            IllegalStateException illegalStateException = new IllegalStateException(executionException.getCause());
            throw illegalStateException;
        }
        catch (TimeoutException timeoutException) {
            object = new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
            throw object;
        }
        return object;
    }

    public FirebaseAnalytics(zzbr zzbr2) {
        Preconditions.checkNotNull((Object)zzbr2);
        this.zzb = zzbr2;
    }

    @Nullable
    @Keep
    public static zzhz getScionFrontendApiImplementation(Context context, @Nullable Bundle object) {
        if ((context = zzbr.zza((Context)context, null, null, null, (Bundle)object)) == null) {
            return null;
        }
        object = new zzc((zzbr)context);
        return object;
    }

    static /* synthetic */ zzbr zza(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzb;
    }

    public static final class ConsentStatus
    extends Enum<ConsentStatus> {
        @RecentlyNonNull
        public static final /* enum */ ConsentStatus GRANTED;
        @RecentlyNonNull
        public static final /* enum */ ConsentStatus DENIED;
        private static final /* synthetic */ ConsentStatus[] zza;

        @RecentlyNonNull
        public static ConsentStatus[] values() {
            return (ConsentStatus[])zza.clone();
        }

        @RecentlyNonNull
        public static ConsentStatus valueOf(@RecentlyNonNull String string) {
            return Enum.valueOf(ConsentStatus.class, string);
        }

        static {
            ConsentStatus[] consentStatusArray = new ConsentStatus();
            GRANTED = consentStatusArray;
            consentStatusArray = new ConsentStatus();
            DENIED = consentStatusArray;
            consentStatusArray = new ConsentStatus[]{GRANTED, DENIED};
            zza = consentStatusArray;
        }
    }

    public static final class ConsentType
    extends Enum<ConsentType> {
        @RecentlyNonNull
        public static final /* enum */ ConsentType AD_STORAGE;
        @RecentlyNonNull
        public static final /* enum */ ConsentType ANALYTICS_STORAGE;
        private static final /* synthetic */ ConsentType[] zza;

        @RecentlyNonNull
        public static ConsentType[] values() {
            return (ConsentType[])zza.clone();
        }

        @RecentlyNonNull
        public static ConsentType valueOf(@RecentlyNonNull String string) {
            return Enum.valueOf(ConsentType.class, string);
        }

        static {
            ConsentType[] consentTypeArray = new ConsentType();
            AD_STORAGE = consentTypeArray;
            consentTypeArray = new ConsentType();
            ANALYTICS_STORAGE = consentTypeArray;
            consentTypeArray = new ConsentType[]{AD_STORAGE, ANALYTICS_STORAGE};
            zza = consentTypeArray;
        }
    }

    public static class UserProperty {
        @RecentlyNonNull
        public static final String SIGN_UP_METHOD = "sign_up_method";
        @RecentlyNonNull
        public static final String ALLOW_AD_PERSONALIZATION_SIGNALS = "allow_personalized_ads";

        protected UserProperty() {
        }
    }

    public static class Param {
        @RecentlyNonNull
        public static final String ACHIEVEMENT_ID = "achievement_id";
        @RecentlyNonNull
        public static final String AD_FORMAT = "ad_format";
        @RecentlyNonNull
        public static final String AD_PLATFORM = "ad_platform";
        @RecentlyNonNull
        public static final String AD_SOURCE = "ad_source";
        @RecentlyNonNull
        public static final String AD_UNIT_NAME = "ad_unit_name";
        @RecentlyNonNull
        public static final String CHARACTER = "character";
        @RecentlyNonNull
        public static final String TRAVEL_CLASS = "travel_class";
        @RecentlyNonNull
        public static final String CONTENT_TYPE = "content_type";
        @RecentlyNonNull
        public static final String CURRENCY = "currency";
        @RecentlyNonNull
        public static final String COUPON = "coupon";
        @RecentlyNonNull
        public static final String START_DATE = "start_date";
        @RecentlyNonNull
        public static final String END_DATE = "end_date";
        @RecentlyNonNull
        public static final String EXTEND_SESSION = "extend_session";
        @RecentlyNonNull
        public static final String FLIGHT_NUMBER = "flight_number";
        @RecentlyNonNull
        public static final String GROUP_ID = "group_id";
        @RecentlyNonNull
        public static final String ITEM_CATEGORY = "item_category";
        @RecentlyNonNull
        public static final String ITEM_ID = "item_id";
        @Deprecated
        @RecentlyNonNull
        public static final String ITEM_LOCATION_ID = "item_location_id";
        @RecentlyNonNull
        public static final String ITEM_NAME = "item_name";
        @RecentlyNonNull
        public static final String LOCATION = "location";
        @RecentlyNonNull
        public static final String LEVEL = "level";
        @RecentlyNonNull
        public static final String LEVEL_NAME = "level_name";
        @Deprecated
        @RecentlyNonNull
        public static final String SIGN_UP_METHOD = "sign_up_method";
        @RecentlyNonNull
        public static final String METHOD = "method";
        @RecentlyNonNull
        public static final String NUMBER_OF_NIGHTS = "number_of_nights";
        @RecentlyNonNull
        public static final String NUMBER_OF_PASSENGERS = "number_of_passengers";
        @RecentlyNonNull
        public static final String NUMBER_OF_ROOMS = "number_of_rooms";
        @RecentlyNonNull
        public static final String DESTINATION = "destination";
        @RecentlyNonNull
        public static final String ORIGIN = "origin";
        @RecentlyNonNull
        public static final String PRICE = "price";
        @RecentlyNonNull
        public static final String QUANTITY = "quantity";
        @RecentlyNonNull
        public static final String SCORE = "score";
        @RecentlyNonNull
        public static final String SHIPPING = "shipping";
        @RecentlyNonNull
        public static final String TRANSACTION_ID = "transaction_id";
        @RecentlyNonNull
        public static final String SEARCH_TERM = "search_term";
        @RecentlyNonNull
        public static final String SUCCESS = "success";
        @RecentlyNonNull
        public static final String TAX = "tax";
        @RecentlyNonNull
        public static final String VALUE = "value";
        @RecentlyNonNull
        public static final String VIRTUAL_CURRENCY_NAME = "virtual_currency_name";
        @RecentlyNonNull
        public static final String CAMPAIGN = "campaign";
        @RecentlyNonNull
        public static final String SOURCE = "source";
        @RecentlyNonNull
        public static final String MEDIUM = "medium";
        @RecentlyNonNull
        public static final String TERM = "term";
        @RecentlyNonNull
        public static final String CONTENT = "content";
        @RecentlyNonNull
        public static final String ACLID = "aclid";
        @RecentlyNonNull
        public static final String CP1 = "cp1";
        @RecentlyNonNull
        public static final String ITEM_BRAND = "item_brand";
        @RecentlyNonNull
        public static final String ITEM_VARIANT = "item_variant";
        @Deprecated
        @RecentlyNonNull
        public static final String ITEM_LIST = "item_list";
        @Deprecated
        @RecentlyNonNull
        public static final String CHECKOUT_STEP = "checkout_step";
        @Deprecated
        @RecentlyNonNull
        public static final String CHECKOUT_OPTION = "checkout_option";
        @RecentlyNonNull
        public static final String CREATIVE_NAME = "creative_name";
        @RecentlyNonNull
        public static final String CREATIVE_SLOT = "creative_slot";
        @RecentlyNonNull
        public static final String AFFILIATION = "affiliation";
        @RecentlyNonNull
        public static final String INDEX = "index";
        @RecentlyNonNull
        public static final String DISCOUNT = "discount";
        @RecentlyNonNull
        public static final String ITEM_CATEGORY2 = "item_category2";
        @RecentlyNonNull
        public static final String ITEM_CATEGORY3 = "item_category3";
        @RecentlyNonNull
        public static final String ITEM_CATEGORY4 = "item_category4";
        @RecentlyNonNull
        public static final String ITEM_CATEGORY5 = "item_category5";
        @RecentlyNonNull
        public static final String ITEM_LIST_ID = "item_list_id";
        @RecentlyNonNull
        public static final String ITEM_LIST_NAME = "item_list_name";
        @RecentlyNonNull
        public static final String ITEMS = "items";
        @RecentlyNonNull
        public static final String LOCATION_ID = "location_id";
        @RecentlyNonNull
        public static final String PAYMENT_TYPE = "payment_type";
        @RecentlyNonNull
        public static final String PROMOTION_ID = "promotion_id";
        @RecentlyNonNull
        public static final String PROMOTION_NAME = "promotion_name";
        @RecentlyNonNull
        public static final String SCREEN_CLASS = "screen_class";
        @RecentlyNonNull
        public static final String SCREEN_NAME = "screen_name";
        @RecentlyNonNull
        public static final String SHIPPING_TIER = "shipping_tier";

        protected Param() {
        }
    }

    public static class Event {
        @RecentlyNonNull
        public static final String AD_IMPRESSION = "ad_impression";
        @RecentlyNonNull
        public static final String ADD_PAYMENT_INFO = "add_payment_info";
        @RecentlyNonNull
        public static final String ADD_TO_CART = "add_to_cart";
        @RecentlyNonNull
        public static final String ADD_TO_WISHLIST = "add_to_wishlist";
        @RecentlyNonNull
        public static final String APP_OPEN = "app_open";
        @RecentlyNonNull
        public static final String BEGIN_CHECKOUT = "begin_checkout";
        @RecentlyNonNull
        public static final String CAMPAIGN_DETAILS = "campaign_details";
        @Deprecated
        @RecentlyNonNull
        public static final String ECOMMERCE_PURCHASE = "ecommerce_purchase";
        @RecentlyNonNull
        public static final String GENERATE_LEAD = "generate_lead";
        @RecentlyNonNull
        public static final String JOIN_GROUP = "join_group";
        @RecentlyNonNull
        public static final String LEVEL_END = "level_end";
        @RecentlyNonNull
        public static final String LEVEL_START = "level_start";
        @RecentlyNonNull
        public static final String LEVEL_UP = "level_up";
        @RecentlyNonNull
        public static final String LOGIN = "login";
        @RecentlyNonNull
        public static final String POST_SCORE = "post_score";
        @Deprecated
        @RecentlyNonNull
        public static final String PRESENT_OFFER = "present_offer";
        @Deprecated
        @RecentlyNonNull
        public static final String PURCHASE_REFUND = "purchase_refund";
        @RecentlyNonNull
        public static final String SEARCH = "search";
        @RecentlyNonNull
        public static final String SELECT_CONTENT = "select_content";
        @RecentlyNonNull
        public static final String SHARE = "share";
        @RecentlyNonNull
        public static final String SIGN_UP = "sign_up";
        @RecentlyNonNull
        public static final String SPEND_VIRTUAL_CURRENCY = "spend_virtual_currency";
        @RecentlyNonNull
        public static final String TUTORIAL_BEGIN = "tutorial_begin";
        @RecentlyNonNull
        public static final String TUTORIAL_COMPLETE = "tutorial_complete";
        @RecentlyNonNull
        public static final String UNLOCK_ACHIEVEMENT = "unlock_achievement";
        @RecentlyNonNull
        public static final String VIEW_ITEM = "view_item";
        @RecentlyNonNull
        public static final String VIEW_ITEM_LIST = "view_item_list";
        @RecentlyNonNull
        public static final String VIEW_SEARCH_RESULTS = "view_search_results";
        @RecentlyNonNull
        public static final String EARN_VIRTUAL_CURRENCY = "earn_virtual_currency";
        @RecentlyNonNull
        public static final String SCREEN_VIEW = "screen_view";
        @RecentlyNonNull
        public static final String REMOVE_FROM_CART = "remove_from_cart";
        @Deprecated
        @RecentlyNonNull
        public static final String CHECKOUT_PROGRESS = "checkout_progress";
        @Deprecated
        @RecentlyNonNull
        public static final String SET_CHECKOUT_OPTION = "set_checkout_option";
        @RecentlyNonNull
        public static final String ADD_SHIPPING_INFO = "add_shipping_info";
        @RecentlyNonNull
        public static final String PURCHASE = "purchase";
        @RecentlyNonNull
        public static final String REFUND = "refund";
        @RecentlyNonNull
        public static final String SELECT_ITEM = "select_item";
        @RecentlyNonNull
        public static final String SELECT_PROMOTION = "select_promotion";
        @RecentlyNonNull
        public static final String VIEW_CART = "view_cart";
        @RecentlyNonNull
        public static final String VIEW_PROMOTION = "view_promotion";

        protected Event() {
        }
    }
}

