/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbs;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzc;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.internal.zzg;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.analytics.connector.zzb;
import com.google.firebase.events.Event;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile AnalyticsConnector zzc;
    @VisibleForTesting
    final AppMeasurementSdk zza;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zzb;

    AnalyticsConnectorImpl(AppMeasurementSdk object) {
        Preconditions.checkNotNull((Object)object);
        this.zza = object;
        this.zzb = object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance(@RecentlyNonNull FirebaseApp app, @RecentlyNonNull Context context, @RecentlyNonNull Subscriber subscriber) {
        void var2_3;
        AppMeasurementSdk appMeasurementSdk;
        Preconditions.checkNotNull((Object)app);
        Preconditions.checkNotNull((Object)appMeasurementSdk);
        Preconditions.checkNotNull((Object)var2_3);
        Preconditions.checkNotNull((Object)appMeasurementSdk.getApplicationContext());
        if (zzc != null) return zzc;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (clazz) {
            Object object;
            AnalyticsConnector analyticsConnector = zzc;
            if (analyticsConnector != null) return zzc;
            analyticsConnector = new Bundle(1);
            boolean bl = object.isDefaultApp();
            if (bl) {
                Class<DataCollectionDefaultChange> clazz2 = DataCollectionDefaultChange.class;
                Executor executor = com.google.firebase.analytics.connector.zza.zza;
                var2_3.subscribe(clazz2, executor, com.google.firebase.analytics.connector.zzb.zza);
                analyticsConnector.putBoolean("dataCollectionDefaultEnabled", object.isDataCollectionDefaultEnabled());
            }
            appMeasurementSdk = zzbs.zza((Context)appMeasurementSdk, null, null, null, (Bundle)analyticsConnector).zzb();
            object = new AnalyticsConnectorImpl(appMeasurementSdk);
            zzc = object;
            return zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    @RecentlyNonNull
    public static AnalyticsConnector getInstance(@RecentlyNonNull FirebaseApp app) {
        return (AnalyticsConnector)app.get(AnalyticsConnector.class);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void logEvent(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Bundle params) {
        void var2_2;
        void var1_1;
        Bundle bundle;
        if (params == null) {
            bundle = new Bundle();
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zza((String)var1_1)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzb((String)var2_2, bundle)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzf((String)var1_1, (String)var2_2, bundle)) {
            return;
        }
        com.google.firebase.analytics.connector.internal.zzc.zzm((String)var1_1, (String)var2_2, bundle);
        this.zza.logEvent((String)var1_1, (String)var2_2, bundle);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setUserProperty(@RecentlyNonNull String origin, @RecentlyNonNull String name, @RecentlyNonNull Object value) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!com.google.firebase.analytics.connector.internal.zzc.zza(origin)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzc.zzd((String)var1_1, (String)var2_2)) {
            return;
        }
        this.zza.setUserProperty((String)var1_1, (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(boolean includeInternal) {
        void var1_1;
        return this.zza.getUserProperties(null, null, (boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(@RecentlyNonNull String origin, @RecentlyNonNull AnalyticsConnector.AnalyticsConnectorListener listener) {
        AnalyticsConnector.AnalyticsConnectorHandle analyticsConnectorHandle;
        void var1_1;
        Preconditions.checkNotNull((Object)listener);
        if (!com.google.firebase.analytics.connector.internal.zzc.zza((String)var1_1)) {
            return null;
        }
        if (this.zzc((String)var1_1)) {
            return null;
        }
        AppMeasurementSdk appMeasurementSdk = this.zza;
        if ("fiam".equals(var1_1)) {
            zze zze2 = new zze(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)analyticsConnectorHandle);
            analyticsConnectorHandle = zze2;
        } else {
            if (!"crash".equals(var1_1)) {
                if (!"clx".equals(var1_1)) return null;
            }
            zzg zzg2 = new zzg(appMeasurementSdk, (AnalyticsConnector.AnalyticsConnectorListener)analyticsConnectorHandle);
            analyticsConnectorHandle = zzg2;
        }
        if (analyticsConnectorHandle == null) return null;
        this.zzb.put((String)var1_1, (com.google.firebase.analytics.connector.internal.zza)analyticsConnectorHandle);
        return new AnalyticsConnector.AnalyticsConnectorHandle((String)var1_1){
            final /* synthetic */ String zza;
            {
                this.zza = string;
            }

            public final void unregister() {
                if (!AnalyticsConnectorImpl.this.zzc(this.zza)) {
                    return;
                }
                AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = AnalyticsConnectorImpl.this.zzb.get(this.zza).zza();
                if (analyticsConnectorListener != null) {
                    analyticsConnectorListener.onMessageTriggered(0, null);
                }
                AnalyticsConnectorImpl.this.zzb.remove(this.zza);
            }

            /*
             * WARNING - void declaration
             */
            @KeepForSdk
            public void registerEventNames(Set<String> eventNames) {
                void var1_1;
                if (!AnalyticsConnectorImpl.this.zzc(this.zza) || !this.zza.equals("fiam") || var1_1 == null || var1_1.isEmpty()) {
                    return;
                }
                AnalyticsConnectorImpl.this.zzb.get(this.zza).zzb((Set<String>)var1_1);
            }

            @KeepForSdk
            public void unregisterEventNames() {
                if (!AnalyticsConnectorImpl.this.zzc(this.zza) || !this.zza.equals("fiam")) {
                    return;
                }
                AnalyticsConnectorImpl.this.zzb.get(this.zza).zzc();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        void var1_1;
        if (!com.google.firebase.analytics.connector.internal.zzc.zze(conditionalUserProperty)) {
            return;
        }
        this.zza.setConditionalUserProperty(com.google.firebase.analytics.connector.internal.zzc.zzg((AnalyticsConnector.ConditionalUserProperty)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String userPropertyName, @RecentlyNonNull String clearEventName, @RecentlyNonNull Bundle clearEventParams) {
        void var1_1;
        void var3_3;
        void var2_2;
        if (clearEventName != null && !com.google.firebase.analytics.connector.internal.zzc.zzb((String)var2_2, (Bundle)var3_3)) {
            return;
        }
        this.zza.clearConditionalUserProperty((String)var1_1, (String)var2_2, (Bundle)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    @RecentlyNonNull
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@RecentlyNonNull String origin, @Size(min=1L, max=23L) @RecentlyNonNull String propertyNamePrefix) {
        void var2_2;
        void var1_1;
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = ((AnalyticsConnectorImpl)((Object)iterator)).zza.getConditionalUserProperties((String)var1_1, (String)var2_2).iterator();
        while (iterator.hasNext()) {
            arrayList.add(com.google.firebase.analytics.connector.internal.zzc.zzh((Bundle)iterator.next()));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String origin) {
        void var1_1;
        return this.zza.getMaxUserProperties((String)var1_1);
    }

    private final boolean zzc(@NonNull String string) {
        return !string.isEmpty() && this.zzb.containsKey(string) && this.zzb.get(string) != null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (clazz) {
            AnalyticsConnector analyticsConnector = zzc;
            ((AnalyticsConnectorImpl)Preconditions.checkNotNull((Object)analyticsConnector)).zza.zza(bl);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

