/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.analytics.zza;
import com.google.firebase.analytics.zzb;
import com.google.firebase.analytics.zzc;
import com.google.firebase.installations.FirebaseInstallations;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FirebaseAnalytics {
    private static volatile FirebaseAnalytics zza;
    private final zzee zzb;
    private ExecutorService zzc;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NonNull
    public Task<String> getAppInstanceId() {
        Object object;
        try {
            object = FirebaseAnalytics.class;
            // MONITORENTER : object
        }
        catch (RuntimeException runtimeException) {
            this.zzb.zzA(5, "Failed to schedule task for getAppInstanceId", null, null, null);
            return Tasks.forException((Exception)runtimeException);
        }
        ExecutorService executorService = this.zzc;
        if (executorService == null) {
            TimeUnit timeUnit = TimeUnit.SECONDS;
            ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(100);
            this.zzc = executorService = new zza(this, 0, 1, 30L, timeUnit, arrayBlockingQueue);
        }
        executorService = this.zzc;
        // MONITOREXIT : object
        {
            catch (Throwable throwable) {}
            throw throwable;
        }
        object = new zzb(this);
        return Tasks.call((Executor)executorService, (Callable)object);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @Keep
    @NonNull
    public static FirebaseAnalytics getInstance(@NonNull Context context) {
        if (zza != null) return zza;
        Class<FirebaseAnalytics> clazz = FirebaseAnalytics.class;
        synchronized (clazz) {
            Context context2;
            FirebaseAnalytics firebaseAnalytics = zza;
            if (firebaseAnalytics != null) return zza;
            context2 = zzee.zzg((Context)context2, null, null, null, null);
            zza = firebaseAnalytics = new FirebaseAnalytics((zzee)context2);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Keep
    @NonNull
    public String getFirebaseInstanceId() {
        Object object;
        try {
            object = (String)Tasks.await((Task)FirebaseInstallations.getInstance().getId(), (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            IllegalStateException illegalStateException = new IllegalStateException(interruptedException);
            throw illegalStateException;
        }
        catch (ExecutionException executionException) {
            IllegalStateException illegalStateException = new IllegalStateException(executionException.getCause());
            throw illegalStateException;
        }
        catch (TimeoutException timeoutException) {
            object = new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
            throw object;
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public void logEvent(@NonNull @Size(min=1L, max=40L) String name, @Nullable Bundle params) {
        void var2_2;
        void var1_1;
        this.zzb.zzx((String)var1_1, (Bundle)var2_2);
    }

    public void resetAnalyticsData() {
        this.zzb.zzC();
    }

    /*
     * WARNING - void declaration
     */
    public void setAnalyticsCollectionEnabled(boolean enabled) {
        void var1_1;
        this.zzb.zzK(Boolean.valueOf((boolean)var1_1));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setConsent(@NonNull Map<ConsentType, ConsentStatus> consentSettings) {
        ConsentStatus consentStatus;
        Bundle bundle = new Bundle();
        ConsentStatus consentStatus2 = (ConsentStatus)((Object)consentStatus.get((Object)ConsentType.AD_STORAGE));
        if (consentStatus2 != null) {
            switch (consentStatus2.ordinal()) {
                case 1: {
                    bundle.putString("ad_storage", "denied");
                }
                default: {
                    break;
                }
                case 0: {
                    bundle.putString("ad_storage", "granted");
                }
            }
        }
        if ((consentStatus = (ConsentStatus)((Object)consentStatus.get((Object)ConsentType.ANALYTICS_STORAGE))) != null) {
            switch (consentStatus.ordinal()) {
                case 1: {
                    bundle.putString("analytics_storage", "denied");
                }
                default: {
                    break;
                }
                case 0: {
                    bundle.putString("analytics_storage", "granted");
                }
            }
        }
        this.zzb.zzF(bundle);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @MainThread
    @Keep
    public void setCurrentScreen(@NonNull Activity activity, @Nullable @Size(min=1L, max=36L) String screenName, @Nullable @Size(min=1L, max=36L) String screenClassOverride) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.zzb.zzG((Activity)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultEventParameters(@Nullable Bundle parameters) {
        void var1_1;
        this.zzb.zzI((Bundle)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionTimeoutDuration(long milliseconds) {
        void var1_1;
        this.zzb.zzL((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserId(@Nullable String id) {
        void var1_1;
        this.zzb.zzM((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setUserProperty(@NonNull @Size(min=1L, max=24L) String name, @Nullable @Size(max=36L) String value) {
        void var2_2;
        void var1_1;
        this.zzb.zzN(null, (String)var1_1, (Object)var2_2, false);
    }

    static /* bridge */ /* synthetic */ zzee zza(FirebaseAnalytics firebaseAnalytics) {
        return firebaseAnalytics.zzb;
    }

    @Nullable
    @Keep
    public static zzio getScionFrontendApiImplementation(Context context, @Nullable Bundle extraParams) {
        zzc zzc2;
        Context context2 = zzee.zzg((Context)context, null, null, null, (Bundle)zzc2);
        if (context2 == null) {
            return null;
        }
        zzc2 = new zzc((zzee)context2);
        return zzc2;
    }

    public FirebaseAnalytics(zzee zzee2) {
        Preconditions.checkNotNull((Object)zzee2);
        this.zzb = zzee2;
    }

    public static final class ConsentStatus
    extends Enum<ConsentStatus> {
        @NonNull
        public static final /* enum */ ConsentStatus GRANTED;
        @NonNull
        public static final /* enum */ ConsentStatus DENIED;
        private static final /* synthetic */ ConsentStatus[] zza;

        @NonNull
        public static ConsentStatus valueOf(@NonNull String name) {
            String string;
            return Enum.valueOf(ConsentStatus.class, string);
        }

        static {
            ConsentStatus[] consentStatusArray = new ConsentStatus();
            GRANTED = consentStatusArray;
            consentStatusArray = new ConsentStatus();
            DENIED = consentStatusArray;
            consentStatusArray = new ConsentStatus[]{GRANTED, DENIED};
            zza = consentStatusArray;
        }

        @NonNull
        public static ConsentStatus[] values() {
            return (ConsentStatus[])zza.clone();
        }
    }

    public static final class ConsentType
    extends Enum<ConsentType> {
        @NonNull
        public static final /* enum */ ConsentType AD_STORAGE;
        @NonNull
        public static final /* enum */ ConsentType ANALYTICS_STORAGE;
        private static final /* synthetic */ ConsentType[] zza;

        @NonNull
        public static ConsentType valueOf(@NonNull String name) {
            String string;
            return Enum.valueOf(ConsentType.class, string);
        }

        static {
            ConsentType[] consentTypeArray = new ConsentType();
            AD_STORAGE = consentTypeArray;
            consentTypeArray = new ConsentType();
            ANALYTICS_STORAGE = consentTypeArray;
            consentTypeArray = new ConsentType[]{AD_STORAGE, ANALYTICS_STORAGE};
            zza = consentTypeArray;
        }

        @NonNull
        public static ConsentType[] values() {
            return (ConsentType[])zza.clone();
        }
    }

    public static class UserProperty {
        @NonNull
        public static final String SIGN_UP_METHOD = "sign_up_method";
        @NonNull
        public static final String ALLOW_AD_PERSONALIZATION_SIGNALS = "allow_personalized_ads";

        protected UserProperty() {
        }
    }

    public static class Param {
        @NonNull
        public static final String ACHIEVEMENT_ID = "achievement_id";
        @NonNull
        public static final String AD_FORMAT = "ad_format";
        @NonNull
        public static final String AD_PLATFORM = "ad_platform";
        @NonNull
        public static final String AD_SOURCE = "ad_source";
        @NonNull
        public static final String AD_UNIT_NAME = "ad_unit_name";
        @NonNull
        public static final String CHARACTER = "character";
        @NonNull
        public static final String TRAVEL_CLASS = "travel_class";
        @NonNull
        public static final String CONTENT_TYPE = "content_type";
        @NonNull
        public static final String CURRENCY = "currency";
        @NonNull
        public static final String COUPON = "coupon";
        @NonNull
        public static final String START_DATE = "start_date";
        @NonNull
        public static final String END_DATE = "end_date";
        @NonNull
        public static final String EXTEND_SESSION = "extend_session";
        @NonNull
        public static final String FLIGHT_NUMBER = "flight_number";
        @NonNull
        public static final String GROUP_ID = "group_id";
        @NonNull
        public static final String ITEM_CATEGORY = "item_category";
        @NonNull
        public static final String ITEM_ID = "item_id";
        @Deprecated
        @NonNull
        public static final String ITEM_LOCATION_ID = "item_location_id";
        @NonNull
        public static final String ITEM_NAME = "item_name";
        @NonNull
        public static final String LOCATION = "location";
        @NonNull
        public static final String LEVEL = "level";
        @NonNull
        public static final String LEVEL_NAME = "level_name";
        @Deprecated
        @NonNull
        public static final String SIGN_UP_METHOD = "sign_up_method";
        @NonNull
        public static final String METHOD = "method";
        @NonNull
        public static final String NUMBER_OF_NIGHTS = "number_of_nights";
        @NonNull
        public static final String NUMBER_OF_PASSENGERS = "number_of_passengers";
        @NonNull
        public static final String NUMBER_OF_ROOMS = "number_of_rooms";
        @NonNull
        public static final String DESTINATION = "destination";
        @NonNull
        public static final String ORIGIN = "origin";
        @NonNull
        public static final String PRICE = "price";
        @NonNull
        public static final String QUANTITY = "quantity";
        @NonNull
        public static final String SCORE = "score";
        @NonNull
        public static final String SHIPPING = "shipping";
        @NonNull
        public static final String TRANSACTION_ID = "transaction_id";
        @NonNull
        public static final String SEARCH_TERM = "search_term";
        @NonNull
        public static final String SUCCESS = "success";
        @NonNull
        public static final String TAX = "tax";
        @NonNull
        public static final String VALUE = "value";
        @NonNull
        public static final String VIRTUAL_CURRENCY_NAME = "virtual_currency_name";
        @NonNull
        public static final String CAMPAIGN = "campaign";
        @NonNull
        public static final String SOURCE = "source";
        @NonNull
        public static final String MEDIUM = "medium";
        @NonNull
        public static final String TERM = "term";
        @NonNull
        public static final String CONTENT = "content";
        @NonNull
        public static final String ACLID = "aclid";
        @NonNull
        public static final String CP1 = "cp1";
        @NonNull
        public static final String ITEM_BRAND = "item_brand";
        @NonNull
        public static final String ITEM_VARIANT = "item_variant";
        @Deprecated
        @NonNull
        public static final String ITEM_LIST = "item_list";
        @Deprecated
        @NonNull
        public static final String CHECKOUT_STEP = "checkout_step";
        @Deprecated
        @NonNull
        public static final String CHECKOUT_OPTION = "checkout_option";
        @NonNull
        public static final String CREATIVE_NAME = "creative_name";
        @NonNull
        public static final String CREATIVE_SLOT = "creative_slot";
        @NonNull
        public static final String AFFILIATION = "affiliation";
        @NonNull
        public static final String INDEX = "index";
        @NonNull
        public static final String DISCOUNT = "discount";
        @NonNull
        public static final String ITEM_CATEGORY2 = "item_category2";
        @NonNull
        public static final String ITEM_CATEGORY3 = "item_category3";
        @NonNull
        public static final String ITEM_CATEGORY4 = "item_category4";
        @NonNull
        public static final String ITEM_CATEGORY5 = "item_category5";
        @NonNull
        public static final String ITEM_LIST_ID = "item_list_id";
        @NonNull
        public static final String ITEM_LIST_NAME = "item_list_name";
        @NonNull
        public static final String ITEMS = "items";
        @NonNull
        public static final String LOCATION_ID = "location_id";
        @NonNull
        public static final String PAYMENT_TYPE = "payment_type";
        @NonNull
        public static final String PROMOTION_ID = "promotion_id";
        @NonNull
        public static final String PROMOTION_NAME = "promotion_name";
        @NonNull
        public static final String SCREEN_CLASS = "screen_class";
        @NonNull
        public static final String SCREEN_NAME = "screen_name";
        @NonNull
        public static final String SHIPPING_TIER = "shipping_tier";

        protected Param() {
        }
    }

    public static class Event {
        @NonNull
        public static final String AD_IMPRESSION = "ad_impression";
        @NonNull
        public static final String ADD_PAYMENT_INFO = "add_payment_info";
        @NonNull
        public static final String ADD_TO_CART = "add_to_cart";
        @NonNull
        public static final String ADD_TO_WISHLIST = "add_to_wishlist";
        @NonNull
        public static final String APP_OPEN = "app_open";
        @NonNull
        public static final String BEGIN_CHECKOUT = "begin_checkout";
        @NonNull
        public static final String CAMPAIGN_DETAILS = "campaign_details";
        @Deprecated
        @NonNull
        public static final String ECOMMERCE_PURCHASE = "ecommerce_purchase";
        @NonNull
        public static final String GENERATE_LEAD = "generate_lead";
        @NonNull
        public static final String JOIN_GROUP = "join_group";
        @NonNull
        public static final String LEVEL_END = "level_end";
        @NonNull
        public static final String LEVEL_START = "level_start";
        @NonNull
        public static final String LEVEL_UP = "level_up";
        @NonNull
        public static final String LOGIN = "login";
        @NonNull
        public static final String POST_SCORE = "post_score";
        @Deprecated
        @NonNull
        public static final String PRESENT_OFFER = "present_offer";
        @Deprecated
        @NonNull
        public static final String PURCHASE_REFUND = "purchase_refund";
        @NonNull
        public static final String SEARCH = "search";
        @NonNull
        public static final String SELECT_CONTENT = "select_content";
        @NonNull
        public static final String SHARE = "share";
        @NonNull
        public static final String SIGN_UP = "sign_up";
        @NonNull
        public static final String SPEND_VIRTUAL_CURRENCY = "spend_virtual_currency";
        @NonNull
        public static final String TUTORIAL_BEGIN = "tutorial_begin";
        @NonNull
        public static final String TUTORIAL_COMPLETE = "tutorial_complete";
        @NonNull
        public static final String UNLOCK_ACHIEVEMENT = "unlock_achievement";
        @NonNull
        public static final String VIEW_ITEM = "view_item";
        @NonNull
        public static final String VIEW_ITEM_LIST = "view_item_list";
        @NonNull
        public static final String VIEW_SEARCH_RESULTS = "view_search_results";
        @NonNull
        public static final String EARN_VIRTUAL_CURRENCY = "earn_virtual_currency";
        @NonNull
        public static final String SCREEN_VIEW = "screen_view";
        @NonNull
        public static final String REMOVE_FROM_CART = "remove_from_cart";
        @Deprecated
        @NonNull
        public static final String CHECKOUT_PROGRESS = "checkout_progress";
        @Deprecated
        @NonNull
        public static final String SET_CHECKOUT_OPTION = "set_checkout_option";
        @NonNull
        public static final String ADD_SHIPPING_INFO = "add_shipping_info";
        @NonNull
        public static final String PURCHASE = "purchase";
        @NonNull
        public static final String REFUND = "refund";
        @NonNull
        public static final String SELECT_ITEM = "select_item";
        @NonNull
        public static final String SELECT_PROMOTION = "select_promotion";
        @NonNull
        public static final String VIEW_CART = "view_cart";
        @NonNull
        public static final String VIEW_PROMOTION = "view_promotion";

        protected Event() {
        }
    }
}

