/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.analytics.connector;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApp;
import com.google.firebase.analytics.connector.AnalyticsConnector;
import com.google.firebase.analytics.connector.internal.zzb;
import com.google.firebase.analytics.connector.internal.zze;
import com.google.firebase.analytics.connector.internal.zzg;
import com.google.firebase.analytics.connector.zza;
import com.google.firebase.events.Event;
import com.google.firebase.events.EventHandler;
import com.google.firebase.events.Subscriber;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AnalyticsConnectorImpl
implements AnalyticsConnector {
    private static volatile @Nullable AnalyticsConnector zzb;
    @VisibleForTesting
    private final AppMeasurementSdk zzc;
    @VisibleForTesting
    final Map<String, com.google.firebase.analytics.connector.internal.zza> zza;

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzc.getMaxUserProperties(string);
    }

    @WorkerThread
    @KeepForSdk
    @NonNull
    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable AnalyticsConnector.AnalyticsConnectorHandle registerAnalyticsConnectorListener(final @NonNull String string, @NonNull AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener) {
        com.google.firebase.analytics.connector.internal.zza zza2;
        Preconditions.checkNotNull((Object)analyticsConnectorListener);
        if (!com.google.firebase.analytics.connector.internal.zzb.zzf(string)) {
            return null;
        }
        if (this.zza(string)) {
            return null;
        }
        AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener2 = analyticsConnectorListener;
        AppMeasurementSdk appMeasurementSdk = this.zzc;
        String string2 = string;
        if (("fiam".equals(string2) ? new zze(appMeasurementSdk, analyticsConnectorListener2) : (zza2 = "clx".equals(string2) ? new zzg(appMeasurementSdk, analyticsConnectorListener2) : null)) != null) {
            this.zza.put(string, zza2);
            return new AnalyticsConnector.AnalyticsConnectorHandle(){
                private final /* synthetic */ AnalyticsConnectorImpl zzb;
                {
                    this.zzb = analyticsConnectorImpl;
                }

                @KeepForSdk
                public void registerEventNames(Set<String> set) {
                    if (!this.zzb.zza(string) || !string.equals("fiam") || set == null || set.isEmpty()) {
                        return;
                    }
                    this.zzb.zza.get(string).zza(set);
                }

                public void unregister() {
                    if (!this.zzb.zza(string)) {
                        return;
                    }
                    AnalyticsConnector.AnalyticsConnectorListener analyticsConnectorListener = this.zzb.zza.get(string).zza();
                    if (analyticsConnectorListener != null) {
                        analyticsConnectorListener.onMessageTriggered(0, null);
                    }
                    this.zzb.zza.remove(string);
                }

                @KeepForSdk
                public void unregisterEventNames() {
                    if (!this.zzb.zza(string) || !string.equals("fiam")) {
                        return;
                    }
                    this.zzb.zza.get(string).zzb();
                }
            };
        }
        return null;
    }

    @KeepForSdk
    @NonNull
    public static AnalyticsConnector getInstance() {
        return AnalyticsConnectorImpl.getInstance(FirebaseApp.getInstance());
    }

    @KeepForSdk
    @NonNull
    public static AnalyticsConnector getInstance(@NonNull FirebaseApp firebaseApp) {
        return (AnalyticsConnector)firebaseApp.get(AnalyticsConnector.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @KeepForSdk
    @NonNull
    public static AnalyticsConnector getInstance(@NonNull FirebaseApp firebaseApp, @NonNull Context context, @NonNull Subscriber subscriber) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)subscriber);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb != null) return zzb;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            if (zzb != null) return zzb;
            Bundle bundle = new Bundle(1);
            if (firebaseApp.isDefaultApp()) {
                subscriber.subscribe(DataCollectionDefaultChange.class, (Executor)new zza(), (EventHandler)new com.google.firebase.analytics.connector.zzb());
                bundle.putBoolean("dataCollectionDefaultEnabled", firebaseApp.isDataCollectionDefaultEnabled());
            }
            Bundle bundle2 = bundle;
            zzb = new AnalyticsConnectorImpl(zzed.zza((Context)context, null, null, null, (Bundle)bundle2).zzb());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    @KeepForSdk
    @NonNull
    public List<AnalyticsConnector.ConditionalUserProperty> getConditionalUserProperties(@NonNull String string, @Size(min=1L, max=23L) @NonNull @Nullable String string2) {
        ArrayList<AnalyticsConnector.ConditionalUserProperty> arrayList = new ArrayList<AnalyticsConnector.ConditionalUserProperty>();
        Iterator iterator = this.zzc.getConditionalUserProperties(string, string2).iterator();
        while (iterator.hasNext()) {
            AnalyticsConnector.ConditionalUserProperty conditionalUserProperty = com.google.firebase.analytics.connector.internal.zzb.zza((Bundle)iterator.next());
            arrayList.add(conditionalUserProperty);
        }
        return arrayList;
    }

    @WorkerThread
    @KeepForSdk
    @NonNull
    public Map<String, Object> getUserProperties(boolean bl) {
        return this.zzc.getUserProperties(null, null, bl);
    }

    private AnalyticsConnectorImpl(AppMeasurementSdk appMeasurementSdk) {
        Preconditions.checkNotNull((Object)appMeasurementSdk);
        this.zzc = appMeasurementSdk;
        this.zza = new ConcurrentHashMap<String, com.google.firebase.analytics.connector.internal.zza>();
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @NonNull @Nullable String string2, @NonNull @Nullable Bundle bundle) {
        if (string2 != null && !com.google.firebase.analytics.connector.internal.zzb.zza(string2, bundle)) {
            return;
        }
        this.zzc.clearConditionalUserProperty(string, string2, bundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void zza(Event event) {
        boolean bl = ((DataCollectionDefaultChange)event.getPayload()).enabled;
        Class<AnalyticsConnectorImpl> clazz = AnalyticsConnectorImpl.class;
        synchronized (AnalyticsConnectorImpl.class) {
            ((AnalyticsConnectorImpl)Preconditions.checkNotNull((Object)AnalyticsConnectorImpl.zzb)).zzc.zza(bl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @KeepForSdk
    public void logEvent(@NonNull String string, @NonNull String string2, @NonNull @Nullable Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zzf(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string2, bundle)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zzb(string, string2, bundle)) {
            return;
        }
        com.google.firebase.analytics.connector.internal.zzb.zza(string, string2, bundle);
        this.zzc.logEvent(string, string2, bundle);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull AnalyticsConnector.ConditionalUserProperty conditionalUserProperty) {
        if (!com.google.firebase.analytics.connector.internal.zzb.zzb(conditionalUserProperty)) {
            return;
        }
        this.zzc.setConditionalUserProperty(com.google.firebase.analytics.connector.internal.zzb.zza(conditionalUserProperty));
    }

    @KeepForSdk
    public void setUserProperty(@NonNull String string, @NonNull String string2, @NonNull Object object) {
        if (!com.google.firebase.analytics.connector.internal.zzb.zzf(string)) {
            return;
        }
        if (!com.google.firebase.analytics.connector.internal.zzb.zza(string, string2)) {
            return;
        }
        this.zzc.setUserProperty(string, string2, object);
    }

    private final boolean zza(@NonNull String string) {
        return !string.isEmpty() && this.zza.containsKey(string) && this.zza.get(string) != null;
    }
}

