/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzabc;
import com.google.android.gms.internal.measurement.zzabj;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzabb {
    private final ByteBuffer zzbzg;

    private zzabb(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzabb(ByteBuffer byteBuffer) {
        this.zzbzg = byteBuffer;
        this.zzbzg.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzabb zzk(byte[] byArray) {
        return zzabb.zzb(byArray, 0, byArray.length);
    }

    public static zzabb zzb(byte[] byArray, int n, int n2) {
        return new zzabb(byArray, 0, n2);
    }

    public final void zza(int n, double d) throws IOException {
        this.zzg(n, 1);
        double d2 = d;
        long l = Double.doubleToLongBits(d2);
        zzabb zzabb2 = this;
        if (zzabb2.zzbzg.remaining() < 8) {
            throw new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
        }
        zzabb2.zzbzg.putLong(l);
    }

    public final void zza(int n, float f) throws IOException {
        this.zzg(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        zzabb zzabb2 = this;
        if (zzabb2.zzbzg.remaining() < 4) {
            throw new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
        }
        zzabb2.zzbzg.putInt(n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzg(n, 0);
        long l2 = l;
        this.zzao(l2);
    }

    public final void zzb(int n, long l) throws IOException {
        this.zzg(n, 0);
        long l2 = l;
        this.zzao(l2);
    }

    public final void zze(int n, int n2) throws IOException {
        this.zzg(n, 0);
        int n3 = n2;
        zzabb zzabb2 = this;
        if (n3 >= 0) {
            zzabb2.zzat(n3);
            return;
        }
        zzabb2.zzao(n3);
    }

    public final void zza(int n, boolean bl) throws IOException {
        this.zzg(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzabb zzabb2 = this;
        if (!zzabb2.zzbzg.hasRemaining()) {
            throw new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
        }
        zzabb2.zzbzg.put(by);
    }

    public final void zzc(int n, String string) throws IOException {
        this.zzg(n, 2);
        String string2 = string;
        zzabb zzabb2 = this;
        try {
            int n2 = zzabb.zzau(string2.length());
            int n3 = zzabb.zzau(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzabb2.zzbzg.position();
                if (zzabb2.zzbzg.remaining() < n2) {
                    throw new zzabc(n4 + n2, zzabb2.zzbzg.limit());
                }
                zzabb2.zzbzg.position(n4 + n2);
                zzabb.zza(string2, zzabb2.zzbzg);
                int n5 = zzabb2.zzbzg.position();
                zzabb2.zzbzg.position(n4);
                zzabb2.zzat(n5 - n4 - n2);
                zzabb2.zzbzg.position(n5);
                return;
            }
            zzabb2.zzat(zzabb.zza(string2));
            zzabb.zza(string2, zzabb2.zzbzg);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzabc zzabc2 = new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
            zzabc2.initCause(bufferOverflowException);
            throw zzabc2;
        }
    }

    public final void zza(int n, zzabj zzabj2) throws IOException {
        this.zzg(n, 2);
        this.zzb(zzabj2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public final void zzb(zzabj zzabj2) throws IOException {
        this.zzat(zzabj2.zzwf());
        zzabj2.zza(this);
    }

    public static int zzc(int n, long l) {
        return zzabb.zzas(n) + zzabb.zzap(l);
    }

    public static int zzf(int n, int n2) {
        return zzabb.zzas(n) + zzabb.zzaq(n2);
    }

    public static int zzd(int n, String string) {
        return zzabb.zzas(n) + zzabb.zzfp(string);
    }

    public static int zzb(int n, zzabj zzabj2) {
        int n2 = zzabj2.zzwg();
        return zzabb.zzas(n) + (zzabb.zzau(n2) + n2);
    }

    public static int zzaq(int n) {
        if (n >= 0) {
            return zzabb.zzau(n);
        }
        return 10;
    }

    public static int zzfp(String string) {
        int n = zzabb.zza(string);
        return zzabb.zzau(n) + n;
    }

    public final void zzvy() {
        if (this.zzbzg.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzbzg.remaining()));
        }
    }

    private final void zzar(int n) throws IOException {
        byte by = (byte)n;
        zzabb zzabb2 = this;
        if (!zzabb2.zzbzg.hasRemaining()) {
            throw new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
        }
        zzabb2.zzbzg.put(by);
    }

    public final void zzl(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzabb zzabb2 = this;
        if (zzabb2.zzbzg.remaining() >= n) {
            zzabb2.zzbzg.put(byArray2, 0, n);
            return;
        }
        throw new zzabc(zzabb2.zzbzg.position(), zzabb2.zzbzg.limit());
    }

    public final void zzg(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzat(n << 3 | n3);
    }

    public static int zzas(int n) {
        return zzabb.zzau(n << 3);
    }

    public final void zzat(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzar(n);
                return;
            }
            this.zzar(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzau(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzao(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzar((int)l);
                return;
            }
            this.zzar((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzap(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

