/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzabx;
import com.google.android.gms.internal.measurement.zzace;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzabw {
    private final ByteBuffer zzbwv;

    private zzabw(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzabw(ByteBuffer byteBuffer) {
        this.zzbwv = byteBuffer;
        this.zzbwv.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzabw zzj(byte[] byArray) {
        return zzabw.zzb(byArray, 0, byArray.length);
    }

    public static zzabw zzb(byte[] byArray, int n, int n2) {
        return new zzabw(byArray, 0, n2);
    }

    public final void zza(int n, double d) throws IOException {
        this.zzg(n, 1);
        double d2 = d;
        long l = Double.doubleToLongBits(d2);
        zzabw zzabw2 = this;
        if (zzabw2.zzbwv.remaining() < 8) {
            throw new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
        }
        zzabw2.zzbwv.putLong(l);
    }

    public final void zza(int n, float f) throws IOException {
        this.zzg(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        zzabw zzabw2 = this;
        if (zzabw2.zzbwv.remaining() < 4) {
            throw new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
        }
        zzabw2.zzbwv.putInt(n2);
    }

    public final void zza(int n, long l) throws IOException {
        this.zzg(n, 0);
        long l2 = l;
        this.zzan(l2);
    }

    public final void zzb(int n, long l) throws IOException {
        this.zzg(n, 0);
        long l2 = l;
        this.zzan(l2);
    }

    public final void zze(int n, int n2) throws IOException {
        this.zzg(n, 0);
        int n3 = n2;
        zzabw zzabw2 = this;
        if (n3 >= 0) {
            zzabw2.zzar(n3);
            return;
        }
        zzabw2.zzan(n3);
    }

    public final void zza(int n, boolean bl) throws IOException {
        this.zzg(n, 0);
        boolean bl2 = bl;
        boolean bl3 = bl2;
        byte by = (byte)(bl3 ? 1 : 0);
        zzabw zzabw2 = this;
        if (!zzabw2.zzbwv.hasRemaining()) {
            throw new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
        }
        zzabw2.zzbwv.put(by);
    }

    public final void zzb(int n, String string) throws IOException {
        this.zzg(n, 2);
        String string2 = string;
        zzabw zzabw2 = this;
        try {
            int n2 = zzabw.zzas(string2.length());
            int n3 = zzabw.zzas(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzabw2.zzbwv.position();
                if (zzabw2.zzbwv.remaining() < n2) {
                    throw new zzabx(n4 + n2, zzabw2.zzbwv.limit());
                }
                zzabw2.zzbwv.position(n4 + n2);
                zzabw.zza(string2, zzabw2.zzbwv);
                int n5 = zzabw2.zzbwv.position();
                zzabw2.zzbwv.position(n4);
                zzabw2.zzar(n5 - n4 - n2);
                zzabw2.zzbwv.position(n5);
                return;
            }
            zzabw2.zzar(zzabw.zza(string2));
            zzabw.zza(string2, zzabw2.zzbwv);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzabx zzabx2 = new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
            zzabx2.initCause(bufferOverflowException);
            throw zzabx2;
        }
    }

    public final void zza(int n, zzace zzace2) throws IOException {
        this.zzg(n, 2);
        this.zzb(zzace2);
    }

    private static int zza(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public final void zzb(zzace zzace2) throws IOException {
        this.zzar(zzace2.zzvl());
        zzace2.zza(this);
    }

    public static int zzc(int n, long l) {
        return zzabw.zzaq(n) + zzabw.zzao(l);
    }

    public static int zzf(int n, int n2) {
        return zzabw.zzaq(n) + zzabw.zzao(n2);
    }

    public static int zzc(int n, String string) {
        return zzabw.zzaq(n) + zzabw.zzfm(string);
    }

    public static int zzb(int n, zzace zzace2) {
        int n2 = zzace2.zzvm();
        return zzabw.zzaq(n) + (zzabw.zzas(n2) + n2);
    }

    public static int zzao(int n) {
        if (n >= 0) {
            return zzabw.zzas(n);
        }
        return 10;
    }

    public static int zzfm(String string) {
        int n = zzabw.zza(string);
        return zzabw.zzas(n) + n;
    }

    public final void zzve() {
        if (this.zzbwv.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzbwv.remaining()));
        }
    }

    private final void zzap(int n) throws IOException {
        byte by = (byte)n;
        zzabw zzabw2 = this;
        if (!zzabw2.zzbwv.hasRemaining()) {
            throw new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
        }
        zzabw2.zzbwv.put(by);
    }

    public final void zzk(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzabw zzabw2 = this;
        if (zzabw2.zzbwv.remaining() >= n) {
            zzabw2.zzbwv.put(byArray2, 0, n);
            return;
        }
        throw new zzabx(zzabw2.zzbwv.position(), zzabw2.zzbwv.limit());
    }

    public final void zzg(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzar(n << 3 | n3);
    }

    public static int zzaq(int n) {
        return zzabw.zzas(n << 3);
    }

    public final void zzar(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzap(n);
                return;
            }
            this.zzap(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzas(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzan(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzap((int)l);
                return;
            }
            this.zzap((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzao(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }
}

