/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zztz;
import com.google.android.gms.internal.measurement.zzvo;
import com.google.android.gms.internal.measurement.zzvs;
import com.google.android.gms.internal.measurement.zzxe;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzub
extends zztz<Boolean>
implements zzvs<Boolean>,
zzxe,
RandomAccess {
    private static final zzub zzbtx = new zzub();
    private boolean[] zzbty;
    private int size;

    zzub() {
        this(new boolean[10], 0);
    }

    private zzub(boolean[] blArray, int n) {
        this.zzbty = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zztx();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbty, n2, this.zzbty, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzub)) {
            return super.equals(object);
        }
        zzub zzub2 = (zzub)object;
        if (this.size != zzub2.size) {
            return false;
        }
        boolean[] blArray = zzub2.zzbty;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbty[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvo.zzw(this.zzbty[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zztx();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbty.length) {
            System.arraycopy(this.zzbty, n, this.zzbty, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbty, 0, blArray, 0, n);
            System.arraycopy(this.zzbty, n, blArray, n + 1, this.size - n);
            this.zzbty = blArray;
        }
        this.zzbty[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zztx();
        zzvo.checkNotNull(collection);
        if (!(collection instanceof zzub)) {
            return super.addAll(collection);
        }
        zzub zzub2 = (zzub)collection;
        if (zzub2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzub2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzub2.size;
        if (n > this.zzbty.length) {
            this.zzbty = Arrays.copyOf(this.zzbty, n);
        }
        System.arraycopy(zzub2.zzbty, 0, this.zzbty, this.size, zzub2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zztx();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbty[i])) continue;
            System.arraycopy(this.zzbty, i + 1, this.zzbty, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzub zzub2 = this;
        zzub2.zztx();
        zzub2.zzai(n);
        boolean bl3 = zzub2.zzbty[n];
        zzub2.zzbty[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzub zzub2 = this;
        zzub2.zztx();
        zzub2.zzai(n);
        boolean bl = zzub2.zzbty[n];
        if (n < zzub2.size - 1) {
            System.arraycopy(zzub2.zzbty, n + 1, zzub2.zzbty, n, zzub2.size - n);
        }
        --zzub2.size;
        ++zzub2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzvs zzak(int n) {
        int n2 = n;
        zzub zzub2 = this;
        if (n2 < zzub2.size) {
            throw new IllegalArgumentException();
        }
        return new zzub(Arrays.copyOf(zzub2.zzbty, n2), zzub2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzub zzub2 = this;
        zzub2.zzai(n);
        return zzub2.zzbty[n];
    }

    static {
        zzbtx.zzsm();
    }
}

