/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zztw;
import com.google.android.gms.internal.measurement.zzuc;
import com.google.android.gms.internal.measurement.zzud;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzuv;
import com.google.android.gms.internal.measurement.zzvo;
import com.google.android.gms.internal.measurement.zzwa;
import com.google.android.gms.internal.measurement.zzwt;
import com.google.android.gms.internal.measurement.zzxj;
import com.google.android.gms.internal.measurement.zzyh;
import com.google.android.gms.internal.measurement.zzyj;
import com.google.android.gms.internal.measurement.zzyn;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzut
extends zzuc {
    private static final Logger logger = Logger.getLogger(zzut.class.getName());
    private static final boolean zzbuv = zzyh.zzyi();
    zzuv zzbuw;

    public static zzut zzj(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzut zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzyh.zzyj()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzut() {
    }

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public final void zzf(int n, int n2) throws IOException {
        this.zze(n, zzut.zzbi(n2));
    }

    public abstract void zzg(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzut.zzbd(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzg(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzud var2) throws IOException;

    public abstract void zza(int var1, zzwt var2) throws IOException;

    abstract void zza(int var1, zzwt var2, zzxj var3) throws IOException;

    public abstract void zzb(int var1, zzwt var2) throws IOException;

    public abstract void zzb(int var1, zzud var2) throws IOException;

    public abstract void zzax(int var1) throws IOException;

    public abstract void zzay(int var1) throws IOException;

    public final void zzaz(int n) throws IOException {
        this.zzay(zzut.zzbi(n));
    }

    public abstract void zzba(int var1) throws IOException;

    public abstract void zzav(long var1) throws IOException;

    public final void zzaw(long l) throws IOException {
        this.zzav(zzut.zzbd(l));
    }

    public abstract void zzax(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzba(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzax(Double.doubleToRawLongBits(d));
    }

    public final void zzu(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzfw(String var1) throws IOException;

    public abstract void zza(zzud var1) throws IOException;

    public abstract void zzb(zzwt var1) throws IOException;

    abstract void zza(zzwt var1, zzxj var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzh(int n, int n2) {
        return zzut.zzbb(n) + zzut.zzbc(n2);
    }

    public static int zzi(int n, int n2) {
        return zzut.zzbb(n) + zzut.zzbd(n2);
    }

    public static int zzj(int n, int n2) {
        return zzut.zzbb(n) + zzut.zzbd(zzut.zzbi(n2));
    }

    public static int zzk(int n, int n2) {
        return zzut.zzbb(n) + 4;
    }

    public static int zzl(int n, int n2) {
        return zzut.zzbb(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzut.zzbb(n) + zzut.zzaz(l);
    }

    public static int zze(int n, long l) {
        return zzut.zzbb(n) + zzut.zzaz(l);
    }

    public static int zzf(int n, long l) {
        return zzut.zzbb(n) + zzut.zzaz(zzut.zzbd(l));
    }

    public static int zzg(int n, long l) {
        return zzut.zzbb(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzut.zzbb(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzut.zzbb(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzut.zzbb(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzut.zzbb(n) + 1;
    }

    public static int zzm(int n, int n2) {
        return zzut.zzbb(n) + zzut.zzbc(n2);
    }

    public static int zzc(int n, String string) {
        return zzut.zzbb(n) + zzut.zzfx(string);
    }

    public static int zzc(int n, zzud zzud2) {
        int n2 = zzud2.size();
        return zzut.zzbb(n) + (zzut.zzbd(n2) + n2);
    }

    public static int zza(int n, zzwa zzwa2) {
        int n2 = zzwa2.zzvu();
        return zzut.zzbb(n) + (zzut.zzbd(n2) + n2);
    }

    public static int zzc(int n, zzwt zzwt2) {
        return zzut.zzbb(n) + zzut.zzc(zzwt2);
    }

    static int zzb(int n, zzwt zzwt2, zzxj zzxj2) {
        return zzut.zzbb(n) + zzut.zzb(zzwt2, zzxj2);
    }

    public static int zzd(int n, zzwt zzwt2) {
        return (zzut.zzbb(1) << 1) + zzut.zzi(2, n) + zzut.zzc(3, zzwt2);
    }

    public static int zzd(int n, zzud zzud2) {
        return (zzut.zzbb(1) << 1) + zzut.zzi(2, n) + zzut.zzc(3, zzud2);
    }

    public static int zzb(int n, zzwa zzwa2) {
        return (zzut.zzbb(1) << 1) + zzut.zzi(2, n) + zzut.zza(3, zzwa2);
    }

    public static int zzbb(int n) {
        return zzut.zzbd(n << 3);
    }

    public static int zzbc(int n) {
        if (n >= 0) {
            return zzut.zzbd(n);
        }
        return 10;
    }

    public static int zzbd(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzbe(int n) {
        return zzut.zzbd(zzut.zzbi(n));
    }

    public static int zzbf(int n) {
        return 4;
    }

    public static int zzbg(int n) {
        return 4;
    }

    public static int zzay(long l) {
        return zzut.zzaz(l);
    }

    public static int zzaz(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzba(long l) {
        return zzut.zzaz(zzut.zzbd(l));
    }

    public static int zzbb(long l) {
        return 8;
    }

    public static int zzbc(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzv(boolean bl) {
        return 1;
    }

    public static int zzbh(int n) {
        return zzut.zzbc(n);
    }

    public static int zzfx(String string) {
        int n;
        try {
            n = zzyj.zza(string);
        }
        catch (zzyn zzyn2) {
            n = string.getBytes(zzvo.UTF_8).length;
        }
        int n2 = n;
        return zzut.zzbd(n2) + n2;
    }

    public static int zza(zzwa zzwa2) {
        int n = zzwa2.zzvu();
        return zzut.zzbd(n) + n;
    }

    public static int zzb(zzud zzud2) {
        int n = zzud2.size();
        return zzut.zzbd(n) + n;
    }

    public static int zzk(byte[] byArray) {
        int n = byArray.length;
        return zzut.zzbd(n) + n;
    }

    public static int zzc(zzwt zzwt2) {
        int n = zzwt2.zzvu();
        return zzut.zzbd(n) + n;
    }

    static int zzb(zzwt zzwt2, zzxj zzxj2) {
        zzxj zzxj3 = zzxj2;
        zztw zztw2 = (zztw)zzwt2;
        int n = zztw2.zztu();
        if (n == -1) {
            n = zzxj3.zzae(zztw2);
            zztw2.zzah(n);
        }
        int n2 = n;
        return zzut.zzbd(n2) + n2;
    }

    private static int zzbi(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzbd(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzvg();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzyn zzyn2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzyn2);
        byte[] byArray = string.getBytes(zzvo.UTF_8);
        try {
            this.zzay(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzwt zzwt2, zzxj zzxj2) {
        zzxj zzxj3;
        int n2 = zzut.zzbb(n) << 1;
        zzxj zzxj4 = zzxj3 = zzxj2;
        zztw zztw2 = (zztw)zzwt2;
        int n3 = zztw2.zztu();
        if (n3 == -1) {
            n3 = zzxj4.zzae(zztw2);
            zztw2.zzah(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzwt zzwt2) {
        return zzwt2.zzvu();
    }

    @Deprecated
    public static int zzbj(int n) {
        return zzut.zzbd(n);
    }

    /* synthetic */ zzut(zzuu zzuu2) {
        this();
    }

    static final class zze
    extends zzut {
        private final ByteBuffer zzbuz;
        private final ByteBuffer zzbva;
        private final long zzbvb;
        private final long zzbvc;
        private final long zzbvd;
        private final long zzbve;
        private long zzbvf;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzbuz = byteBuffer;
            this.zzbva = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbvb = zzyh.zzb(byteBuffer);
            this.zzbvc = this.zzbvb + (long)byteBuffer.position();
            this.zzbvd = this.zzbvb + (long)byteBuffer.limit();
            this.zzbve = this.zzbvd - 10L;
            this.zzbvf = this.zzbvc;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzut)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzax(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzay(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 5);
            ((zzut)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzav(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 1);
            ((zzut)this).zzax(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzfw(string);
        }

        @Override
        public final void zza(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zza(zzud2);
        }

        @Override
        public final void zza(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzb(zzwt2);
        }

        @Override
        final void zza(int n, zzwt zzwt2, zzxj zzxj2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zza(zzwt2, zzxj2);
        }

        @Override
        public final void zzb(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzwt2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzud2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzwt zzwt2) throws IOException {
            ((zzut)this).zzay(zzwt2.zzvu());
            zzwt2.zzb(this);
        }

        @Override
        final void zza(zzwt zzwt2, zzxj zzxj2) throws IOException {
            zzxj zzxj3 = zzxj2;
            zztw zztw2 = (zztw)zzwt2;
            int n = zztw2.zztu();
            if (n == -1) {
                n = zzxj3.zzae(zztw2);
                zztw2.zzah(n);
            }
            ((zzut)this).zzay(n);
            zzxj2.zza(zzwt2, this.zzbuw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzbvf >= this.zzbvd) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbvf, this.zzbvd, 1));
            }
            zzyh.zza(this.zzbvf++, by);
        }

        @Override
        public final void zza(zzud zzud2) throws IOException {
            ((zzut)this).zzay(zzud2.size());
            zzud2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).zzay(n2);
            ((zzut)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzut)this).zzay(n);
                return;
            }
            ((zzut)this).zzav(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (this.zzbvf <= this.zzbve) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzyh.zza(this.zzbvf++, (byte)n);
                        return;
                    }
                    zzyh.zza(this.zzbvf++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzbvf < this.zzbvd) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzyh.zza(this.zzbvf++, (byte)n);
                    return;
                }
                zzyh.zza(this.zzbvf++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbvf, this.zzbvd, 1));
        }

        @Override
        public final void zzba(int n) throws IOException {
            long l = this.zzbvf;
            zze zze2 = this;
            this.zzbva.putInt((int)(l - zze2.zzbvb), n);
            this.zzbvf += 4L;
        }

        @Override
        public final void zzav(long l) throws IOException {
            if (this.zzbvf <= this.zzbve) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzyh.zza(this.zzbvf++, (byte)l);
                        return;
                    }
                    zzyh.zza(this.zzbvf++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzbvf < this.zzbvd) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzyh.zza(this.zzbvf++, (byte)l);
                    return;
                }
                zzyh.zza(this.zzbvf++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbvf, this.zzbvd, 1));
        }

        @Override
        public final void zzax(long l) throws IOException {
            long l2 = this.zzbvf;
            zze zze2 = this;
            this.zzbva.putLong((int)(l2 - zze2.zzbvb), l);
            this.zzbvf += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzbvd - (long)n2 < this.zzbvf) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbvf, this.zzbvd, n2));
            }
            zzyh.zza(byArray, n, this.zzbvf, n2);
            this.zzbvf += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfw(String string) throws IOException {
            long l = this.zzbvf;
            try {
                int n = zze.zzbd(string.length() * 3);
                int n2 = zze.zzbd(string.length());
                if (n2 == n) {
                    long l2 = this.zzbvf;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzbvb) + n2;
                    this.zzbva.position(n3);
                    zzyj.zza(string, this.zzbva);
                    int n4 = this.zzbva.position() - n3;
                    ((zzut)this).zzay(n4);
                    this.zzbvf += (long)n4;
                    return;
                }
                int n5 = zzyj.zza(string);
                ((zzut)this).zzay(n5);
                this.zzbe(this.zzbvf);
                zzyj.zza(string, this.zzbva);
                this.zzbvf += (long)n5;
                return;
            }
            catch (zzyn zzyn2) {
                this.zzbvf = l;
                this.zzbe(this.zzbvf);
                this.zza(string, zzyn2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzbvf;
            zze zze2 = this;
            this.zzbuz.position((int)(l - zze2.zzbvb));
        }

        @Override
        public final int zzvg() {
            return (int)(this.zzbvd - this.zzbvf);
        }

        private final void zzbe(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzbva.position((int)(l2 - zze2.zzbvb));
        }
    }

    static final class zzd
    extends zzut {
        private final ByteBuffer zzbuz;
        private final ByteBuffer zzbva;
        private final int zzbuy;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzbuz = byteBuffer;
            this.zzbva = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbuy = byteBuffer.position();
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzut)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzax(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzay(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 5);
            ((zzut)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzav(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 1);
            ((zzut)this).zzax(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzfw(string);
        }

        @Override
        public final void zza(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zza(zzud2);
        }

        @Override
        public final void zza(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzb(zzwt2);
        }

        @Override
        final void zza(int n, zzwt zzwt2, zzxj zzxj2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zza(zzwt2, zzxj2);
        }

        @Override
        public final void zzb(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzwt2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzud2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzwt zzwt2) throws IOException {
            ((zzut)this).zzay(zzwt2.zzvu());
            zzwt2.zzb(this);
        }

        @Override
        final void zza(zzwt zzwt2, zzxj zzxj2) throws IOException {
            zzxj zzxj3 = zzxj2;
            zztw zztw2 = (zztw)zzwt2;
            int n = zztw2.zztu();
            if (n == -1) {
                n = zzxj3.zzae(zztw2);
                zztw2.zzah(n);
            }
            ((zzut)this).zzay(n);
            zzxj2.zza(zzwt2, this.zzbuw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzbva.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzud zzud2) throws IOException {
            ((zzut)this).zzay(zzud2.size());
            zzud2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).zzay(n2);
            ((zzut)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzut)this).zzay(n);
                return;
            }
            ((zzut)this).zzav(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzbva.put((byte)n);
                        return;
                    }
                    this.zzbva.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzba(int n) throws IOException {
            try {
                this.zzbva.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzav(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzbva.put((byte)l);
                        return;
                    }
                    this.zzbva.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzax(long l) throws IOException {
            try {
                this.zzbva.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzbva.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfw(String string) throws IOException {
            int n = this.zzbva.position();
            try {
                int n2 = zzd.zzbd(string.length() * 3);
                int n3 = zzd.zzbd(string.length());
                if (n3 == n2) {
                    int n4 = this.zzbva.position() + n3;
                    this.zzbva.position(n4);
                    this.zzfy(string);
                    int n5 = this.zzbva.position();
                    this.zzbva.position(n);
                    ((zzut)this).zzay(n5 - n4);
                    this.zzbva.position(n5);
                    return;
                }
                int n6 = zzyj.zza(string);
                ((zzut)this).zzay(n6);
                this.zzfy(string);
                return;
            }
            catch (zzyn zzyn2) {
                this.zzbva.position(n);
                this.zza(string, zzyn2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzbuz.position(this.zzbva.position());
        }

        @Override
        public final int zzvg() {
            return this.zzbva.remaining();
        }

        private final void zzfy(String string) throws IOException {
            try {
                zzyj.zza(string, this.zzbva);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzbux;
        private int zzbuy;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzbux = byteBuffer;
            this.zzbuy = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzbux.position(this.zzbuy + this.zzvi());
        }
    }

    static class zza
    extends zzut {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzut)this).zzay(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzax(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzay(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zzut)this).zzc(n, 5);
            ((zzut)this).zzba(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzav(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzut)this).zzc(n, 1);
            ((zzut)this).zzax(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzut)this).zzc(n, 0);
            ((zzut)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzfw(string);
        }

        @Override
        public final void zza(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zza(zzud2);
        }

        @Override
        public final void zza(zzud zzud2) throws IOException {
            ((zzut)this).zzay(zzud2.size());
            zzud2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).zzay(n2);
            ((zzut)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(n, 2);
            ((zzut)this).zzb(zzwt2);
        }

        @Override
        final void zza(int n, zzwt zzwt2, zzxj zzxj2) throws IOException {
            ((zzut)this).zzc(n, 2);
            zzxj zzxj3 = zzxj2;
            zztw zztw2 = (zztw)zzwt2;
            int n2 = zztw2.zztu();
            if (n2 == -1) {
                n2 = zzxj3.zzae(zztw2);
                zztw2.zzah(n2);
            }
            ((zzut)this).zzay(n2);
            zzxj2.zza(zzwt2, this.zzbuw);
        }

        @Override
        public final void zzb(int n, zzwt zzwt2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzwt2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzud zzud2) throws IOException {
            ((zzut)this).zzc(1, 3);
            ((zzut)this).zze(2, n);
            ((zzut)this).zza(3, zzud2);
            ((zzut)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzwt zzwt2) throws IOException {
            ((zzut)this).zzay(zzwt2.zzvu());
            zzwt2.zzb(this);
        }

        @Override
        final void zza(zzwt zzwt2, zzxj zzxj2) throws IOException {
            zzxj zzxj3 = zzxj2;
            zztw zztw2 = (zztw)zzwt2;
            int n = zztw2.zztu();
            if (n == -1) {
                n = zzxj3.zzae(zztw2);
                zztw2.zzah(n);
            }
            ((zzut)this).zzay(n);
            zzxj2.zza(zzwt2, this.zzbuw);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzax(int n) throws IOException {
            if (n >= 0) {
                ((zzut)this).zzay(n);
                return;
            }
            ((zzut)this).zzav(n);
        }

        @Override
        public final void zzay(int n) throws IOException {
            if (zzbuv && ((zzut)this).zzvg() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzyh.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzyh.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzba(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzav(long l) throws IOException {
            if (zzbuv && ((zzut)this).zzvg() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzyh.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzyh.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzax(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzut)this).write(byArray, n, n2);
        }

        @Override
        public final void zzfw(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzbd(string.length() * 3);
                int n3 = zza.zzbd(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzyj.zza(string, this.buffer, this.position, ((zzut)this).zzvg());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzut)this).zzay(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzyj.zza(string);
                ((zzut)this).zzay(n6);
                this.position = zzyj.zza(string, this.buffer, this.position, ((zzut)this).zzvg());
                return;
            }
            catch (zzyn zzyn2) {
                this.position = n;
                this.zza(string, zzyn2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzvg() {
            return this.limit - this.position;
        }

        public final int zzvi() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

