/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zztz;
import com.google.android.gms.internal.measurement.zzvo;
import com.google.android.gms.internal.measurement.zzvs;
import com.google.android.gms.internal.measurement.zzxe;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzuw
extends zztz<Double>
implements zzvs<Double>,
zzxe,
RandomAccess {
    private static final zzuw zzbvg = new zzuw();
    private double[] zzbvh;
    private int size;

    zzuw() {
        this(new double[10], 0);
    }

    private zzuw(double[] dArray, int n) {
        this.zzbvh = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zztx();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbvh, n2, this.zzbvh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzuw)) {
            return super.equals(object);
        }
        zzuw zzuw2 = (zzuw)object;
        if (this.size != zzuw2.size) {
            return false;
        }
        double[] dArray = zzuw2.zzbvh;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbvh[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzbvh[i]);
            n = n * 31 + zzvo.zzbf(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zztx();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbvh.length) {
            System.arraycopy(this.zzbvh, n, this.zzbvh, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbvh, 0, dArray, 0, n);
            System.arraycopy(this.zzbvh, n, dArray, n + 1, this.size - n);
            this.zzbvh = dArray;
        }
        this.zzbvh[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zztx();
        zzvo.checkNotNull(collection);
        if (!(collection instanceof zzuw)) {
            return super.addAll(collection);
        }
        zzuw zzuw2 = (zzuw)collection;
        if (zzuw2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzuw2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzuw2.size;
        if (n > this.zzbvh.length) {
            this.zzbvh = Arrays.copyOf(this.zzbvh, n);
        }
        System.arraycopy(zzuw2.zzbvh, 0, this.zzbvh, this.size, zzuw2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zztx();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbvh[i])) continue;
            System.arraycopy(this.zzbvh, i + 1, this.zzbvh, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzuw zzuw2 = this;
        zzuw2.zztx();
        zzuw2.zzai(n);
        double d3 = zzuw2.zzbvh[n];
        zzuw2.zzbvh[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzuw zzuw2 = this;
        zzuw2.zztx();
        zzuw2.zzai(n);
        double d = zzuw2.zzbvh[n];
        if (n < zzuw2.size - 1) {
            System.arraycopy(zzuw2.zzbvh, n + 1, zzuw2.zzbvh, n, zzuw2.size - n);
        }
        --zzuw2.size;
        ++zzuw2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzvs zzak(int n) {
        int n2 = n;
        zzuw zzuw2 = this;
        if (n2 < zzuw2.size) {
            throw new IllegalArgumentException();
        }
        return new zzuw(Arrays.copyOf(zzuw2.zzbvh, n2), zzuw2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzuw zzuw2 = this;
        zzuw2.zzai(n);
        return zzuw2.zzbvh[n];
    }

    static {
        zzbvg.zzsm();
    }
}

