/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zztz;
import com.google.android.gms.internal.measurement.zzvo;
import com.google.android.gms.internal.measurement.zzvs;
import com.google.android.gms.internal.measurement.zzxe;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvn
extends zztz<Integer>
implements zzvs<Integer>,
zzxe,
RandomAccess {
    private static final zzvn zzbzh = new zzvn();
    private int[] zzbzi;
    private int size;

    zzvn() {
        this(new int[10], 0);
    }

    private zzvn(int[] nArray, int n) {
        this.zzbzi = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zztx();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbzi, n2, this.zzbzi, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvn)) {
            return super.equals(object);
        }
        zzvn zzvn2 = (zzvn)object;
        if (this.size != zzvn2.size) {
            return false;
        }
        int[] nArray = zzvn2.zzbzi;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbzi[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzbzi[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzai(n);
        return this.zzbzi[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbm(int n) {
        this.zzp(this.size, n);
    }

    private final void zzp(int n, int n2) {
        this.zztx();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzbzi.length) {
            System.arraycopy(this.zzbzi, n, this.zzbzi, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbzi, 0, nArray, 0, n);
            System.arraycopy(this.zzbzi, n, nArray, n + 1, this.size - n);
            this.zzbzi = nArray;
        }
        this.zzbzi[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zztx();
        zzvo.checkNotNull(collection);
        if (!(collection instanceof zzvn)) {
            return super.addAll(collection);
        }
        zzvn zzvn2 = (zzvn)collection;
        if (zzvn2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvn2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvn2.size;
        if (n > this.zzbzi.length) {
            this.zzbzi = Arrays.copyOf(this.zzbzi, n);
        }
        System.arraycopy(zzvn2.zzbzi, 0, this.zzbzi, this.size, zzvn2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zztx();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbzi[i])) continue;
            System.arraycopy(this.zzbzi, i + 1, this.zzbzi, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzvn zzvn2 = this;
        zzvn2.zztx();
        zzvn2.zzai(n);
        int n4 = zzvn2.zzbzi[n];
        zzvn2.zzbzi[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvn zzvn2 = this;
        zzvn2.zztx();
        zzvn2.zzai(n);
        int n2 = zzvn2.zzbzi[n];
        if (n < zzvn2.size - 1) {
            System.arraycopy(zzvn2.zzbzi, n + 1, zzvn2.zzbzi, n, zzvn2.size - n);
        }
        --zzvn2.size;
        ++zzvn2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzp(n, n2);
    }

    @Override
    public final /* synthetic */ zzvs zzak(int n) {
        int n2 = n;
        zzvn zzvn2 = this;
        if (n2 < zzvn2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvn(Arrays.copyOf(zzvn2.zzbzi, n2), zzvn2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzbzh.zzsm();
    }
}

