/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuo;
import com.google.android.gms.internal.measurement.zzuz;
import com.google.android.gms.internal.measurement.zzvm;
import com.google.android.gms.internal.measurement.zzvt;
import com.google.android.gms.internal.measurement.zzxd;
import com.google.android.gms.internal.measurement.zzze;
import com.google.android.gms.internal.measurement.zzzf;
import com.google.android.gms.internal.measurement.zzzg;
import com.google.android.gms.internal.measurement.zzzj;
import java.io.IOException;

public final class zzyx {
    private final byte[] buffer;
    private final int zzcev;
    private final int zzcew;
    private int zzcex;
    private int zzbun;
    private int zzcey;
    private int zzbup;
    private int zzbuq = Integer.MAX_VALUE;
    private int zzbuh;
    private int zzbui = 64;
    private int zzbuj = 0x4000000;
    private zzuo zzcez;

    public static zzyx zzn(byte[] byArray) {
        return zzyx.zzj(byArray, 0, byArray.length);
    }

    public static zzyx zzj(byte[] byArray, int n, int n2) {
        return new zzyx(byArray, 0, n2);
    }

    public final int zzug() throws IOException {
        zzyx zzyx2 = this;
        if (zzyx2.zzcey == zzyx2.zzcex) {
            this.zzbup = 0;
            return 0;
        }
        this.zzbup = this.zzuy();
        if (this.zzbup == 0) {
            throw new zzzf("Protocol message contained an invalid tag (zero).");
        }
        return this.zzbup;
    }

    public final void zzan(int n) throws zzzf {
        if (this.zzbup != n) {
            throw new zzzf("Protocol message end-group tag did not match expected tag.");
        }
    }

    public final boolean zzao(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                this.zzuy();
                return true;
            }
            case 1: {
                this.zzvb();
                return true;
            }
            case 2: {
                this.zzas(this.zzuy());
                return true;
            }
            case 3: {
                int n2;
                zzyx zzyx2 = this;
                while ((n2 = zzyx2.zzug()) != 0 && zzyx2.zzao(n2)) {
                }
                this.zzan(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                this.zzva();
                return true;
            }
        }
        throw new zzzf("Protocol message tag had invalid wire type.");
    }

    public final boolean zzum() throws IOException {
        return this.zzuy() != 0;
    }

    public final String readString() throws IOException {
        int n = this.zzuy();
        if (n < 0) {
            throw zzzf.zzyx();
        }
        if (n > this.zzcex - this.zzcey) {
            throw zzzf.zzyw();
        }
        String string = new String(this.buffer, this.zzcey, n, zzze.UTF_8);
        this.zzcey += n;
        return string;
    }

    public final void zza(zzzg zzzg2, int n) throws IOException {
        if (this.zzbuh >= this.zzbui) {
            throw zzzf.zzyz();
        }
        ++this.zzbuh;
        zzzg2.zza(this);
        this.zzan(n << 3 | 4);
        --this.zzbuh;
    }

    public final void zza(zzzg zzzg2) throws IOException {
        int n = this.zzuy();
        if (this.zzbuh >= this.zzbui) {
            throw zzzf.zzyz();
        }
        int n2 = this.zzaq(n);
        ++this.zzbuh;
        zzzg2.zza(this);
        this.zzan(0);
        --this.zzbuh;
        this.zzar(n2);
    }

    public final int zzuy() throws IOException {
        byte by = this.zzvd();
        if (by >= 0) {
            return by;
        }
        int n = by & 0x7F;
        by = this.zzvd();
        if (by >= 0) {
            n |= by << 7;
        } else {
            n |= (by & 0x7F) << 7;
            by = this.zzvd();
            if (by >= 0) {
                n |= by << 14;
            } else {
                n |= (by & 0x7F) << 14;
                by = this.zzvd();
                if (by >= 0) {
                    n |= by << 21;
                } else {
                    int n2 = n | (by & 0x7F) << 21;
                    by = this.zzvd();
                    n = n2 | by << 28;
                    if (by < 0) {
                        for (int i = 0; i < 5; ++i) {
                            if (this.zzvd() < 0) continue;
                            return n;
                        }
                        throw zzzf.zzyy();
                    }
                }
            }
        }
        return n;
    }

    public final long zzuz() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzvd();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzzf.zzyy();
    }

    public final int zzva() throws IOException {
        byte by = this.zzvd();
        byte by2 = this.zzvd();
        byte by3 = this.zzvd();
        byte by4 = this.zzvd();
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    public final long zzvb() throws IOException {
        byte by = this.zzvd();
        byte by2 = this.zzvd();
        byte by3 = this.zzvd();
        byte by4 = this.zzvd();
        byte by5 = this.zzvd();
        byte by6 = this.zzvd();
        byte by7 = this.zzvd();
        byte by8 = this.zzvd();
        return (long)by & 0xFFL | ((long)by2 & 0xFFL) << 8 | ((long)by3 & 0xFFL) << 16 | ((long)by4 & 0xFFL) << 24 | ((long)by5 & 0xFFL) << 32 | ((long)by6 & 0xFFL) << 40 | ((long)by7 & 0xFFL) << 48 | ((long)by8 & 0xFFL) << 56;
    }

    private zzyx(byte[] byArray, int n, int n2) {
        this.buffer = byArray;
        this.zzcev = n;
        this.zzcew = this.zzcex = n + n2;
        this.zzcey = n;
    }

    public final <T extends zzvm<T, ?>> T zza(zzxd<T> zzxd2) throws IOException {
        try {
            int n;
            int n2;
            zzyx zzyx2 = this;
            if (zzyx2.zzcez == null) {
                zzyx2.zzcez = zzuo.zzd(zzyx2.buffer, zzyx2.zzcev, zzyx2.zzcew);
            }
            if ((n2 = zzyx2.zzcez.zzux()) > (n = zzyx2.zzcey - zzyx2.zzcev)) {
                throw new IOException(String.format("CodedInputStream read ahead of CodedInputByteBufferNano: %s > %s", n2, n));
            }
            zzyx2.zzcez.zzas(n - n2);
            zzyx2.zzcez.zzap(zzyx2.zzbui - zzyx2.zzbuh);
            zzvm zzvm2 = (zzvm)zzyx2.zzcez.zza(zzxd2, zzuz.zzvp());
            this.zzao(this.zzbup);
            return (T)zzvm2;
        }
        catch (zzvt zzvt2) {
            throw new zzzf("", zzvt2);
        }
    }

    public final int zzaq(int n) throws zzzf {
        if (n < 0) {
            throw zzzf.zzyx();
        }
        int n2 = this.zzbuq;
        if ((n += this.zzcey) > n2) {
            throw zzzf.zzyw();
        }
        this.zzbuq = n;
        this.zzvc();
        return n2;
    }

    private final void zzvc() {
        this.zzcex += this.zzbun;
        int n = this.zzcex;
        if (n > this.zzbuq) {
            this.zzbun = n - this.zzbuq;
            this.zzcex -= this.zzbun;
            return;
        }
        this.zzbun = 0;
    }

    public final void zzar(int n) {
        this.zzbuq = n;
        this.zzvc();
    }

    public final int zzyr() {
        if (this.zzbuq == Integer.MAX_VALUE) {
            return -1;
        }
        int n = this.zzcey;
        return this.zzbuq - n;
    }

    public final int getPosition() {
        return this.zzcey - this.zzcev;
    }

    public final byte[] zzs(int n, int n2) {
        if (n2 == 0) {
            return zzzj.zzcfx;
        }
        byte[] byArray = new byte[n2];
        int n3 = this.zzcev + n;
        System.arraycopy(this.buffer, n3, byArray, 0, n2);
        return byArray;
    }

    public final void zzby(int n) {
        this.zzt(n, this.zzbup);
    }

    final void zzt(int n, int n2) {
        if (n > this.zzcey - this.zzcev) {
            int n3 = this.zzcey - this.zzcev;
            throw new IllegalArgumentException(new StringBuilder(50).append("Position ").append(n).append(" is beyond current ").append(n3).toString());
        }
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(24).append("Bad position ").append(n).toString());
        }
        this.zzcey = this.zzcev + n;
        this.zzbup = n2;
    }

    private final byte zzvd() throws IOException {
        if (this.zzcey == this.zzcex) {
            throw zzzf.zzyw();
        }
        return this.buffer[this.zzcey++];
    }

    private final void zzas(int n) throws IOException {
        if (n < 0) {
            throw zzzf.zzyx();
        }
        if (this.zzcey + n > this.zzbuq) {
            this.zzas(this.zzbuq - this.zzcey);
            throw zzzf.zzyw();
        }
        if (n <= this.zzcex - this.zzcey) {
            this.zzcey += n;
            return;
        }
        throw zzzf.zzyw();
    }
}

