/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzun;
import com.google.android.gms.internal.measurement.zzuz;
import com.google.android.gms.internal.measurement.zzva;
import com.google.android.gms.internal.measurement.zzvk;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwe;
import com.google.android.gms.internal.measurement.zzxe;
import com.google.android.gms.internal.measurement.zzxo;
import com.google.android.gms.internal.measurement.zzyu;
import java.io.IOException;
import java.util.Arrays;

final class zzvb
extends zzuz {
    private final byte[] buffer;
    private final boolean zzbvh;
    private int limit;
    private int zzbvi;
    private int pos;
    private int zzbvj;
    private int zzbvk;
    private int zzbvl = Integer.MAX_VALUE;

    private zzvb(byte[] byArray, int n, int n2, boolean bl) {
        super(null);
        this.buffer = byArray;
        this.limit = n + n2;
        this.zzbvj = this.pos = n;
        this.zzbvh = bl;
    }

    @Override
    public final int zzuq() throws IOException {
        if (((zzuz)this).zzvg()) {
            this.zzbvk = 0;
            return 0;
        }
        this.zzbvk = this.zzvi();
        if (this.zzbvk >>> 3 == 0) {
            throw new zzwe("Protocol message contained an invalid tag (zero).");
        }
        return this.zzbvk;
    }

    @Override
    public final void zzao(int n) throws zzwe {
        if (this.zzbvk != n) {
            throw zzwe.zzxa();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean zzap(int n) throws IOException {
        switch (n & 7) {
            case 0: {
                zzvb zzvb2 = this;
                if (zzvb2.limit - zzvb2.pos >= 10) {
                    zzvb zzvb3 = zzvb2;
                    for (int i = 0; i < 10; ++i) {
                        if (zzvb3.buffer[zzvb3.pos++] >= 0) return true;
                    }
                    throw zzwe.zzwz();
                }
                zzvb zzvb4 = zzvb2;
                for (int i = 0; i < 10; ++i) {
                    if (zzvb4.zzvn() >= 0) return true;
                }
                throw zzwe.zzwz();
            }
            case 1: {
                ((zzuz)this).zzat(8);
                return true;
            }
            case 2: {
                ((zzuz)this).zzat(this.zzvi());
                return true;
            }
            case 3: {
                int n2;
                zzvb zzvb5 = this;
                while ((n2 = ((zzuz)zzvb5).zzuq()) != 0 && ((zzuz)zzvb5).zzap(n2)) {
                }
                ((zzuz)this).zzao(n >>> 3 << 3 | 4);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                ((zzuz)this).zzat(4);
                return true;
            }
        }
        throw zzwe.zzxb();
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.zzvl());
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.zzvk());
    }

    @Override
    public final long zzur() throws IOException {
        return this.zzvj();
    }

    @Override
    public final long zzus() throws IOException {
        return this.zzvj();
    }

    @Override
    public final int zzut() throws IOException {
        return this.zzvi();
    }

    @Override
    public final long zzuu() throws IOException {
        return this.zzvl();
    }

    @Override
    public final int zzuv() throws IOException {
        return this.zzvk();
    }

    @Override
    public final boolean zzuw() throws IOException {
        return this.zzvj() != 0L;
    }

    @Override
    public final String readString() throws IOException {
        int n = this.zzvi();
        if (n > 0 && n <= this.limit - this.pos) {
            String string = new String(this.buffer, this.pos, n, zzvz.UTF_8);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw zzwe.zzwy();
        }
        throw zzwe.zzwx();
    }

    @Override
    public final String zzux() throws IOException {
        int n = this.zzvi();
        if (n > 0 && n <= this.limit - this.pos) {
            String string = zzyu.zzh(this.buffer, this.pos, n);
            this.pos += n;
            return string;
        }
        if (n == 0) {
            return "";
        }
        if (n <= 0) {
            throw zzwe.zzwy();
        }
        throw zzwe.zzwx();
    }

    @Override
    public final <T extends zzxe> T zza(zzxo<T> zzxo2, zzvk zzvk2) throws IOException {
        int n = this.zzvi();
        if (this.zzbvc >= this.zzbvd) {
            throw zzwe.zzxc();
        }
        int n2 = ((zzuz)this).zzar(n);
        ++this.zzbvc;
        zzxe zzxe2 = (zzxe)zzxo2.zza(this, zzvk2);
        ((zzuz)this).zzao(0);
        --this.zzbvc;
        ((zzuz)this).zzas(n2);
        return (T)zzxe2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final zzun zzuy() throws IOException {
        byte[] byArray;
        int n = this.zzvi();
        if (n > 0 && n <= this.limit - this.pos) {
            zzun zzun2 = zzun.zzb(this.buffer, this.pos, n);
            this.pos += n;
            return zzun2;
        }
        if (n == 0) {
            return zzun.zzbuu;
        }
        int n2 = n;
        zzvb zzvb2 = this;
        if (n2 > 0 && n2 <= zzvb2.limit - zzvb2.pos) {
            int n3 = zzvb2.pos;
            zzvb2.pos += n2;
            byArray = Arrays.copyOfRange(zzvb2.buffer, n3, zzvb2.pos);
            return zzun.zzi(byArray);
        } else {
            if (n2 > 0) throw zzwe.zzwx();
            if (n2 != 0) throw zzwe.zzwy();
            byArray = zzvz.zzcae;
        }
        return zzun.zzi(byArray);
    }

    @Override
    public final int zzuz() throws IOException {
        return this.zzvi();
    }

    @Override
    public final int zzva() throws IOException {
        return this.zzvi();
    }

    @Override
    public final int zzvb() throws IOException {
        return this.zzvk();
    }

    @Override
    public final long zzvc() throws IOException {
        return this.zzvl();
    }

    @Override
    public final int zzvd() throws IOException {
        int n = this.zzvi();
        return n >>> 1 ^ -(n & 1);
    }

    @Override
    public final long zzve() throws IOException {
        long l = this.zzvj();
        return l >>> 1 ^ -(l & 1L);
    }

    private final int zzvi() throws IOException {
        block4: {
            int n;
            int n2;
            block6: {
                byte[] byArray;
                block8: {
                    block7: {
                        block5: {
                            n2 = this.pos;
                            if (this.limit == n2) break block4;
                            byArray = this.buffer;
                            if ((n = this.buffer[n2++]) >= 0) {
                                this.pos = n2;
                                return n;
                            }
                            if (this.limit - n2 < 9) break block4;
                            if ((n ^= byArray[n2++] << 7) >= 0) break block5;
                            n ^= 0xFFFFFF80;
                            break block6;
                        }
                        if ((n ^= byArray[n2++] << 14) < 0) break block7;
                        n ^= 0x3F80;
                        break block6;
                    }
                    if ((n ^= byArray[n2++] << 21) >= 0) break block8;
                    n ^= 0xFFE03F80;
                    break block6;
                }
                byte by = byArray[n2++];
                n = n ^ by << 28 ^ 0xFE03F80;
                if (by < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0 && byArray[n2++] < 0) break block4;
            }
            this.pos = n2;
            return n;
        }
        return (int)((zzuz)this).zzvf();
    }

    private final long zzvj() throws IOException {
        block4: {
            long l;
            int n;
            block6: {
                byte[] byArray;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                int n2;
                                block8: {
                                    block7: {
                                        block5: {
                                            n = this.pos;
                                            if (this.limit == n) break block4;
                                            byArray = this.buffer;
                                            if ((n2 = this.buffer[n++]) >= 0) {
                                                this.pos = n;
                                                return n2;
                                            }
                                            if (this.limit - n < 9) break block4;
                                            if ((n2 ^= byArray[n++] << 7) >= 0) break block5;
                                            l = n2 ^ 0xFFFFFF80;
                                            break block6;
                                        }
                                        if ((n2 ^= byArray[n++] << 14) < 0) break block7;
                                        l = n2 ^ 0x3F80;
                                        break block6;
                                    }
                                    if ((n2 ^= byArray[n++] << 21) >= 0) break block8;
                                    l = n2 ^ 0xFFE03F80;
                                    break block6;
                                }
                                if ((l = (long)n2 ^ (long)byArray[n++] << 28) < 0L) break block9;
                                l ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((l ^= (long)byArray[n++] << 35) >= 0L) break block10;
                            l ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((l ^= (long)byArray[n++] << 42) < 0L) break block11;
                        l ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((l ^= (long)byArray[n++] << 49) >= 0L) break block12;
                    l ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                if ((l = l ^ (long)byArray[n++] << 56 ^ 0xFE03F80FE03F80L) < 0L && (long)byArray[n++] < 0L) break block4;
            }
            this.pos = n;
            return l;
        }
        return ((zzuz)this).zzvf();
    }

    @Override
    final long zzvf() throws IOException {
        long l = 0L;
        for (int i = 0; i < 64; i += 7) {
            byte by = this.zzvn();
            l |= (long)(by & 0x7F) << i;
            if ((by & 0x80) != 0) continue;
            return l;
        }
        throw zzwe.zzwz();
    }

    private final int zzvk() throws IOException {
        int n = this.pos;
        if (this.limit - n < 4) {
            throw zzwe.zzwx();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 4;
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private final long zzvl() throws IOException {
        int n = this.pos;
        if (this.limit - n < 8) {
            throw zzwe.zzwx();
        }
        byte[] byArray = this.buffer;
        this.pos = n + 8;
        return (long)byArray[n] & 0xFFL | ((long)byArray[n + 1] & 0xFFL) << 8 | ((long)byArray[n + 2] & 0xFFL) << 16 | ((long)byArray[n + 3] & 0xFFL) << 24 | ((long)byArray[n + 4] & 0xFFL) << 32 | ((long)byArray[n + 5] & 0xFFL) << 40 | ((long)byArray[n + 6] & 0xFFL) << 48 | ((long)byArray[n + 7] & 0xFFL) << 56;
    }

    @Override
    public final int zzar(int n) throws zzwe {
        int n2;
        if (n < 0) {
            throw zzwe.zzwy();
        }
        if ((n += ((zzuz)this).zzvh()) > (n2 = this.zzbvl)) {
            throw zzwe.zzwx();
        }
        this.zzbvl = n;
        this.zzvm();
        return n2;
    }

    private final void zzvm() {
        this.limit += this.zzbvi;
        int n = this.limit - this.zzbvj;
        if (n > this.zzbvl) {
            this.zzbvi = n - this.zzbvl;
            this.limit -= this.zzbvi;
            return;
        }
        this.zzbvi = 0;
    }

    @Override
    public final void zzas(int n) {
        this.zzbvl = n;
        this.zzvm();
    }

    @Override
    public final boolean zzvg() throws IOException {
        return this.pos == this.limit;
    }

    @Override
    public final int zzvh() {
        return this.pos - this.zzbvj;
    }

    private final byte zzvn() throws IOException {
        if (this.pos == this.limit) {
            throw zzwe.zzwx();
        }
        return this.buffer[this.pos++];
    }

    @Override
    public final void zzat(int n) throws IOException {
        if (n >= 0 && n <= this.limit - this.pos) {
            this.pos += n;
            return;
        }
        if (n < 0) {
            throw zzwe.zzwy();
        }
        throw zzwe.zzwx();
    }

    /* synthetic */ zzvb(byte[] byArray, int n, int n2, boolean bl, zzva zzva2) {
        this(byArray, n, n2, bl);
    }
}

