/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzuj;
import com.google.android.gms.internal.measurement.zzvz;
import com.google.android.gms.internal.measurement.zzwd;
import com.google.android.gms.internal.measurement.zzxp;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzws
extends zzuj<Long>
implements zzwd<Long>,
zzxp,
RandomAccess {
    private static final zzws zzcbh = new zzws();
    private long[] zzcbi;
    private int size;

    zzws() {
        this(new long[10], 0);
    }

    private zzws(long[] lArray, int n) {
        this.zzcbi = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzuh();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcbi, n2, this.zzcbi, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzws)) {
            return super.equals(object);
        }
        zzws zzws2 = (zzws)object;
        if (this.size != zzws2.size) {
            return false;
        }
        long[] lArray = zzws2.zzcbi;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcbi[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzvz.zzbi(this.zzcbi[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzai(n);
        return this.zzcbi[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbj(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzuh();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
        if (this.size < this.zzcbi.length) {
            System.arraycopy(this.zzcbi, n, this.zzcbi, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcbi, 0, lArray, 0, n);
            System.arraycopy(this.zzcbi, n, lArray, n + 1, this.size - n);
            this.zzcbi = lArray;
        }
        this.zzcbi[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzuh();
        zzvz.checkNotNull(collection);
        if (!(collection instanceof zzws)) {
            return super.addAll(collection);
        }
        zzws zzws2 = (zzws)collection;
        if (zzws2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzws2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzws2.size;
        if (n > this.zzcbi.length) {
            this.zzcbi = Arrays.copyOf(this.zzcbi, n);
        }
        System.arraycopy(zzws2.zzcbi, 0, this.zzcbi, this.size, zzws2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzuh();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcbi[i])) continue;
            System.arraycopy(this.zzcbi, i + 1, this.zzcbi, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzai(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaj(n));
        }
    }

    private final String zzaj(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzws zzws2 = this;
        zzws2.zzuh();
        zzws2.zzai(n);
        long l3 = zzws2.zzcbi[n];
        zzws2.zzcbi[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzws zzws2 = this;
        zzws2.zzuh();
        zzws2.zzai(n);
        long l = zzws2.zzcbi[n];
        if (n < zzws2.size - 1) {
            System.arraycopy(zzws2.zzcbi, n + 1, zzws2.zzcbi, n, zzws2.size - n);
        }
        --zzws2.size;
        ++zzws2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzwd zzak(int n) {
        int n2 = n;
        zzws zzws2 = this;
        if (n2 < zzws2.size) {
            throw new IllegalArgumentException();
        }
        return new zzws(Arrays.copyOf(zzws2.zzcbi, n2), zzws2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzcbh.zzsw();
    }
}

