/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzsx;
import com.google.android.gms.internal.measurement.zztd;
import com.google.android.gms.internal.measurement.zzte;
import com.google.android.gms.internal.measurement.zztw;
import com.google.android.gms.internal.measurement.zztx;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzvc;
import com.google.android.gms.internal.measurement.zzvv;
import com.google.android.gms.internal.measurement.zzwl;
import com.google.android.gms.internal.measurement.zzxj;
import com.google.android.gms.internal.measurement.zzxl;
import com.google.android.gms.internal.measurement.zzxp;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zztv
extends zztd {
    private static final Logger logger = Logger.getLogger(zztv.class.getName());
    private static final boolean zzbum = zzxj.zzyo();
    zztx zzbun;

    public static zztv zzj(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zztv zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zzxj.zzyp()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zztv() {
    }

    public abstract void zzc(int var1, int var2) throws IOException;

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public final void zzf(int n, int n2) throws IOException {
        this.zze(n, zztv.zzbk(n2));
    }

    public abstract void zzg(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zztv.zzbb(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzg(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zzb(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzte var2) throws IOException;

    public abstract void zza(int var1, zzvv var2) throws IOException;

    abstract void zza(int var1, zzvv var2, zzwl var3) throws IOException;

    public abstract void zzb(int var1, zzvv var2) throws IOException;

    public abstract void zzb(int var1, zzte var2) throws IOException;

    public abstract void zzaz(int var1) throws IOException;

    public abstract void zzba(int var1) throws IOException;

    public final void zzbb(int n) throws IOException {
        this.zzba(zztv.zzbk(n));
    }

    public abstract void zzbc(int var1) throws IOException;

    public abstract void zzat(long var1) throws IOException;

    public final void zzau(long l) throws IOException {
        this.zzat(zztv.zzbb(l));
    }

    public abstract void zzav(long var1) throws IOException;

    public final void zza(float f) throws IOException {
        this.zzbc(Float.floatToRawIntBits(f));
    }

    public final void zzb(double d) throws IOException {
        this.zzav(Double.doubleToRawLongBits(d));
    }

    public final void zzs(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzgb(String var1) throws IOException;

    public abstract void zza(zzte var1) throws IOException;

    public abstract void zzb(zzvv var1) throws IOException;

    abstract void zza(zzvv var1, zzwl var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzh(int n, int n2) {
        return zztv.zzbd(n) + zztv.zzbe(n2);
    }

    public static int zzi(int n, int n2) {
        return zztv.zzbd(n) + zztv.zzbf(n2);
    }

    public static int zzj(int n, int n2) {
        return zztv.zzbd(n) + zztv.zzbf(zztv.zzbk(n2));
    }

    public static int zzk(int n, int n2) {
        return zztv.zzbd(n) + 4;
    }

    public static int zzl(int n, int n2) {
        return zztv.zzbd(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zztv.zzbd(n) + zztv.zzax(l);
    }

    public static int zze(int n, long l) {
        return zztv.zzbd(n) + zztv.zzax(l);
    }

    public static int zzf(int n, long l) {
        return zztv.zzbd(n) + zztv.zzax(zztv.zzbb(l));
    }

    public static int zzg(int n, long l) {
        return zztv.zzbd(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zztv.zzbd(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zztv.zzbd(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zztv.zzbd(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zztv.zzbd(n) + 1;
    }

    public static int zzm(int n, int n2) {
        return zztv.zzbd(n) + zztv.zzbe(n2);
    }

    public static int zzc(int n, String string) {
        return zztv.zzbd(n) + zztv.zzgc(string);
    }

    public static int zzc(int n, zzte zzte2) {
        int n2 = zzte2.size();
        return zztv.zzbd(n) + (zztv.zzbf(n2) + n2);
    }

    public static int zza(int n, zzvc zzvc2) {
        int n2 = zzvc2.zzvx();
        return zztv.zzbd(n) + (zztv.zzbf(n2) + n2);
    }

    public static int zzc(int n, zzvv zzvv2) {
        return zztv.zzbd(n) + zztv.zzc(zzvv2);
    }

    static int zzb(int n, zzvv zzvv2, zzwl zzwl2) {
        return zztv.zzbd(n) + zztv.zzb(zzvv2, zzwl2);
    }

    public static int zzd(int n, zzvv zzvv2) {
        return (zztv.zzbd(1) << 1) + zztv.zzi(2, n) + zztv.zzc(3, zzvv2);
    }

    public static int zzd(int n, zzte zzte2) {
        return (zztv.zzbd(1) << 1) + zztv.zzi(2, n) + zztv.zzc(3, zzte2);
    }

    public static int zzb(int n, zzvc zzvc2) {
        return (zztv.zzbd(1) << 1) + zztv.zzi(2, n) + zztv.zza(3, zzvc2);
    }

    public static int zzbd(int n) {
        return zztv.zzbf(n << 3);
    }

    public static int zzbe(int n) {
        if (n >= 0) {
            return zztv.zzbf(n);
        }
        return 10;
    }

    public static int zzbf(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzbg(int n) {
        return zztv.zzbf(zztv.zzbk(n));
    }

    public static int zzbh(int n) {
        return 4;
    }

    public static int zzbi(int n) {
        return 4;
    }

    public static int zzaw(long l) {
        return zztv.zzax(l);
    }

    public static int zzax(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzay(long l) {
        return zztv.zzax(zztv.zzbb(l));
    }

    public static int zzaz(long l) {
        return 8;
    }

    public static int zzba(long l) {
        return 8;
    }

    public static int zzb(float f) {
        return 4;
    }

    public static int zzc(double d) {
        return 8;
    }

    public static int zzt(boolean bl) {
        return 1;
    }

    public static int zzbj(int n) {
        return zztv.zzbe(n);
    }

    public static int zzgc(String string) {
        int n;
        try {
            n = zzxl.zza(string);
        }
        catch (zzxp zzxp2) {
            n = string.getBytes(zzuq.UTF_8).length;
        }
        int n2 = n;
        return zztv.zzbf(n2) + n2;
    }

    public static int zza(zzvc zzvc2) {
        int n = zzvc2.zzvx();
        return zztv.zzbf(n) + n;
    }

    public static int zzb(zzte zzte2) {
        int n = zzte2.size();
        return zztv.zzbf(n) + n;
    }

    public static int zzk(byte[] byArray) {
        int n = byArray.length;
        return zztv.zzbf(n) + n;
    }

    public static int zzc(zzvv zzvv2) {
        int n = zzvv2.zzvx();
        return zztv.zzbf(n) + n;
    }

    static int zzb(zzvv zzvv2, zzwl zzwl2) {
        zzwl zzwl3 = zzwl2;
        zzsx zzsx2 = (zzsx)zzvv2;
        int n = zzsx2.zztx();
        if (n == -1) {
            n = zzwl3.zzai(zzsx2);
            zzsx2.zzai(n);
        }
        int n2 = n;
        return zztv.zzbf(n2) + n2;
    }

    private static int zzbk(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzbb(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzvj();

    abstract void zze(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzxp zzxp2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzxp2);
        byte[] byArray = string.getBytes(zzuq.UTF_8);
        try {
            this.zzba(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzvv zzvv2, zzwl zzwl2) {
        zzwl zzwl3;
        int n2 = zztv.zzbd(n) << 1;
        zzwl zzwl4 = zzwl3 = zzwl2;
        zzsx zzsx2 = (zzsx)zzvv2;
        int n3 = zzsx2.zztx();
        if (n3 == -1) {
            n3 = zzwl4.zzai(zzsx2);
            zzsx2.zzai(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzvv zzvv2) {
        return zzvv2.zzvx();
    }

    @Deprecated
    public static int zzbl(int n) {
        return zztv.zzbf(n);
    }

    /* synthetic */ zztv(zztw zztw2) {
        this();
    }

    static final class zze
    extends zztv {
        private final ByteBuffer zzbuq;
        private final ByteBuffer zzbur;
        private final long zzbus;
        private final long zzbut;
        private final long zzbuu;
        private final long zzbuv;
        private long zzbuw;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzbuq = byteBuffer;
            this.zzbur = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbus = zzxj.zzb(byteBuffer);
            this.zzbut = this.zzbus + (long)byteBuffer.position();
            this.zzbuu = this.zzbus + (long)byteBuffer.limit();
            this.zzbuv = this.zzbuu - 10L;
            this.zzbuw = this.zzbut;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zztv)this).zzba(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzaz(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzba(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 5);
            ((zztv)this).zzbc(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzat(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 1);
            ((zztv)this).zzav(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzgb(string);
        }

        @Override
        public final void zza(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zza(zzte2);
        }

        @Override
        public final void zza(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzb(zzvv2);
        }

        @Override
        final void zza(int n, zzvv zzvv2, zzwl zzwl2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zza(zzvv2, zzwl2);
        }

        @Override
        public final void zzb(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzvv2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzte2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzvv zzvv2) throws IOException {
            ((zztv)this).zzba(zzvv2.zzvx());
            zzvv2.zzb(this);
        }

        @Override
        final void zza(zzvv zzvv2, zzwl zzwl2) throws IOException {
            zzwl zzwl3 = zzwl2;
            zzsx zzsx2 = (zzsx)zzvv2;
            int n = zzsx2.zztx();
            if (n == -1) {
                n = zzwl3.zzai(zzsx2);
                zzsx2.zzai(n);
            }
            ((zztv)this).zzba(n);
            zzwl2.zza(zzvv2, this.zzbun);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zzbuw >= this.zzbuu) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbuw, this.zzbuu, 1));
            }
            zzxj.zza(this.zzbuw++, by);
        }

        @Override
        public final void zza(zzte zzte2) throws IOException {
            ((zztv)this).zzba(zzte2.size());
            zzte2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).zzba(n2);
            ((zztv)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzaz(int n) throws IOException {
            if (n >= 0) {
                ((zztv)this).zzba(n);
                return;
            }
            ((zztv)this).zzat(n);
        }

        @Override
        public final void zzba(int n) throws IOException {
            if (this.zzbuw <= this.zzbuv) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzxj.zza(this.zzbuw++, (byte)n);
                        return;
                    }
                    zzxj.zza(this.zzbuw++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zzbuw < this.zzbuu) {
                if ((n & 0xFFFFFF80) == 0) {
                    zzxj.zza(this.zzbuw++, (byte)n);
                    return;
                }
                zzxj.zza(this.zzbuw++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbuw, this.zzbuu, 1));
        }

        @Override
        public final void zzbc(int n) throws IOException {
            long l = this.zzbuw;
            zze zze2 = this;
            this.zzbur.putInt((int)(l - zze2.zzbus), n);
            this.zzbuw += 4L;
        }

        @Override
        public final void zzat(long l) throws IOException {
            if (this.zzbuw <= this.zzbuv) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzxj.zza(this.zzbuw++, (byte)l);
                        return;
                    }
                    zzxj.zza(this.zzbuw++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zzbuw < this.zzbuu) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zzxj.zza(this.zzbuw++, (byte)l);
                    return;
                }
                zzxj.zza(this.zzbuw++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbuw, this.zzbuu, 1));
        }

        @Override
        public final void zzav(long l) throws IOException {
            long l2 = this.zzbuw;
            zze zze2 = this;
            this.zzbur.putLong((int)(l2 - zze2.zzbus), l);
            this.zzbuw += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzbuu - (long)n2 < this.zzbuw) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zzbuw, this.zzbuu, n2));
            }
            zzxj.zza(byArray, n, this.zzbuw, n2);
            this.zzbuw += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgb(String string) throws IOException {
            long l = this.zzbuw;
            try {
                int n = zze.zzbf(string.length() * 3);
                int n2 = zze.zzbf(string.length());
                if (n2 == n) {
                    long l2 = this.zzbuw;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzbus) + n2;
                    this.zzbur.position(n3);
                    zzxl.zza(string, this.zzbur);
                    int n4 = this.zzbur.position() - n3;
                    ((zztv)this).zzba(n4);
                    this.zzbuw += (long)n4;
                    return;
                }
                int n5 = zzxl.zza(string);
                ((zztv)this).zzba(n5);
                this.zzbc(this.zzbuw);
                zzxl.zza(string, this.zzbur);
                this.zzbuw += (long)n5;
                return;
            }
            catch (zzxp zzxp2) {
                this.zzbuw = l;
                this.zzbc(this.zzbuw);
                this.zza(string, zzxp2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zzbuw;
            zze zze2 = this;
            this.zzbuq.position((int)(l - zze2.zzbus));
        }

        @Override
        public final int zzvj() {
            return (int)(this.zzbuu - this.zzbuw);
        }

        private final void zzbc(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzbur.position((int)(l2 - zze2.zzbus));
        }
    }

    static final class zzd
    extends zztv {
        private final ByteBuffer zzbuq;
        private final ByteBuffer zzbur;
        private final int zzbup;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzbuq = byteBuffer;
            this.zzbur = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzbup = byteBuffer.position();
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zztv)this).zzba(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzaz(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzba(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 5);
            ((zztv)this).zzbc(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzat(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 1);
            ((zztv)this).zzav(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzgb(string);
        }

        @Override
        public final void zza(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zza(zzte2);
        }

        @Override
        public final void zza(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzb(zzvv2);
        }

        @Override
        final void zza(int n, zzvv zzvv2, zzwl zzwl2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zza(zzvv2, zzwl2);
        }

        @Override
        public final void zzb(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzvv2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzte2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzvv zzvv2) throws IOException {
            ((zztv)this).zzba(zzvv2.zzvx());
            zzvv2.zzb(this);
        }

        @Override
        final void zza(zzvv zzvv2, zzwl zzwl2) throws IOException {
            zzwl zzwl3 = zzwl2;
            zzsx zzsx2 = (zzsx)zzvv2;
            int n = zzsx2.zztx();
            if (n == -1) {
                n = zzwl3.zzai(zzsx2);
                zzsx2.zzai(n);
            }
            ((zztv)this).zzba(n);
            zzwl2.zza(zzvv2, this.zzbun);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzbur.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzte zzte2) throws IOException {
            ((zztv)this).zzba(zzte2.size());
            zzte2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).zzba(n2);
            ((zztv)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzaz(int n) throws IOException {
            if (n >= 0) {
                ((zztv)this).zzba(n);
                return;
            }
            ((zztv)this).zzat(n);
        }

        @Override
        public final void zzba(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzbur.put((byte)n);
                        return;
                    }
                    this.zzbur.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzbc(int n) throws IOException {
            try {
                this.zzbur.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzat(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzbur.put((byte)l);
                        return;
                    }
                    this.zzbur.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzav(long l) throws IOException {
            try {
                this.zzbur.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzbur.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgb(String string) throws IOException {
            int n = this.zzbur.position();
            try {
                int n2 = zzd.zzbf(string.length() * 3);
                int n3 = zzd.zzbf(string.length());
                if (n3 == n2) {
                    int n4 = this.zzbur.position() + n3;
                    this.zzbur.position(n4);
                    this.zzgd(string);
                    int n5 = this.zzbur.position();
                    this.zzbur.position(n);
                    ((zztv)this).zzba(n5 - n4);
                    this.zzbur.position(n5);
                    return;
                }
                int n6 = zzxl.zza(string);
                ((zztv)this).zzba(n6);
                this.zzgd(string);
                return;
            }
            catch (zzxp zzxp2) {
                this.zzbur.position(n);
                this.zza(string, zzxp2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzbuq.position(this.zzbur.position());
        }

        @Override
        public final int zzvj() {
            return this.zzbur.remaining();
        }

        private final void zzgd(String string) throws IOException {
            try {
                zzxl.zza(string, this.zzbur);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzbuo;
        private int zzbup;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzbuo = byteBuffer;
            this.zzbup = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzbuo.position(this.zzbup + this.zzvl());
        }
    }

    static class zza
    extends zztv {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzc(int n, int n2) throws IOException {
            int n3 = n2;
            ((zztv)this).zzba(n << 3 | n3);
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzaz(n2);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzba(n2);
        }

        @Override
        public final void zzg(int n, int n2) throws IOException {
            ((zztv)this).zzc(n, 5);
            ((zztv)this).zzbc(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzat(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zztv)this).zzc(n, 1);
            ((zztv)this).zzav(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zztv)this).zzc(n, 0);
            ((zztv)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zzb(int n, String string) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzgb(string);
        }

        @Override
        public final void zza(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zza(zzte2);
        }

        @Override
        public final void zza(zzte zzte2) throws IOException {
            ((zztv)this).zzba(zzte2.size());
            zzte2.zza(this);
        }

        @Override
        public final void zze(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).zzba(n2);
            ((zztv)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(n, 2);
            ((zztv)this).zzb(zzvv2);
        }

        @Override
        final void zza(int n, zzvv zzvv2, zzwl zzwl2) throws IOException {
            ((zztv)this).zzc(n, 2);
            zzwl zzwl3 = zzwl2;
            zzsx zzsx2 = (zzsx)zzvv2;
            int n2 = zzsx2.zztx();
            if (n2 == -1) {
                n2 = zzwl3.zzai(zzsx2);
                zzsx2.zzai(n2);
            }
            ((zztv)this).zzba(n2);
            zzwl2.zza(zzvv2, this.zzbun);
        }

        @Override
        public final void zzb(int n, zzvv zzvv2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzvv2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(int n, zzte zzte2) throws IOException {
            ((zztv)this).zzc(1, 3);
            ((zztv)this).zze(2, n);
            ((zztv)this).zza(3, zzte2);
            ((zztv)this).zzc(1, 4);
        }

        @Override
        public final void zzb(zzvv zzvv2) throws IOException {
            ((zztv)this).zzba(zzvv2.zzvx());
            zzvv2.zzb(this);
        }

        @Override
        final void zza(zzvv zzvv2, zzwl zzwl2) throws IOException {
            zzwl zzwl3 = zzwl2;
            zzsx zzsx2 = (zzsx)zzvv2;
            int n = zzsx2.zztx();
            if (n == -1) {
                n = zzwl3.zzai(zzsx2);
                zzsx2.zzai(n);
            }
            ((zztv)this).zzba(n);
            zzwl2.zza(zzvv2, this.zzbun);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzaz(int n) throws IOException {
            if (n >= 0) {
                ((zztv)this).zzba(n);
                return;
            }
            ((zztv)this).zzat(n);
        }

        @Override
        public final void zzba(int n) throws IOException {
            if (zzbum && ((zztv)this).zzvj() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zzxj.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zzxj.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzbc(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = (byte)(n >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzat(long l) throws IOException {
            if (zzbum && ((zztv)this).zzvj() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zzxj.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zzxj.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzav(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zztv)this).write(byArray, n, n2);
        }

        @Override
        public final void zzgb(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzbf(string.length() * 3);
                int n3 = zza.zzbf(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zzxl.zza(string, this.buffer, this.position, ((zztv)this).zzvj());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zztv)this).zzba(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zzxl.zza(string);
                ((zztv)this).zzba(n6);
                this.position = zzxl.zza(string, this.buffer, this.position, ((zztv)this).zzvj());
                return;
            }
            catch (zzxp zzxp2) {
                this.position = n;
                this.zza(string, zzxp2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzvj() {
            return this.limit - this.position;
        }

        public final int zzvl() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

