/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzta;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzwg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzup
extends zzta<Integer>
implements zzuu<Integer>,
zzwg,
RandomAccess {
    private static final zzup zzbyy = new zzup();
    private int[] zzbyz;
    private int size;

    zzup() {
        this(new int[10], 0);
    }

    private zzup(int[] nArray, int n) {
        this.zzbyz = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzua();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbyz, n2, this.zzbyz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzup)) {
            return super.equals(object);
        }
        zzup zzup2 = (zzup)object;
        if (this.size != zzup2.size) {
            return false;
        }
        int[] nArray = zzup2.zzbyz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbyz[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzbyz[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzaj(n);
        return this.zzbyz[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbo(int n) {
        this.zzp(this.size, n);
    }

    private final void zzp(int n, int n2) {
        this.zzua();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
        if (this.size < this.zzbyz.length) {
            System.arraycopy(this.zzbyz, n, this.zzbyz, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbyz, 0, nArray, 0, n);
            System.arraycopy(this.zzbyz, n, nArray, n + 1, this.size - n);
            this.zzbyz = nArray;
        }
        this.zzbyz[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzua();
        zzuq.checkNotNull(collection);
        if (!(collection instanceof zzup)) {
            return super.addAll(collection);
        }
        zzup zzup2 = (zzup)collection;
        if (zzup2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzup2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzup2.size;
        if (n > this.zzbyz.length) {
            this.zzbyz = Arrays.copyOf(this.zzbyz, n);
        }
        System.arraycopy(zzup2.zzbyz, 0, this.zzbyz, this.size, zzup2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzua();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbyz[i])) continue;
            System.arraycopy(this.zzbyz, i + 1, this.zzbyz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
    }

    private final String zzak(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzup zzup2 = this;
        zzup2.zzua();
        zzup2.zzaj(n);
        int n4 = zzup2.zzbyz[n];
        zzup2.zzbyz[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzup zzup2 = this;
        zzup2.zzua();
        zzup2.zzaj(n);
        int n2 = zzup2.zzbyz[n];
        if (n < zzup2.size - 1) {
            System.arraycopy(zzup2.zzbyz, n + 1, zzup2.zzbyz, n, zzup2.size - n - 1);
        }
        --zzup2.size;
        ++zzup2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzp(n, n2);
    }

    @Override
    public final /* synthetic */ zzuu zzal(int n) {
        int n2 = n;
        zzup zzup2 = this;
        if (n2 < zzup2.size) {
            throw new IllegalArgumentException();
        }
        return new zzup(Arrays.copyOf(zzup2.zzbyz, n2), zzup2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzbyy.zzsw();
    }
}

