/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzta;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzwg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzvj
extends zzta<Long>
implements zzuu<Long>,
zzwg,
RandomAccess {
    private static final zzvj zzcad = new zzvj();
    private long[] zzcae;
    private int size;

    zzvj() {
        this(new long[10], 0);
    }

    private zzvj(long[] lArray, int n) {
        this.zzcae = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzua();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzcae, n2, this.zzcae, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzvj)) {
            return super.equals(object);
        }
        zzvj zzvj2 = (zzvj)object;
        if (this.size != zzvj2.size) {
            return false;
        }
        long[] lArray = zzvj2.zzcae;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzcae[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzuq.zzbd(this.zzcae[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaj(n);
        return this.zzcae[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzbe(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzua();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
        if (this.size < this.zzcae.length) {
            System.arraycopy(this.zzcae, n, this.zzcae, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzcae, 0, lArray, 0, n);
            System.arraycopy(this.zzcae, n, lArray, n + 1, this.size - n);
            this.zzcae = lArray;
        }
        this.zzcae[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzua();
        zzuq.checkNotNull(collection);
        if (!(collection instanceof zzvj)) {
            return super.addAll(collection);
        }
        zzvj zzvj2 = (zzvj)collection;
        if (zzvj2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzvj2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzvj2.size;
        if (n > this.zzcae.length) {
            this.zzcae = Arrays.copyOf(this.zzcae, n);
        }
        System.arraycopy(zzvj2.zzcae, 0, this.zzcae, this.size, zzvj2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzua();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzcae[i])) continue;
            System.arraycopy(this.zzcae, i + 1, this.zzcae, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
    }

    private final String zzak(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzvj zzvj2 = this;
        zzvj2.zzua();
        zzvj2.zzaj(n);
        long l3 = zzvj2.zzcae[n];
        zzvj2.zzcae[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzvj zzvj2 = this;
        zzvj2.zzua();
        zzvj2.zzaj(n);
        long l = zzvj2.zzcae[n];
        if (n < zzvj2.size - 1) {
            System.arraycopy(zzvj2.zzcae, n + 1, zzvj2.zzcae, n, zzvj2.size - n - 1);
        }
        --zzvj2.size;
        ++zzvj2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzuu zzal(int n) {
        int n2 = n;
        zzvj zzvj2 = this;
        if (n2 < zzvj2.size) {
            throw new IllegalArgumentException();
        }
        return new zzvj(Arrays.copyOf(zzvj2.zzcae, n2), zzvj2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzcad.zzsw();
    }
}

