/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzta;
import com.google.android.gms.internal.measurement.zzuq;
import com.google.android.gms.internal.measurement.zzuu;
import com.google.android.gms.internal.measurement.zzwg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zztc
extends zzta<Boolean>
implements zzuu<Boolean>,
zzwg,
RandomAccess {
    private static final zztc zzbtq = new zztc();
    private boolean[] zzbtr;
    private int size;

    zztc() {
        this(new boolean[10], 0);
    }

    private zztc(boolean[] blArray, int n) {
        this.zzbtr = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzua();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzbtr, n2, this.zzbtr, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zztc)) {
            return super.equals(object);
        }
        zztc zztc2 = (zztc)object;
        if (this.size != zztc2.size) {
            return false;
        }
        boolean[] blArray = zztc2.zzbtr;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzbtr[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzuq.zzu(this.zzbtr[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzua();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
        if (this.size < this.zzbtr.length) {
            System.arraycopy(this.zzbtr, n, this.zzbtr, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzbtr, 0, blArray, 0, n);
            System.arraycopy(this.zzbtr, n, blArray, n + 1, this.size - n);
            this.zzbtr = blArray;
        }
        this.zzbtr[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzua();
        zzuq.checkNotNull(collection);
        if (!(collection instanceof zztc)) {
            return super.addAll(collection);
        }
        zztc zztc2 = (zztc)collection;
        if (zztc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zztc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zztc2.size;
        if (n > this.zzbtr.length) {
            this.zzbtr = Arrays.copyOf(this.zzbtr, n);
        }
        System.arraycopy(zztc2.zzbtr, 0, this.zzbtr, this.size, zztc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzua();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzbtr[i])) continue;
            System.arraycopy(this.zzbtr, i + 1, this.zzbtr, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzak(n));
        }
    }

    private final String zzak(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zztc zztc2 = this;
        zztc2.zzua();
        zztc2.zzaj(n);
        boolean bl3 = zztc2.zzbtr[n];
        zztc2.zzbtr[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zztc zztc2 = this;
        zztc2.zzua();
        zztc2.zzaj(n);
        boolean bl = zztc2.zzbtr[n];
        if (n < zztc2.size - 1) {
            System.arraycopy(zztc2.zzbtr, n + 1, zztc2.zzbtr, n, zztc2.size - n - 1);
        }
        --zztc2.size;
        ++zztc2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzuu zzal(int n) {
        int n2 = n;
        zztc zztc2 = this;
        if (n2 < zztc2.size) {
            throw new IllegalArgumentException();
        }
        return new zztc(Arrays.copyOf(zztc2.zzbtr, n2), zztc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zztc zztc2 = this;
        zztc2.zzaj(n);
        return zztc2.zzbtr[n];
    }

    static {
        zzbtq.zzsw();
    }
}

