/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzku;
import com.google.android.gms.internal.measurement.zzkw;
import com.google.android.gms.internal.measurement.zzmi;
import com.google.android.gms.internal.measurement.zznt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzlo
extends zzku
implements RandomAccess,
zzmi,
zznt {
    private static final double[] zza = new double[0];
    private double[] zzb;
    private int zzc;

    zzlo() {
        this(zza, 0, true);
    }

    private zzlo(double[] dArray, int n, boolean bl) {
        super(bl);
        this.zzb = dArray;
        this.zzc = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcF();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzb, n2, this.zzb, n, this.zzc - n2);
        this.zzc -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzlo)) {
            return super.equals(object);
        }
        object = (zzlo)object;
        if (this.zzc != ((zzlo)object).zzc) {
            return false;
        }
        double[] dArray = ((zzlo)object).zzb;
        for (int i = 0; i < this.zzc; ++i) {
            if (Double.doubleToLongBits(this.zzb[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.zzc; ++i) {
            long l = Double.doubleToLongBits(this.zzb[i]);
            n *= 31;
            long l2 = l ^ l >>> 32;
            n += (int)l2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final zzmi zzd(int n) {
        double[] dArray;
        if (n < this.zzc) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            dArray = zza;
            return new zzlo(dArray, this.zzc, true);
        }
        dArray = Arrays.copyOf(this.zzb, n);
        return new zzlo(dArray, this.zzc, true);
    }

    public final double zze(int n) {
        this.zzj(n);
        return this.zzb[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Double)) {
            return -1;
        }
        double d = (Double)object;
        int n = this.zzc;
        for (int i = 0; i < n; ++i) {
            if (this.zzb[i] != d) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.zzc;
    }

    public final void zzf(double d) {
        this.zzcF();
        int n = this.zzb.length;
        if (this.zzc == n) {
            double[] dArray = new double[zzlo.zzi(n)];
            System.arraycopy(this.zzb, 0, dArray, 0, this.zzc);
            this.zzb = dArray;
        }
        this.zzb[this.zzc++] = d;
    }

    @Override
    public final boolean addAll(Collection collection) {
        int n;
        this.zzcF();
        if (collection != null) {
            if (!(collection instanceof zzlo)) {
                return super.addAll(collection);
            }
            collection = (zzlo)collection;
            n = ((zzlo)collection).zzc;
            if (n == 0) {
                return false;
            }
            int n2 = this.zzc;
            if (Integer.MAX_VALUE - n2 < n) {
                throw new OutOfMemoryError();
            }
            double[] dArray = this.zzb;
            if ((n = n2 + n) > dArray.length) {
                this.zzb = Arrays.copyOf(dArray, n);
            }
        } else {
            throw null;
        }
        System.arraycopy(((zzlo)collection).zzb, 0, this.zzb, this.zzc, ((zzlo)collection).zzc);
        this.zzc = n;
        ++this.modCount;
        return true;
    }

    final void zzh(int n) {
        int n2 = this.zzb.length;
        if (n <= n2) {
            return;
        }
        if (n2 != 0) {
            while (n2 < n) {
                n2 = zzlo.zzi(n2);
            }
            this.zzb = Arrays.copyOf(this.zzb, n2);
            return;
        }
        this.zzb = new double[Math.max(n, 10)];
    }

    private static int zzi(int n) {
        return Math.max(n * 3 / 2 + 1, 10);
    }

    private final void zzj(int n) {
        if (n < 0 || n >= this.zzc) {
            throw new IndexOutOfBoundsException(this.zzk(n));
        }
    }

    private final String zzk(int n) {
        String string = "Index:";
        String string2 = ", Size:";
        return zzkw.zza(this.zzc, n, (byte)13, string, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final /* synthetic */ void add(int n, Object object) {
        int n2;
        double d = (Double)object;
        this.zzcF();
        if (n < 0 || n > (n2 = this.zzc)) {
            throw new IndexOutOfBoundsException(this.zzk(n));
        }
        int n3 = n + 1;
        double[] dArray = this.zzb;
        int n4 = dArray.length;
        if (n2 < n4) {
            System.arraycopy(dArray, n, dArray, n3, n2 - n);
        } else {
            double[] dArray2 = new double[zzlo.zzi(n4)];
            System.arraycopy(this.zzb, 0, dArray2, 0, n);
            System.arraycopy(this.zzb, n, dArray2, n3, this.zzc - n);
            this.zzb = dArray2;
        }
        this.zzb[n] = d;
        ++this.zzc;
        ++this.modCount;
    }

    public final /* synthetic */ Object get(int n) {
        this.zzj(n);
        return this.zzb[n];
    }

    static {
        new zzlo(zza, 0, false);
    }
}

