/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbk;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzgd;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzbf
extends zzcu {
    @VisibleForTesting
    static final Pair<String, Long> zzky = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzkz;
    public zzbj zzla;
    public final zzbi zzlb = new zzbi(this, "last_upload", 0L);
    public final zzbi zzlc = new zzbi(this, "last_upload_attempt", 0L);
    public final zzbi zzld = new zzbi(this, "backoff", 0L);
    public final zzbi zzle = new zzbi(this, "last_delete_stale", 0L);
    public final zzbi zzlf;
    public final zzbi zzlg;
    public final zzbi zzlh;
    public final zzbk zzli;
    private String zzlj;
    private boolean zzlk;
    private long zzll;
    public final zzbi zzlm = new zzbi(this, "time_before_start", 10000L);
    public final zzbi zzln = new zzbi(this, "session_timeout", 1800000L);
    public final zzbh zzlo = new zzbh(this, "start_new_session", true);
    public final zzbk zzlp;
    public final zzbh zzlq;
    public final zzbh zzlr;
    public final zzbi zzls = new zzbi(this, "last_pause_time", 0L);
    public final zzbi zzlt = new zzbi(this, "time_active", 0L);
    public boolean zzlu;
    public zzbh zzlv;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzar(String string) {
        this.zzq();
        long l = this.zzz().elapsedRealtime();
        if (this.zzlj != null && l < this.zzll) {
            return new Pair((Object)this.zzlj, (Object)this.zzlk);
        }
        String string2 = string;
        this.zzll = l + this.zzaf().zza(string2, zzal.zzge);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzlj = info.getId();
                this.zzlk = info.isLimitAdTrackingEnabled();
            }
            if (this.zzlj == null) {
                this.zzlj = "";
            }
        }
        catch (Exception exception) {
            this.zzad().zzdh().zza("Unable to get advertising id", exception);
            this.zzlj = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzlj, (Object)this.zzlk);
    }

    @WorkerThread
    final String zzas(String string) {
        this.zzq();
        String string2 = (String)this.zzar((String)string).first;
        MessageDigest messageDigest = zzgd.getMessageDigest();
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzbf(zzby zzby2) {
        super(zzby2);
        this.zzlp = new zzbk(this, "non_personalized_ads", null);
        this.zzlq = new zzbh(this, "use_dynamite_api", false);
        this.zzlr = new zzbh(this, "allow_remote_dynamite", false);
        this.zzlf = new zzbi(this, "midnight_offset", 0L);
        this.zzlg = new zzbi(this, "first_open_time", 0L);
        this.zzlh = new zzbi(this, "app_install_time", 0L);
        this.zzli = new zzbk(this, "app_instance_id", null);
        this.zzlv = new zzbh(this, "app_backgrounded", false);
    }

    @Override
    protected final boolean zzak() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzal() {
        this.zzkz = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzlu = this.zzkz.getBoolean("has_been_opened", false);
        if (!this.zzlu) {
            SharedPreferences.Editor editor = this.zzkz.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzla = new zzbj(this, "health_monitor", Math.max(0L, (Long)zzal.zzgf.get(null)), null);
    }

    @WorkerThread
    private final SharedPreferences zzdr() {
        this.zzq();
        this.zzah();
        return this.zzkz;
    }

    @WorkerThread
    final void zzat(String string) {
        this.zzq();
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzds() {
        this.zzq();
        return this.zzdr().getString("gmp_app_id", null);
    }

    @WorkerThread
    final void zzau(String string) {
        this.zzq();
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.putString("admob_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzdt() {
        this.zzq();
        return this.zzdr().getString("admob_app_id", null);
    }

    @WorkerThread
    final Boolean zzdu() {
        this.zzq();
        if (!this.zzdr().contains("use_service")) {
            return null;
        }
        return this.zzdr().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzq();
        this.zzad().zzdi().zza("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzdv() {
        this.zzq();
        this.zzad().zzdi().zzaq("Clearing collection preferences.");
        if (this.zzaf().zza(zzal.zzio)) {
            Boolean bl = this.zzdw();
            SharedPreferences.Editor editor = this.zzdr().edit();
            editor.clear();
            editor.apply();
            if (bl != null) {
                this.setMeasurementEnabled(bl);
            }
            return;
        }
        boolean bl = this.zzdr().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zze(true);
        }
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzq();
        this.zzad().zzdi().zza("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zze(boolean bl) {
        this.zzq();
        return this.zzdr().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    final Boolean zzdw() {
        this.zzq();
        if (this.zzdr().contains("measurement_enabled")) {
            return this.zzdr().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    @WorkerThread
    protected final String zzdx() {
        this.zzq();
        String string = this.zzdr().getString("previous_os_version", null);
        this.zzy().zzah();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzdr().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    @WorkerThread
    final void zzf(boolean bl) {
        this.zzq();
        this.zzad().zzdi().zza("Updating deferred analytics collection", bl);
        SharedPreferences.Editor editor = this.zzdr().edit();
        editor.putBoolean("deferred_analytics_collection", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzdy() {
        this.zzq();
        return this.zzdr().getBoolean("deferred_analytics_collection", false);
    }

    @WorkerThread
    final boolean zzdz() {
        return this.zzkz.contains("deferred_analytics_collection");
    }

    final boolean zzx(long l) {
        return l - this.zzln.get() > this.zzls.get();
    }

    static /* synthetic */ SharedPreferences zza(zzbf zzbf2) {
        return zzbf2.zzdr();
    }
}

