/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.PackageManagerWrapper;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zze;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import java.util.List;

public final class zzbl {
    final zzby zzl;

    zzbl(zzby zzby2) {
        this.zzl = zzby2;
    }

    @WorkerThread
    protected final void zzaw(String string) {
        if (string == null || string.isEmpty()) {
            this.zzl.zzad().zzdg().zzaq("Install Referrer Reporter was called with invalid app package name");
            return;
        }
        ((zzct)this.zzl.zzac()).zzq();
        if (!this.zzee()) {
            this.zzl.zzad().zzdg().zzaq("Install Referrer Reporter is not available");
            return;
        }
        this.zzl.zzad().zzdg().zzaq("Install Referrer Reporter is initializing");
        zzbm zzbm2 = new zzbm(this, string);
        zzbl zzbl2 = this;
        ((zzct)zzbl2.zzl.zzac()).zzq();
        Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
        intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
        PackageManager packageManager = zzbl2.zzl.getContext().getPackageManager();
        if (packageManager == null) {
            zzbl2.zzl.zzad().zzdd().zzaq("Failed to obtain Package Manager to verify binding conditions");
            return;
        }
        List list = packageManager.queryIntentServices(intent, 0);
        if (list != null && !list.isEmpty()) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(0);
            if (resolveInfo.serviceInfo != null) {
                String string2 = resolveInfo.serviceInfo.packageName;
                if (resolveInfo.serviceInfo.name != null && "com.android.vending".equals(string2) && zzbl2.zzee()) {
                    Intent intent2 = new Intent(intent);
                    try {
                        boolean bl = ConnectionTracker.getInstance().bindService(zzbl2.zzl.getContext(), intent2, (ServiceConnection)zzbm2, 1);
                        zzbl2.zzl.zzad().zzdg().zza("Install Referrer Service is", bl ? "available" : "not available");
                        return;
                    }
                    catch (Exception exception) {
                        zzbl2.zzl.zzad().zzda().zza("Exception occurred while binding to Install Referrer Service", exception.getMessage());
                        return;
                    }
                }
                zzbl2.zzl.zzad().zzdg().zzaq("Play Store missing or incompatible. Version 8.3.73 or later required");
            }
            return;
        }
        zzbl2.zzl.zzad().zzdg().zzaq("Play Service for fetching Install Referrer is unavailable on device");
    }

    @VisibleForTesting
    private final boolean zzee() {
        try {
            PackageManagerWrapper packageManagerWrapper = Wrappers.packageManager((Context)this.zzl.getContext());
            if (packageManagerWrapper == null) {
                this.zzl.zzad().zzdg().zzaq("Failed to retrieve Package Manager to check Play Store compatibility");
                return false;
            }
            return packageManagerWrapper.getPackageInfo((String)"com.android.vending", (int)128).versionCode >= 80837300;
        }
        catch (Exception exception) {
            this.zzl.zzad().zzdg().zza("Failed to retrieve Play Store version", exception);
            return false;
        }
    }

    @WorkerThread
    @Nullable
    @VisibleForTesting
    final Bundle zza(String string, zze zze2) {
        Bundle bundle;
        ((zzct)this.zzl.zzac()).zzq();
        if (zze2 == null) {
            this.zzl.zzad().zzdd().zzaq("Attempting to use Install Referrer Service while it is not initialized");
            return null;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putString("package_name", string);
        try {
            bundle = zze2.zza(bundle2);
            if (bundle == null) {
                this.zzl.zzad().zzda().zzaq("Install Referrer Service returned a null response");
                return null;
            }
        }
        catch (Exception exception) {
            this.zzl.zzad().zzda().zza("Exception occurred while retrieving the Install Referrer", exception.getMessage());
            return null;
        }
        return bundle;
    }
}

