/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzbp;
import com.google.android.gms.measurement.internal.zzbq;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzq;

public final class zzbo {
    private final zzbr zzmj;

    public zzbo(zzbr zzbr2) {
        Preconditions.checkNotNull((Object)zzbr2);
        this.zzmj = zzbr2;
    }

    public static boolean zzl(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void onReceive(Context context, Intent intent) {
        zzby zzby2 = zzby.zza(context, null);
        zzau zzau2 = zzby2.zzad();
        if (intent == null) {
            zzau2.zzdd().zzaq("Receiver called with null intent");
            return;
        }
        zzq zzq2 = zzby2.zzag();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzau2.zzdi().zza("Device receiver got", string);
        } else {
            zzau2.zzdi().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzau2.zzdi().zzaq("Starting wakeful intent.");
            this.zzmj.doStartService(context, intent2);
            return;
        }
        if (!bl && "com.android.vending.INSTALL_REFERRER".equals(string)) {
            try {
                zzby2.zzac().zza(new zzbp(this, zzby2, zzau2));
            }
            catch (Exception exception) {
                zzau2.zzdd().zza("Install Referrer Reporter encountered a problem", exception);
            }
            BroadcastReceiver.PendingResult pendingResult = this.zzmj.doGoAsync();
            String string2 = intent.getStringExtra("referrer");
            if (string2 == null) {
                zzau2.zzdi().zzaq("Install referrer extras are null");
                if (pendingResult != null) {
                    pendingResult.finish();
                }
                return;
            }
            zzau2.zzdg().zza("Install referrer extras are", string2);
            if (!string2.contains("?")) {
                String string3 = String.valueOf(string2);
                string2 = string3.length() != 0 ? "?".concat(string3) : new String("?");
            }
            Uri uri = Uri.parse((String)string2);
            Bundle bundle = zzby2.zzab().zza(uri);
            if (bundle == null) {
                zzau2.zzdi().zzaq("No campaign defined in install referrer broadcast");
                if (pendingResult != null) {
                    pendingResult.finish();
                    return;
                }
            } else {
                long l = intent.getLongExtra("referrer_timestamp_seconds", 0L) * 1000L;
                if (l == 0L) {
                    zzau2.zzdd().zzaq("Install referrer is missing timestamp");
                }
                zzby2.zzac().zza(new zzbq(this, zzby2, l, bundle, context, zzau2, pendingResult));
            }
        }
    }
}

