/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbv;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzbx;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcu;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbt
extends zzcu {
    private zzbx zzmx;
    private zzbx zzmy;
    private final PriorityBlockingQueue<zzbw<?>> zzmz;
    private final BlockingQueue<zzbw<?>> zzna;
    private final Thread.UncaughtExceptionHandler zznb;
    private final Thread.UncaughtExceptionHandler zznc;
    private final Object zznd = new Object();
    private final Semaphore zzne = new Semaphore(2);
    private volatile boolean zznf;
    private static final AtomicLong zzng = new AtomicLong(Long.MIN_VALUE);

    zzbt(zzby zzby2) {
        super(zzby2);
        this.zzmz = new PriorityBlockingQueue();
        this.zzna = new LinkedBlockingQueue();
        this.zznb = new zzbv(this, "Thread death: Uncaught exception on worker thread");
        this.zznc = new zzbv(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    @Override
    public final void zzq() {
        if (Thread.currentThread() != this.zzmx) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzp() {
        if (Thread.currentThread() != this.zzmy) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzef() {
        return Thread.currentThread() == this.zzmx;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzah();
        Preconditions.checkNotNull(callable);
        zzbw zzbw2 = new zzbw(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzmx) {
            if (!this.zzmz.isEmpty()) {
                ((zzct)this).zzad().zzdd().zzaq("Callable skipped the worker queue.");
            }
            zzbw2.run();
        } else {
            this.zza(zzbw2);
        }
        return zzbw2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzah();
        Preconditions.checkNotNull(callable);
        zzbw zzbw2 = new zzbw(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzmx) {
            zzbw2.run();
        } else {
            this.zza(zzbw2);
        }
        return zzbw2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzah();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzbw(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzct)this).zzac().zza(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzct)this).zzad().zzdd().zzaq(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzct)this).zzad().zzdd().zzaq(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbw<?> zzbw2) {
        Object object = this.zznd;
        synchronized (object) {
            this.zzmz.add(zzbw2);
            if (this.zzmx == null) {
                this.zzmx = new zzbx(this, "Measurement Worker", this.zzmz);
                this.zzmx.setUncaughtExceptionHandler(this.zznb);
                this.zzmx.start();
            } else {
                this.zzmx.zzeh();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzah();
        Preconditions.checkNotNull((Object)runnable);
        zzbw zzbw2 = new zzbw(this, runnable, false, "Task exception on network thread");
        zzbt zzbt2 = this;
        Object object = zzbt2.zznd;
        synchronized (object) {
            zzbt2.zzna.add(zzbw2);
            if (zzbt2.zzmy == null) {
                zzbt2.zzmy = new zzbx(zzbt2, "Measurement Network", zzbt2.zzna);
                zzbt2.zzmy.setUncaughtExceptionHandler(zzbt2.zznc);
                zzbt2.zzmy.start();
            } else {
                zzbt2.zzmy.zzeh();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzbt zzbt2) {
        return zzbt2.zzne;
    }

    static /* synthetic */ boolean zzb(zzbt zzbt2) {
        return zzbt2.zznf;
    }

    static /* synthetic */ Object zzc(zzbt zzbt2) {
        return zzbt2.zznd;
    }

    static /* synthetic */ zzbx zzd(zzbt zzbt2) {
        return zzbt2.zzmx;
    }

    static /* synthetic */ zzbx zza(zzbt zzbt2, zzbx zzbx2) {
        zzbt2.zzmx = null;
        return null;
    }

    static /* synthetic */ zzbx zze(zzbt zzbt2) {
        return zzbt2.zzmy;
    }

    static /* synthetic */ zzbx zzb(zzbt zzbt2, zzbx zzbx2) {
        zzbt2.zzmy = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzeg() {
        return zzng;
    }
}

