/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzec;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzgd;
import java.util.Map;

public final class zzed
extends zzf {
    @VisibleForTesting
    protected zzec zzpy;
    private volatile zzec zzpz;
    private zzec zzqa;
    private final Map<Activity, zzec> zzqb = new ArrayMap();
    private zzec zzqc;
    private String zzqd;

    public zzed(zzby zzby2) {
        super(zzby2);
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    @WorkerThread
    public final zzec zzfc() {
        this.zzah();
        ((zzct)this).zzq();
        return this.zzpy;
    }

    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzpz == null) {
            ((zzct)this).zzad().zzdd().zzaq("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzqb.get(activity) == null) {
            ((zzct)this).zzad().zzdd().zzaq("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzed.zzbj(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzpz.zzpv.equals(string2);
        boolean bl2 = zzgd.zzs(this.zzpz.zzpu, string);
        if (bl && bl2) {
            ((zzct)this).zzad().zzdf().zzaq("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzct)this).zzad().zzdd().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzct)this).zzad().zzdd().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzct)this).zzad().zzdi().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzec zzec2 = new zzec(string, string2, ((zzct)this).zzab().zzgk());
        this.zzqb.put(activity, zzec2);
        this.zza(activity, zzec2, true);
    }

    public final zzec zzfd() {
        ((zzct)this).zzo();
        return this.zzpz;
    }

    @MainThread
    private final void zza(Activity activity, zzec zzec2, boolean bl) {
        zzec zzec3;
        zzec zzec4 = zzec3 = this.zzpz == null ? this.zzqa : this.zzpz;
        if (zzec2.zzpv == null) {
            zzec2 = new zzec(zzec2.zzpu, zzed.zzbj(activity.getClass().getCanonicalName()), zzec2.zzpw);
        }
        zzec zzec5 = zzec2;
        this.zzqa = this.zzpz;
        this.zzpz = zzec5;
        ((zzct)this).zzac().zza(new zzee(this, bl, zzec3, zzec5));
    }

    @WorkerThread
    private final void zza(@NonNull zzec zzec2, boolean bl) {
        ((zze)this).zzr().zzc(((zzct)this).zzz().elapsedRealtime());
        if (((zze)this).zzx().zza(zzec2.zzpx, bl)) {
            zzec2.zzpx = false;
        }
    }

    public static void zza(zzec zzec2, Bundle bundle, boolean bl) {
        if (bundle != null && zzec2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzec2.zzpu != null) {
                bundle.putString("_sn", zzec2.zzpu);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzec2.zzpv);
            bundle.putLong("_si", zzec2.zzpw);
            return;
        }
        if (bundle != null && zzec2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzec zzec2) {
        ((zzct)this).zzq();
        zzed zzed2 = this;
        synchronized (zzed2) {
            if (this.zzqd == null || this.zzqd.equals(string) || zzec2 != null) {
                this.zzqd = string;
                this.zzqc = zzec2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzbj(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzec zza(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzec zzec2 = this.zzqb.get(activity);
        if (zzec2 == null) {
            String string = zzed.zzbj(activity.getClass().getCanonicalName());
            zzec2 = new zzec(null, string, ((zzct)this).zzab().zzgk());
            this.zzqb.put(activity, zzec2);
        }
        return zzec2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzec zzec2 = new zzec(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzqb.put(activity, zzec2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzec zzec2 = this.zza(activity);
        this.zza(activity, zzec2, false);
        zza zza2 = ((zze)this).zzr();
        long l = ((zzct)zza2).zzz().elapsedRealtime();
        ((zzct)zza2).zzac().zza(new zzd(zza2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzec zzec2 = this.zza(activity);
        this.zzqa = this.zzpz;
        this.zzpz = null;
        ((zzct)this).zzac().zza(new zzef(this, zzec2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzec zzec2 = this.zzqb.get(activity);
        if (zzec2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzec2.zzpw);
        bundle2.putString("name", zzec2.zzpu);
        bundle2.putString("referrer_name", zzec2.zzpv);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzqb.remove(activity);
    }

    static /* synthetic */ void zza(zzed zzed2, zzec zzec2, boolean bl) {
        zzed2.zza(zzec2, bl);
    }
}

