/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzgu;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzeh
extends zzdj<Double>
implements zzff<Double>,
zzgu,
RandomAccess {
    private static final zzeh zzaeo = new zzeh(new double[0], 0);
    private double[] zzaep;
    private int size;

    zzeh() {
        this(new double[10], 0);
    }

    private zzeh(double[] dArray, int n) {
        this.zzaep = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzrz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzaep, n2, this.zzaep, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzeh)) {
            return super.equals(object);
        }
        zzeh zzeh2 = (zzeh)object;
        if (this.size != zzeh2.size) {
            return false;
        }
        double[] dArray = zzeh2.zzaep;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzaep[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzaep[i]);
            n = n * 31 + zzez.zzbx(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzf(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzrz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
        if (this.size < this.zzaep.length) {
            System.arraycopy(this.zzaep, n, this.zzaep, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzaep, 0, dArray, 0, n);
            System.arraycopy(this.zzaep, n, dArray, n + 1, this.size - n);
            this.zzaep = dArray;
        }
        this.zzaep[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzrz();
        zzez.checkNotNull(collection);
        if (!(collection instanceof zzeh)) {
            return super.addAll(collection);
        }
        zzeh zzeh2 = (zzeh)collection;
        if (zzeh2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzeh2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzeh2.size;
        if (n > this.zzaep.length) {
            this.zzaep = Arrays.copyOf(this.zzaep, n);
        }
        System.arraycopy(zzeh2.zzaep, 0, this.zzaep, this.size, zzeh2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzrz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzaep[i])) continue;
            System.arraycopy(this.zzaep, i + 1, this.zzaep, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzan(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
    }

    private final String zzao(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzeh zzeh2 = this;
        zzeh2.zzrz();
        zzeh2.zzan(n);
        double d3 = zzeh2.zzaep[n];
        zzeh2.zzaep[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzeh zzeh2 = this;
        zzeh2.zzrz();
        zzeh2.zzan(n);
        double d = zzeh2.zzaep[n];
        if (n < zzeh2.size - 1) {
            System.arraycopy(zzeh2.zzaep, n + 1, zzeh2.zzaep, n, zzeh2.size - n - 1);
        }
        --zzeh2.size;
        ++zzeh2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzff zzap(int n) {
        int n2 = n;
        zzeh zzeh2 = this;
        if (n2 < zzeh2.size) {
            throw new IllegalArgumentException();
        }
        return new zzeh(Arrays.copyOf(zzeh2.zzaep, n2), zzeh2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzeh zzeh2 = this;
        zzeh2.zzan(n);
        return zzeh2.zzaep[n];
    }

    static {
        zzaeo.zzry();
    }
}

