/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.zza;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
@ShowFirstParty
public class AppMeasurement {
    @ShowFirstParty
    @KeepForSdk
    public static final String CRASH_ORIGIN = "crash";
    @ShowFirstParty
    @KeepForSdk
    public static final String FCM_ORIGIN = "fcm";
    @ShowFirstParty
    @KeepForSdk
    public static final String FIAM_ORIGIN = "fiam";
    private static volatile AppMeasurement zzi;
    private final zzfj zzj;
    private final zzhi zzk;
    private final boolean zzl;

    @Deprecated
    @ShowFirstParty
    @Keep
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurement getInstance(Context context) {
        return AppMeasurement.zza(context, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    private static AppMeasurement zza(Context context, String string, String string2) {
        if (zzi != null) return zzi;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zzi != null) return zzi;
            zzhi zzhi2 = AppMeasurement.zzb(context, null);
            if (zzhi2 != null) {
                zzi = new AppMeasurement(zzhi2);
            } else {
                zzfj zzfj2 = zzfj.zza(context, null, null, null);
                zzi = new AppMeasurement(zzfj2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return zzi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AppMeasurement zza(Context context, Bundle bundle) {
        if (zzi != null) return zzi;
        Class<AppMeasurement> clazz = AppMeasurement.class;
        synchronized (AppMeasurement.class) {
            if (zzi != null) return zzi;
            zzhi zzhi2 = AppMeasurement.zzb(context, bundle);
            if (zzhi2 != null) {
                zzi = new AppMeasurement(zzhi2);
            } else {
                zzfj zzfj2 = zzfj.zza(context, null, null, bundle);
                zzi = new AppMeasurement(zzfj2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzi;
        }
    }

    private static zzhi zzb(Context context, Bundle bundle) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            return (zzhi)clazz.getDeclaredMethod("getScionFrontendApiImplementation", Context.class, Bundle.class).invoke(null, context, bundle);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        if (this.zzl) {
            this.zzk.setMeasurementEnabled(bl);
            return;
        }
        this.zzj.zzq().setMeasurementEnabled(bl);
    }

    public final void zza(boolean bl) {
        if (this.zzl) {
            this.zzk.setDataCollectionEnabled(bl);
            return;
        }
        this.zzj.zzq().zza(bl);
    }

    private AppMeasurement(zzfj zzfj2) {
        Preconditions.checkNotNull((Object)zzfj2);
        this.zzj = zzfj2;
        this.zzk = null;
        this.zzl = false;
    }

    private AppMeasurement(zzhi zzhi2) {
        Preconditions.checkNotNull((Object)zzhi2);
        this.zzk = zzhi2;
        this.zzj = null;
        this.zzl = true;
    }

    @ShowFirstParty
    @Keep
    public void logEventInternal(String string, String string2, Bundle bundle) {
        if (this.zzl) {
            this.zzk.logEventInternal(string, string2, bundle);
            return;
        }
        this.zzj.zzq().logEvent(string, string2, bundle);
    }

    @ShowFirstParty
    @KeepForSdk
    public void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        if (this.zzl) {
            this.zzk.logEventInternalNoInterceptor(string, string2, bundle, l);
            return;
        }
        Bundle bundle2 = bundle;
        String string3 = string2;
        String string4 = string;
        this.zzj.zzq().logEvent(string4, string3, bundle2, true, false, l);
    }

    @ShowFirstParty
    @KeepForSdk
    public void setUserPropertyInternal(String string, String string2, Object object) {
        Preconditions.checkNotEmpty((String)string);
        if (this.zzl) {
            this.zzk.setUserPropertyInternal(string, string2, object);
            return;
        }
        this.zzj.zzq().zzb(string, string2, object, true);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public Map<String, Object> getUserProperties(boolean bl) {
        if (this.zzl) {
            return this.zzk.getUserProperties(null, null, bl);
        }
        List<zzjn> list = this.zzj.zzq().zzh(bl);
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzjn zzjn2 : list) {
            arrayMap.put(zzjn2.name, zzjn2.getValue());
        }
        return arrayMap;
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        if (this.zzl) {
            this.zzk.zza(eventInterceptor);
            return;
        }
        this.zzj.zzq().zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzl) {
            this.zzk.zza(onEventListener);
            return;
        }
        this.zzj.zzq().zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        if (this.zzl) {
            this.zzk.zzb(onEventListener);
            return;
        }
        this.zzj.zzq().zzb(onEventListener);
    }

    @Nullable
    @Keep
    public String getCurrentScreenName() {
        if (this.zzl) {
            return this.zzk.getCurrentScreenName();
        }
        return this.zzj.zzq().getCurrentScreenName();
    }

    @Nullable
    @Keep
    public String getCurrentScreenClass() {
        if (this.zzl) {
            return this.zzk.getCurrentScreenClass();
        }
        return this.zzj.zzq().getCurrentScreenClass();
    }

    @Nullable
    @Keep
    public String getAppInstanceId() {
        if (this.zzl) {
            return this.zzk.zzi();
        }
        return this.zzj.zzq().zzi();
    }

    @Nullable
    @Keep
    public String getGmpAppId() {
        if (this.zzl) {
            return this.zzk.getGmpAppId();
        }
        return this.zzj.zzq().getGmpAppId();
    }

    @Keep
    public long generateEventId() {
        if (this.zzl) {
            return this.zzk.generateEventId();
        }
        return this.zzj.zzz().zzjv();
    }

    @Keep
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzl) {
            this.zzk.beginAdUnitExposure(string);
            return;
        }
        this.zzj.zzp().beginAdUnitExposure(string, this.zzj.zzx().elapsedRealtime());
    }

    @Keep
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        if (this.zzl) {
            this.zzk.endAdUnitExposure(string);
            return;
        }
        this.zzj.zzp().endAdUnitExposure(string, this.zzj.zzx().elapsedRealtime());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void setConditionalUserProperty(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzl) {
            this.zzk.setConditionalUserProperty(conditionalUserProperty.zzd());
            return;
        }
        this.zzj.zzq().setConditionalUserProperty(conditionalUserProperty.zzd());
    }

    @Keep
    @VisibleForTesting
    protected void setConditionalUserPropertyAs(@NonNull ConditionalUserProperty conditionalUserProperty) {
        Preconditions.checkNotNull((Object)conditionalUserProperty);
        if (this.zzl) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzj.zzq().zzd(conditionalUserProperty.zzd());
    }

    @Keep
    @ShowFirstParty
    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        if (this.zzl) {
            this.zzk.clearConditionalUserProperty(string, string2, bundle);
            return;
        }
        this.zzj.zzq().clearConditionalUserProperty(string, string2, bundle);
    }

    @Keep
    @VisibleForTesting
    protected void clearConditionalUserPropertyAs(@NonNull @Size(min=1L) String string, @NonNull @Size(min=1L, max=24L) String string2, @Nullable String string3, @Nullable Bundle bundle) {
        if (this.zzl) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        this.zzj.zzq().clearConditionalUserPropertyAs(string, string2, string3, bundle);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        if (this.zzl) {
            return this.zzk.getUserProperties(string, string2, bl);
        }
        return this.zzj.zzq().getUserProperties(string, string2, bl);
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected Map<String, Object> getUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3, boolean bl) {
        if (this.zzl) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        return this.zzj.zzq().getUserPropertiesAs(string, string2, string3, bl);
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public List<ConditionalUserProperty> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        List<Bundle> list = this.zzl ? this.zzk.getConditionalUserProperties(string, string2) : this.zzj.zzq().zzn(string, string2);
        ArrayList<ConditionalUserProperty> arrayList = new ArrayList<ConditionalUserProperty>(list == null ? 0 : list.size());
        for (Bundle bundle : list) {
            arrayList.add(new ConditionalUserProperty(bundle, null));
        }
        return arrayList;
    }

    @WorkerThread
    @Keep
    @VisibleForTesting
    protected List<ConditionalUserProperty> getConditionalUserPropertiesAs(@NonNull @Size(min=1L) String string, @Nullable String string2, @Nullable @Size(min=1L, max=23L) String string3) {
        if (this.zzl) {
            throw new IllegalStateException("Unexpected call on client side");
        }
        ArrayList<Bundle> arrayList = this.zzj.zzq().zzd(string, string2, string3);
        ArrayList<ConditionalUserProperty> arrayList2 = new ArrayList<ConditionalUserProperty>(arrayList == null ? 0 : arrayList.size());
        ArrayList<Bundle> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Bundle bundle = arrayList3.get(i);
            Bundle bundle2 = bundle;
            arrayList2.add(new ConditionalUserProperty(bundle2, null));
        }
        return arrayList2;
    }

    @WorkerThread
    @Keep
    @ShowFirstParty
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        if (this.zzl) {
            return this.zzk.getMaxUserProperties(string);
        }
        this.zzj.zzq();
        String string2 = string;
        Preconditions.checkNotEmpty((String)string2);
        return 25;
    }

    @KeepForSdk
    public Boolean getBoolean() {
        if (this.zzl) {
            return (Boolean)this.zzk.zzb(4);
        }
        return this.zzj.zzq().zzig();
    }

    @KeepForSdk
    public String getString() {
        if (this.zzl) {
            return (String)this.zzk.zzb(0);
        }
        return this.zzj.zzq().zzih();
    }

    @KeepForSdk
    public Long getLong() {
        if (this.zzl) {
            return (Long)this.zzk.zzb(1);
        }
        return this.zzj.zzq().zzii();
    }

    @KeepForSdk
    public Integer getInteger() {
        if (this.zzl) {
            return (Integer)this.zzk.zzb(3);
        }
        return this.zzj.zzq().zzij();
    }

    @KeepForSdk
    public Double getDouble() {
        if (this.zzl) {
            return (Double)this.zzk.zzb(2);
        }
        return this.zzj.zzq().zzik();
    }

    @ShowFirstParty
    @KeepForSdk
    public static class ConditionalUserProperty {
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mAppId;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mOrigin;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public Object mValue;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public String mTriggerEventName;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggerTimeout;
        @Keep
        public String mTimedOutEventName;
        @Keep
        public Bundle mTimedOutEventParams;
        @Keep
        public String mTriggeredEventName;
        @Keep
        public Bundle mTriggeredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTimeToLive;
        @Keep
        public String mExpiredEventName;
        @Keep
        public Bundle mExpiredEventParams;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mCreationTimestamp;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public boolean mActive;
        @Keep
        @ShowFirstParty
        @KeepForSdk
        public long mTriggeredTimestamp;

        @KeepForSdk
        public ConditionalUserProperty() {
        }

        @KeepForSdk
        public ConditionalUserProperty(ConditionalUserProperty conditionalUserProperty) {
            Preconditions.checkNotNull((Object)conditionalUserProperty);
            this.mAppId = conditionalUserProperty.mAppId;
            this.mOrigin = conditionalUserProperty.mOrigin;
            this.mCreationTimestamp = conditionalUserProperty.mCreationTimestamp;
            this.mName = conditionalUserProperty.mName;
            if (conditionalUserProperty.mValue != null) {
                this.mValue = zzho.zza((Object)conditionalUserProperty.mValue);
                if (this.mValue == null) {
                    this.mValue = conditionalUserProperty.mValue;
                }
            }
            this.mActive = conditionalUserProperty.mActive;
            this.mTriggerEventName = conditionalUserProperty.mTriggerEventName;
            this.mTriggerTimeout = conditionalUserProperty.mTriggerTimeout;
            this.mTimedOutEventName = conditionalUserProperty.mTimedOutEventName;
            if (conditionalUserProperty.mTimedOutEventParams != null) {
                this.mTimedOutEventParams = new Bundle(conditionalUserProperty.mTimedOutEventParams);
            }
            this.mTriggeredEventName = conditionalUserProperty.mTriggeredEventName;
            if (conditionalUserProperty.mTriggeredEventParams != null) {
                this.mTriggeredEventParams = new Bundle(conditionalUserProperty.mTriggeredEventParams);
            }
            this.mTriggeredTimestamp = conditionalUserProperty.mTriggeredTimestamp;
            this.mTimeToLive = conditionalUserProperty.mTimeToLive;
            this.mExpiredEventName = conditionalUserProperty.mExpiredEventName;
            if (conditionalUserProperty.mExpiredEventParams != null) {
                this.mExpiredEventParams = new Bundle(conditionalUserProperty.mExpiredEventParams);
            }
        }

        private ConditionalUserProperty(@NonNull Bundle bundle) {
            Preconditions.checkNotNull((Object)bundle);
            this.mAppId = (String)zzgg.zza((Bundle)bundle, (String)"app_id", String.class, null);
            this.mOrigin = (String)zzgg.zza((Bundle)bundle, (String)"origin", String.class, null);
            this.mName = (String)zzgg.zza((Bundle)bundle, (String)"name", String.class, null);
            this.mValue = zzgg.zza((Bundle)bundle, (String)"value", Object.class, null);
            this.mTriggerEventName = (String)zzgg.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
            this.mTriggerTimeout = (Long)zzgg.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)0L);
            this.mTimedOutEventName = (String)zzgg.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
            this.mTimedOutEventParams = (Bundle)zzgg.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
            this.mTriggeredEventName = (String)zzgg.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
            this.mTriggeredEventParams = (Bundle)zzgg.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
            this.mTimeToLive = (Long)zzgg.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)0L);
            this.mExpiredEventName = (String)zzgg.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
            this.mExpiredEventParams = (Bundle)zzgg.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        }

        private final Bundle zzd() {
            Bundle bundle = new Bundle();
            if (this.mAppId != null) {
                bundle.putString("app_id", this.mAppId);
            }
            if (this.mOrigin != null) {
                bundle.putString("origin", this.mOrigin);
            }
            if (this.mName != null) {
                bundle.putString("name", this.mName);
            }
            if (this.mValue != null) {
                zzgg.zza((Bundle)bundle, (Object)this.mValue);
            }
            if (this.mTriggerEventName != null) {
                bundle.putString("trigger_event_name", this.mTriggerEventName);
            }
            bundle.putLong("trigger_timeout", this.mTriggerTimeout);
            if (this.mTimedOutEventName != null) {
                bundle.putString("timed_out_event_name", this.mTimedOutEventName);
            }
            if (this.mTimedOutEventParams != null) {
                bundle.putBundle("timed_out_event_params", this.mTimedOutEventParams);
            }
            if (this.mTriggeredEventName != null) {
                bundle.putString("triggered_event_name", this.mTriggeredEventName);
            }
            if (this.mTriggeredEventParams != null) {
                bundle.putBundle("triggered_event_params", this.mTriggeredEventParams);
            }
            bundle.putLong("time_to_live", this.mTimeToLive);
            if (this.mExpiredEventName != null) {
                bundle.putString("expired_event_name", this.mExpiredEventName);
            }
            if (this.mExpiredEventParams != null) {
                bundle.putBundle("expired_event_params", this.mExpiredEventParams);
            }
            bundle.putLong("creation_timestamp", this.mCreationTimestamp);
            bundle.putBoolean("active", this.mActive);
            bundle.putLong("triggered_timestamp", this.mTriggeredTimestamp);
            return bundle;
        }

        /* synthetic */ ConditionalUserProperty(Bundle bundle, zza zza2) {
            this(bundle);
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgn {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgk {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class UserProperty
    extends zzgl {
        @ShowFirstParty
        @KeepForSdk
        public static final String FIREBASE_LAST_NOTIFICATION = "_ln";

        private UserProperty() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Param
    extends zzgi {
        @ShowFirstParty
        @KeepForSdk
        public static final String FATAL = "fatal";
        @ShowFirstParty
        @KeepForSdk
        public static final String TIMESTAMP = "timestamp";
        @ShowFirstParty
        @KeepForSdk
        public static final String TYPE = "type";

        private Param() {
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public static final class Event
    extends zzgj {
        @ShowFirstParty
        @KeepForSdk
        public static final String APP_EXCEPTION = "_ae";
        @ShowFirstParty
        @KeepForSdk
        public static final String AD_REWARD = "_ar";

        private Event() {
        }
    }
}

