/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzp;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzge;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzr;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;

public final class zzjs
extends zzge {
    private static final String[] zztw = new String[]{"firebase_", "google_", "ga_"};
    private SecureRandom zztx;
    private final AtomicLong zzty = new AtomicLong(0L);
    private int zzag;
    private Integer zztz = null;
    private static final List<String> zzua = Collections.unmodifiableList(Arrays.asList("source", "medium", "campaign", "term", "content"));

    zzjs(zzfj zzfj2) {
        super(zzfj2);
    }

    @Override
    protected final boolean zzbk() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzbl() {
        ((zzgf)this).zzo();
        SecureRandom secureRandom = new SecureRandom();
        long l = secureRandom.nextLong();
        if (l == 0L && (l = secureRandom.nextLong()) == 0L) {
            ((zzgf)this).zzab().zzgn().zzao("Utils falling back to Random for random id");
        }
        this.zzty.set(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long zzjv() {
        if (this.zzty.get() == 0L) {
            AtomicLong atomicLong = this.zzty;
            synchronized (atomicLong) {
                return new Random(System.nanoTime() ^ ((zzgf)this).zzx().currentTimeMillis()).nextLong() + (long)(++this.zzag);
            }
        }
        AtomicLong atomicLong = this.zzty;
        synchronized (atomicLong) {
            this.zzty.compareAndSet(-1L, 1L);
            return this.zzty.getAndIncrement();
        }
    }

    @WorkerThread
    final SecureRandom zzjw() {
        ((zzgf)this).zzo();
        if (this.zztx == null) {
            this.zztx = new SecureRandom();
        }
        return this.zztx;
    }

    static boolean zzbk(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    final Bundle zza(@NonNull Uri uri) {
        if (uri == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            if (uri.isHierarchical()) {
                string = uri.getQueryParameter("utm_campaign");
                string2 = uri.getQueryParameter("utm_source");
                string3 = uri.getQueryParameter("utm_medium");
                string4 = uri.getQueryParameter("gclid");
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            ((zzgf)this).zzab().zzgn().zza("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
            return null;
        }
        if (!(TextUtils.isEmpty(string) && TextUtils.isEmpty(string2) && TextUtils.isEmpty(string3) && TextUtils.isEmpty(string4))) {
            String string5;
            String string6;
            String string7;
            String string8;
            String string9;
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)string)) {
                bundle.putString("campaign", string);
            }
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                bundle.putString("source", string2);
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString("medium", string3);
            }
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                bundle.putString("gclid", string4);
            }
            if (!TextUtils.isEmpty((CharSequence)(string9 = uri.getQueryParameter("utm_term")))) {
                bundle.putString("term", string9);
            }
            if (!TextUtils.isEmpty((CharSequence)(string8 = uri.getQueryParameter("utm_content")))) {
                bundle.putString("content", string8);
            }
            if (!TextUtils.isEmpty((CharSequence)(string7 = uri.getQueryParameter("aclid")))) {
                bundle.putString("aclid", string7);
            }
            if (!TextUtils.isEmpty((CharSequence)(string6 = uri.getQueryParameter("cp1")))) {
                bundle.putString("cp1", string6);
            }
            if (!TextUtils.isEmpty((CharSequence)(string5 = uri.getQueryParameter("anid")))) {
                bundle.putString("anid", string5);
            }
            return bundle;
        }
        return null;
    }

    static boolean zzc(Intent intent) {
        String string = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        return "android-app://com.google.android.googlequicksearchbox/https/www.google.com".equals(string) || "https://www.google.com".equals(string) || "android-app://com.google.appcrawler".equals(string);
    }

    final boolean zzp(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzgf)this).zzab().zzgm().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzgf)this).zzab().zzgm().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            ((zzgf)this).zzab().zzgm().zza("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzgf)this).zzab().zzgm().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzq(String string, String string2) {
        int n;
        if (string2 == null) {
            ((zzgf)this).zzab().zzgm().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            ((zzgf)this).zzab().zzgm().zza("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2) && n2 != 95) {
            ((zzgf)this).zzab().zzgm().zza("Name must start with a letter or _ (underscore). Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (int i = Character.charCount(n2); i < n3; i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (n == 95 || Character.isLetterOrDigit(n)) continue;
            ((zzgf)this).zzab().zzgm().zza("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zza(String string, String[] stringArray, String string2) {
        boolean bl;
        int n;
        String[] stringArray2;
        String string3;
        block6: {
            if (string2 == null) {
                ((zzgf)this).zzab().zzgm().zza("Name is required and can't be null. Type", string);
                return false;
            }
            string3 = string2;
            Preconditions.checkNotNull((Object)string3);
            stringArray2 = zztw;
            int n2 = zztw.length;
            for (n = 0; n < n2; ++n) {
                String string4 = stringArray2[n];
                if (!string3.startsWith(string4)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        if (bl) {
            ((zzgf)this).zzab().zzgm().zza("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null) {
            boolean bl2;
            block7: {
                stringArray2 = stringArray;
                string3 = string2;
                Preconditions.checkNotNull((Object)stringArray2);
                String[] stringArray3 = stringArray2;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string5 = stringArray3[i];
                    if (!zzjs.zzs(string3, string5)) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
            if (bl2) {
                ((zzgf)this).zzab().zzgm().zza("Name is reserved. Type, name", string, string2);
                return false;
            }
        }
        return true;
    }

    final boolean zza(String string, int n, String string2) {
        if (string2 == null) {
            ((zzgf)this).zzab().zzgm().zza("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > n) {
            ((zzgf)this).zzab().zzgm().zza("Name is too long. Type, maximum supported length, name", string, n, string2);
            return false;
        }
        return true;
    }

    final int zzbl(String string) {
        if (!this.zzq("event", string)) {
            return 2;
        }
        if (!this.zza("event", zzgj.zzpn, string)) {
            return 13;
        }
        if (!this.zza("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzbm(String string) {
        if (!this.zzq("user property", string)) {
            return 6;
        }
        if (!this.zza("user property", zzgl.zzpp, string)) {
            return 15;
        }
        if (!this.zza("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    private final boolean zza(String string, String string2, int n, Object object, boolean bl) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            String string3 = String.valueOf(object);
            if (string3.codePointCount(0, string3.length()) > n) {
                ((zzgf)this).zzab().zzgp().zza("Value is too long; discarded. Value kind, name, value length", string, string2, string3.length());
                return false;
            }
            return true;
        }
        if (object instanceof Bundle && bl) {
            return true;
        }
        if (object instanceof Parcelable[] && bl) {
            for (Parcelable parcelable : (Parcelable[])object) {
                if (parcelable instanceof Bundle) continue;
                ((zzgf)this).zzab().zzgp().zza("All Parcelable[] elements must be of type Bundle. Value type, name", parcelable.getClass(), string2);
                return false;
            }
            return true;
        }
        if (object instanceof ArrayList && bl) {
            ArrayList arrayList = (ArrayList)object;
            int n2 = arrayList.size();
            for (int i = 0; i < n2; ++i) {
                Object e = arrayList.get(i);
                Object e2 = e;
                if (e instanceof Bundle) continue;
                ((zzgf)this).zzab().zzgp().zza("All ArrayList elements must be of type Bundle. Value type, name", e2.getClass(), string2);
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzr(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (!zzjs.zzbn(string)) {
                if (this.zzj.zzhw()) {
                    ((zzgf)this).zzab().zzgm().zza("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", zzef.zzam(string));
                }
                return false;
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (!zzjs.zzbn(string2)) {
                ((zzgf)this).zzab().zzgm().zza("Invalid admob_app_id. Analytics disabled.", zzef.zzam(string2));
                return false;
            }
        } else {
            if (this.zzj.zzhw()) {
                ((zzgf)this).zzab().zzgm().zzao("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            }
            return false;
        }
        return true;
    }

    static boolean zza(String string, String string2, String string3, String string4) {
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl && bl2) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    @VisibleForTesting
    private static boolean zzbn(String string) {
        Preconditions.checkNotNull((Object)string);
        String string2 = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
        return string.matches(string2);
    }

    private static Object zza(int n, Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Long || object instanceof Double) {
            return object;
        }
        if (object instanceof Integer) {
            return (long)((Integer)object).intValue();
        }
        if (object instanceof Byte) {
            return (long)((Byte)object).byteValue();
        }
        if (object instanceof Short) {
            return (long)((Short)object).shortValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            return zzjs.zza(String.valueOf(object), n, bl);
        }
        return null;
    }

    public static String zza(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string.codePointCount(0, string.length()) > n) {
            if (bl) {
                return String.valueOf(string.substring(0, string.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    final Object zzb(String string, Object object) {
        if ("_ev".equals(string)) {
            return zzjs.zza(256, object, true);
        }
        return zzjs.zza(zzjs.zzbq(string) ? 256 : 100, object, false);
    }

    static Bundle[] zzb(Object object) {
        if (object instanceof Bundle) {
            return new Bundle[]{(Bundle)object};
        }
        if (object instanceof Parcelable[]) {
            return (Bundle[])Arrays.copyOf((Parcelable[])object, ((Parcelable[])object).length, Bundle[].class);
        }
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            return arrayList.toArray(new Bundle[arrayList.size()]);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    final Bundle zza(String var1_1, String var2_2, Bundle var3_3, @Nullable List<String> var4_4, boolean var5_5, boolean var6_6) {
        block15: {
            var7_7 = null;
            if (var3_3 == null) break block15;
            var7_7 = new Bundle(var3_3);
            var8_8 = 0;
            var9_9 = this.zzad().zze(var1_1, zzak.zziw) != false ? new TreeSet<E>(var3_3.keySet()) : var3_3.keySet();
            for (String var11_11 : var9_9) {
                block16: {
                    var12_12 = 0;
                    if (var4_4 == null || !var4_4.contains(var11_11)) {
                        if (var5_5) {
                            var14_14 = this;
                            var15_15 = var11_11;
                            v0 = var14_14.zzp("event param", var15_15) == false ? 3 : (var14_14.zza("event param", null, var15_15) == false ? 14 : (var12_12 = var14_14.zza("event param", 40, var15_15) == false ? 3 : 0));
                        }
                        if (var12_12 == 0) {
                            var14_14 = this;
                            var15_15 = var11_11;
                            v1 = var14_14.zzq("event param", var15_15) == false ? 3 : (var14_14.zza("event param", null, var15_15) == false ? 14 : (var12_12 = var14_14.zza("event param", 40, var15_15) == false ? 3 : 0));
                        }
                    }
                    if (var12_12 != 0) {
                        if (zzjs.zza(var7_7, var12_12)) {
                            var13_13 = zzjs.zza(var11_11, 40, true);
                            var7_7.putString("_ev", var13_13);
                            if (var12_12 == 3) {
                                zzjs.zzb(var7_7, (Object)var11_11);
                            }
                        }
                        var7_7.remove(var11_11);
                        continue;
                    }
                    var19_19 = var6_6;
                    var18_18 = var3_3.get(var11_11);
                    var17_17 = var11_11;
                    var16_16 = var2_2;
                    var15_15 = var1_1;
                    var14_14 = this;
                    var14_14.zzo();
                    if (!var19_19) ** GOTO lbl-1000
                    var24_24 = var18_18;
                    var23_23 = var17_17;
                    var22_22 = "param";
                    var21_21 = var14_14;
                    if (!(var24_24 instanceof Parcelable[])) break block16;
                    var25_25 = ((Parcelable[])var24_24).length;
                    ** GOTO lbl45
                }
                if (!(var24_24 instanceof ArrayList)) {
                    v2 = true;
                } else {
                    var25_25 = ((ArrayList)var24_24).size();
lbl45:
                    // 2 sources

                    if (var25_25 > 1000) {
                        var21_21.zzab().zzgp().zza("Parameter array is too long; discarded. Value kind, name, array length", var22_22, var23_23, var25_25);
                        v2 = false;
                    } else {
                        v2 = true;
                    }
                }
                if (!v2) {
                    v3 = 17;
                } else lbl-1000:
                // 2 sources

                {
                    var20_20 = var14_14.zzad().zzn(var15_15) != false && zzjs.zzbq(var16_16) != false || zzjs.zzbq(var17_17) != false ? var14_14.zza("param", var17_17, 256, var18_18, var19_19) : var14_14.zza("param", var17_17, 100, var18_18, var19_19);
                    v3 = var12_12 = var20_20 != false ? 0 : 4;
                }
                if (v3 != 0 && !"_ev".equals(var11_11)) {
                    if (zzjs.zza(var7_7, var12_12)) {
                        var13_13 = zzjs.zza(var11_11, 40, true);
                        var7_7.putString("_ev", var13_13);
                        zzjs.zzb(var7_7, var3_3.get(var11_11));
                    }
                    var7_7.remove(var11_11);
                    continue;
                }
                if (!zzjs.zzbk(var11_11) || ++var8_8 <= 25) continue;
                var13_13 = new StringBuilder(48).append("Event can't contain more than 25 params").toString();
                this.zzab().zzgm().zza(var13_13, this.zzy().zzaj(var2_2), this.zzy().zzc(var3_3));
                zzjs.zza(var7_7, 5);
                var7_7.remove(var11_11);
            }
        }
        return var7_7;
    }

    private static boolean zza(Bundle bundle, int n) {
        if (bundle.getLong("_err") == 0L) {
            bundle.putLong("_err", (long)n);
            return true;
        }
        return false;
    }

    private static void zzb(Bundle bundle, Object object) {
        Preconditions.checkNotNull((Object)bundle);
        if (object != null && (object instanceof String || object instanceof CharSequence)) {
            String string = String.valueOf(object);
            bundle.putLong("_el", (long)string.length());
        }
    }

    private static int zzbo(String string) {
        if ("_ldl".equals(string)) {
            return 2048;
        }
        if ("_id".equals(string)) {
            return 256;
        }
        return 36;
    }

    final int zzc(String string, Object object) {
        boolean bl = "_ldl".equals(string) ? this.zza("user property referrer", string, zzjs.zzbo(string), object, false) : this.zza("user property", string, zzjs.zzbo(string), object, false);
        if (bl) {
            return 0;
        }
        return 7;
    }

    final Object zzd(String string, Object object) {
        if ("_ldl".equals(string)) {
            return zzjs.zza(zzjs.zzbo(string), object, true);
        }
        return zzjs.zza(zzjs.zzbo(string), object, false);
    }

    final void zza(Bundle bundle, String string, Object object) {
        if (bundle == null) {
            return;
        }
        if (object instanceof Long) {
            bundle.putLong(string, ((Long)object).longValue());
            return;
        }
        if (object instanceof String) {
            String string2 = String.valueOf(object);
            bundle.putString(string, string2);
            return;
        }
        if (object instanceof Double) {
            bundle.putDouble(string, ((Double)object).doubleValue());
            return;
        }
        if (string != null) {
            String string3 = object != null ? object.getClass().getSimpleName() : null;
            ((zzgf)this).zzab().zzgp().zza("Not putting event parameter. Invalid value type. name, type", ((zzgf)this).zzy().zzak(string), string3);
        }
    }

    public final void zza(int n, String string, String string2, int n2) {
        this.zza(null, n, string, string2, n2);
    }

    final void zza(String string, int n, String string2, String string3, int n2) {
        Bundle bundle = new Bundle();
        zzjs.zza(bundle, n);
        if (((zzgf)this).zzad().zze(string, zzak.zzip)) {
            if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
                bundle.putString(string2, string3);
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            bundle.putLong("_el", (long)n2);
        }
        zzr zzr2 = this.zzj.zzae();
        this.zzj.zzq().logEvent("auto", "_err", bundle);
    }

    static MessageDigest getMessageDigest() {
        for (int i = 0; i < 2; ++i) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest == null) continue;
                return messageDigest;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        }
        return null;
    }

    @VisibleForTesting
    static long zzd(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        Preconditions.checkState((byArray.length > 0 ? 1 : 0) != 0);
        long l = 0L;
        int n = 0;
        for (int i = byArray.length - 1; i >= 0 && i >= byArray.length - 8; --i) {
            l += ((long)byArray[i] & 0xFFL) << n;
            n += 8;
        }
        return l;
    }

    static boolean zzb(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzjs.zzb(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzjs.zzb(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    private static boolean zzb(Context context, String string) {
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ServiceInfo serviceInfo = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (serviceInfo != null && serviceInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @WorkerThread
    final boolean zzbp(String string) {
        ((zzgf)this).zzo();
        if (Wrappers.packageManager((Context)((zzgf)this).getContext()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzgf)this).zzab().zzgr().zza("Permission not granted", string);
        return false;
    }

    static boolean zzbq(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzs(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    static boolean zza(Boolean bl, Boolean bl2) {
        if (bl == null && bl2 == null) {
            return true;
        }
        if (bl == null) {
            return false;
        }
        return bl.equals(bl2);
    }

    static boolean zzb(@Nullable List<String> list, @Nullable List<String> list2) {
        if (list == null && list2 == null) {
            return true;
        }
        if (list == null) {
            return false;
        }
        return list.equals(list2);
    }

    final boolean zzbr(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        String string2 = ((zzgf)this).zzad().zzbu();
        zzr zzr2 = ((zzgf)this).zzae();
        return string2.equals(string);
    }

    final Bundle zzg(Bundle bundle) {
        Bundle bundle2 = new Bundle();
        if (bundle != null) {
            for (String string : bundle.keySet()) {
                Object object = this.zzb(string, bundle.get(string));
                if (object == null) {
                    ((zzgf)this).zzab().zzgp().zza("Param value can't be null", ((zzgf)this).zzy().zzak(string));
                    continue;
                }
                this.zza(bundle2, string, object);
            }
        }
        return bundle2;
    }

    final zzai zza(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (this.zzbl(string2) != 0) {
            ((zzgf)this).zzab().zzgk().zza("Invalid conditional property event name", ((zzgf)this).zzy().zzal(string2));
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        List list = CollectionUtils.listOf((Object)"_o");
        Bundle bundle2 = this.zza(string, string2, bundle, list, false, false);
        Bundle bundle3 = this.zzg(bundle2);
        return new zzai(string2, new zzah(bundle3), string3, l);
    }

    @WorkerThread
    final long zzc(Context context, String string) {
        ((zzgf)this).zzo();
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotEmpty((String)string);
        long l = 0L;
        PackageManager packageManager = context.getPackageManager();
        MessageDigest messageDigest = zzjs.getMessageDigest();
        if (messageDigest == null) {
            ((zzgf)this).zzab().zzgk().zzao("Could not get MD5 instance");
            l = -1L;
        } else if (packageManager != null) {
            try {
                if (!this.zzd(context, string)) {
                    PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(((zzgf)this).getContext().getPackageName(), 64);
                    if (packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                        l = zzjs.zzd(messageDigest.digest(packageInfo.signatures[0].toByteArray()));
                    } else {
                        ((zzgf)this).zzab().zzgn().zzao("Could not get signatures");
                        l = -1L;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzgf)this).zzab().zzgk().zza("Package name not found", (Object)nameNotFoundException);
            }
        }
        return l;
    }

    @VisibleForTesting
    private final boolean zzd(Context context, String string) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(string, 64);
            if (packageInfo != null && packageInfo.signatures != null && packageInfo.signatures.length > 0) {
                Signature signature = packageInfo.signatures[0];
                return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(signature.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
            }
        }
        catch (CertificateException certificateException) {
            ((zzgf)this).zzab().zzgk().zza("Error obtaining certificate", certificateException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgf)this).zzab().zzgk().zza("Package name not found", (Object)nameNotFoundException);
        }
        return true;
    }

    static byte[] zza(Parcelable parcelable) {
        if (parcelable == null) {
            return null;
        }
        Parcel parcel = Parcel.obtain();
        try {
            parcelable.writeToParcel(parcel, 0);
            byte[] byArray = parcel.marshall();
            return byArray;
        }
        finally {
            parcel.recycle();
        }
    }

    public static Bundle zzh(Bundle bundle) {
        if (bundle == null) {
            return new Bundle();
        }
        Bundle bundle2 = new Bundle(bundle);
        for (String string : bundle2.keySet()) {
            int n;
            Object object;
            Object object2 = bundle2.get(string);
            if (object2 instanceof Bundle) {
                bundle2.putBundle(string, new Bundle((Bundle)object2));
                continue;
            }
            if (object2 instanceof Parcelable[]) {
                object = (Parcelable[])object2;
                for (n = 0; n < ((Parcelable[])object).length; ++n) {
                    if (!(object[n] instanceof Bundle)) continue;
                    object[n] = new Bundle((Bundle)object[n]);
                }
                continue;
            }
            if (!(object2 instanceof List)) continue;
            object = (List)object2;
            for (n = 0; n < object.size(); ++n) {
                Object e = object.get(n);
                if (!(e instanceof Bundle)) continue;
                object.set(n, new Bundle((Bundle)e));
            }
        }
        return bundle2;
    }

    public final int zzjx() {
        if (this.zztz == null) {
            this.zztz = GoogleApiAvailabilityLight.getInstance().getApkVersion(((zzgf)this).getContext()) / 1000;
        }
        return this.zztz;
    }

    public final int zzd(int n) {
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzgf)this).getContext(), 12451000);
    }

    public static long zzc(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    @WorkerThread
    final String zzjy() {
        byte[] byArray = new byte[16];
        this.zzjw().nextBytes(byArray);
        return String.format(Locale.US, "%032x", new BigInteger(1, byArray));
    }

    @WorkerThread
    final void zzb(Bundle bundle, long l) {
        long l2 = bundle.getLong("_et");
        if (l2 != 0L) {
            ((zzgf)this).zzab().zzgn().zza("Params already contained engagement", l2);
        }
        bundle.putLong("_et", l + l2);
    }

    public final void zzb(zzp zzp2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzp zzp2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzp zzp2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzp zzp2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzp zzp2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zza(zzp zzp2, Bundle bundle) {
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public static Bundle zzc(List<zzjn> list) {
        Bundle bundle = new Bundle();
        if (list == null) {
            return bundle;
        }
        for (zzjn zzjn2 : list) {
            if (zzjn2.zzkr != null) {
                bundle.putString(zzjn2.name, zzjn2.zzkr);
                continue;
            }
            if (zzjn2.zzts != null) {
                bundle.putLong(zzjn2.name, zzjn2.zzts.longValue());
                continue;
            }
            if (zzjn2.zztu == null) continue;
            bundle.putDouble(zzjn2.name, zzjn2.zztu.doubleValue());
        }
        return bundle;
    }

    public final void zza(zzp zzp2, ArrayList<Bundle> arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzp2.zzb(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzj.zzab().zzgn().zza("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public static ArrayList<Bundle> zzd(List<zzq> list) {
        if (list == null) {
            return new ArrayList<Bundle>(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(list.size());
        for (zzq zzq2 : list) {
            Bundle bundle = new Bundle();
            bundle.putString("app_id", zzq2.packageName);
            bundle.putString("origin", zzq2.origin);
            bundle.putLong("creation_timestamp", zzq2.creationTimestamp);
            bundle.putString("name", zzq2.zzdw.name);
            zzgg.zza((Bundle)bundle, (Object)zzq2.zzdw.getValue());
            bundle.putBoolean("active", zzq2.active);
            if (zzq2.triggerEventName != null) {
                bundle.putString("trigger_event_name", zzq2.triggerEventName);
            }
            if (zzq2.zzdx != null) {
                bundle.putString("timed_out_event_name", zzq2.zzdx.name);
                if (zzq2.zzdx.zzfq != null) {
                    bundle.putBundle("timed_out_event_params", zzq2.zzdx.zzfq.zzcv());
                }
            }
            bundle.putLong("trigger_timeout", zzq2.triggerTimeout);
            if (zzq2.zzdy != null) {
                bundle.putString("triggered_event_name", zzq2.zzdy.name);
                if (zzq2.zzdy.zzfq != null) {
                    bundle.putBundle("triggered_event_params", zzq2.zzdy.zzfq.zzcv());
                }
            }
            bundle.putLong("triggered_timestamp", zzq2.zzdw.zztr);
            bundle.putLong("time_to_live", zzq2.timeToLive);
            if (zzq2.zzdz != null) {
                bundle.putString("expired_event_name", zzq2.zzdz.name);
                if (zzq2.zzdz.zzfq != null) {
                    bundle.putBundle("expired_event_params", zzq2.zzdz.zzfq.zzcv());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    public final URL zza(long l, @NonNull String string, @NonNull String string2) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            String string3 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s", String.format("v%s.%s", l, this.zzjx()), string2, string);
            return new URL(string3);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            ((zzgf)this).zzab().zzgk().zza("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }
}

