/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzcc;
import com.google.android.gms.internal.measurement.zzcd;
import com.google.android.gms.internal.measurement.zzce;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzcm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzca
implements zzce {
    @GuardedBy(value="ConfigurationContentLoader.class")
    static final Map<Uri, zzca> zzaah = new ArrayMap();
    private final ContentResolver zzaai;
    private final Uri uri;
    private final Object zzaaj = new Object();
    private volatile Map<String, String> zzaak;
    @GuardedBy(value="this")
    private final List<zzcf> zzaal = new ArrayList<zzcf>();
    private static final String[] zzaam = new String[]{"key", "value"};

    private zzca(ContentResolver contentResolver, Uri uri) {
        this.zzaai = contentResolver;
        this.uri = uri;
        this.zzaai.registerContentObserver(uri, false, (ContentObserver)new zzcc(this, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzca zza(ContentResolver contentResolver, Uri uri) {
        Class<zzca> clazz = zzca.class;
        synchronized (zzca.class) {
            zzca zzca2 = zzaah.get(uri);
            if (zzca2 == null) {
                try {
                    zzca2 = new zzca(contentResolver, uri);
                    zzaah.put(uri, zzca2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzca2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zzre() {
        Map<String, String> map = this.zzaak;
        if (map == null) {
            Object object = this.zzaaj;
            synchronized (object) {
                map = this.zzaak;
                if (map == null) {
                    this.zzaak = map = this.zzrg();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzrf() {
        zzca zzca2;
        Object object = this.zzaaj;
        synchronized (object) {
            this.zzaak = null;
            zzcm.zzrl();
        }
        zzca zzca3 = zzca2 = this;
        synchronized (zzca2) {
            Iterator<zzcf> iterator = zzca2.zzaal.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzrk();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zzrg() {
        try {
            return (Map)zzch.zza(new zzcd(this));
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
    }

    @Override
    public final /* synthetic */ Object zzdd(String string) {
        String string2 = string;
        return this.zzre().get(string2);
    }

    final /* synthetic */ Map zzrh() {
        Cursor cursor = this.zzaai.query(this.uri, zzaam, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

