/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzgu;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdn
extends zzdj<Boolean>
implements zzff<Boolean>,
zzgu,
RandomAccess {
    private static final zzdn zzade = new zzdn(new boolean[0], 0);
    private boolean[] zzadf;
    private int size;

    zzdn() {
        this(new boolean[10], 0);
    }

    private zzdn(boolean[] blArray, int n) {
        this.zzadf = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzrz();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzadf, n2, this.zzadf, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdn)) {
            return super.equals(object);
        }
        zzdn zzdn2 = (zzdn)object;
        if (this.size != zzdn2.size) {
            return false;
        }
        boolean[] blArray = zzdn2.zzadf;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzadf[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzez.zzs(this.zzadf[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zza(this.size, bl);
    }

    private final void zza(int n, boolean bl) {
        this.zzrz();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
        if (this.size < this.zzadf.length) {
            System.arraycopy(this.zzadf, n, this.zzadf, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzadf, 0, blArray, 0, n);
            System.arraycopy(this.zzadf, n, blArray, n + 1, this.size - n);
            this.zzadf = blArray;
        }
        this.zzadf[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzrz();
        zzez.checkNotNull(collection);
        if (!(collection instanceof zzdn)) {
            return super.addAll(collection);
        }
        zzdn zzdn2 = (zzdn)collection;
        if (zzdn2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdn2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdn2.size;
        if (n > this.zzadf.length) {
            this.zzadf = Arrays.copyOf(this.zzadf, n);
        }
        System.arraycopy(zzdn2.zzadf, 0, this.zzadf, this.size, zzdn2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzrz();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzadf[i])) continue;
            System.arraycopy(this.zzadf, i + 1, this.zzadf, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzan(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzao(n));
        }
    }

    private final String zzao(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzdn zzdn2 = this;
        zzdn2.zzrz();
        zzdn2.zzan(n);
        boolean bl3 = zzdn2.zzadf[n];
        zzdn2.zzadf[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdn zzdn2 = this;
        zzdn2.zzrz();
        zzdn2.zzan(n);
        boolean bl = zzdn2.zzadf[n];
        if (n < zzdn2.size - 1) {
            System.arraycopy(zzdn2.zzadf, n + 1, zzdn2.zzadf, n, zzdn2.size - n - 1);
        }
        --zzdn2.size;
        ++zzdn2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zza(n, bl);
    }

    @Override
    public final /* synthetic */ zzff zzap(int n) {
        int n2 = n;
        zzdn zzdn2 = this;
        if (n2 < zzdn2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdn(Arrays.copyOf(zzdn2.zzadf, n2), zzdn2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdn zzdn2 = this;
        zzdn2.zzan(n);
        return zzdn2.zzadf[n];
    }

    static {
        zzade.zzry();
    }
}

