/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzjs;
import java.util.Map;

public final class zzhq
extends zzg {
    @VisibleForTesting
    protected zzhr zzqo;
    private volatile zzhr zzqp;
    private zzhr zzqq;
    private final Map<Activity, zzhr> zzqr = new ArrayMap();
    private zzhr zzqs;
    private String zzqt;

    public zzhq(zzfj zzfj2) {
        super(zzfj2);
    }

    @Override
    protected final boolean zzbk() {
        return false;
    }

    @WorkerThread
    public final zzhr zzin() {
        this.zzbi();
        ((zzgf)this).zzo();
        return this.zzqo;
    }

    public final void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (this.zzqp == null) {
            ((zzgf)this).zzab().zzgp().zzao("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzqr.get(activity) == null) {
            ((zzgf)this).zzab().zzgp().zzao("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzhq.zzbh(activity.getClass().getCanonicalName());
        }
        boolean bl = this.zzqp.zzqv.equals(string2);
        boolean bl2 = zzjs.zzs(this.zzqp.zzqu, string);
        if (bl && bl2) {
            ((zzgf)this).zzab().zzgp().zzao("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgf)this).zzab().zzgp().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgf)this).zzab().zzgp().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgf)this).zzab().zzgs().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzhr zzhr2 = new zzhr(string, string2, ((zzgf)this).zzz().zzjv());
        this.zzqr.put(activity, zzhr2);
        this.zza(activity, zzhr2, true);
    }

    public final zzhr zzio() {
        ((zzgf)this).zzm();
        return this.zzqp;
    }

    @MainThread
    private final void zza(Activity activity, zzhr zzhr2, boolean bl) {
        zzhr zzhr3;
        zzhr zzhr4 = zzhr3 = this.zzqp == null ? this.zzqq : this.zzqp;
        if (zzhr2.zzqv == null) {
            zzhr2 = new zzhr(zzhr2.zzqu, zzhq.zzbh(activity.getClass().getCanonicalName()), zzhr2.zzqw);
        }
        zzhr zzhr5 = zzhr2;
        this.zzqq = this.zzqp;
        this.zzqp = zzhr5;
        ((zzgf)this).zzaa().zza(new zzht(this, bl, zzhr3, zzhr5));
    }

    @WorkerThread
    private final void zza(@NonNull zzhr zzhr2, boolean bl) {
        ((zzd)this).zzp().zzc(((zzgf)this).zzx().elapsedRealtime());
        if (((zzd)this).zzv().zza(zzhr2.zzqx, bl)) {
            zzhr2.zzqx = false;
        }
    }

    public static void zza(zzhr zzhr2, Bundle bundle, boolean bl) {
        if (bundle != null && zzhr2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzhr2.zzqu != null) {
                bundle.putString("_sn", zzhr2.zzqu);
            } else {
                bundle.remove("_sn");
            }
            bundle.putString("_sc", zzhr2.zzqv);
            bundle.putLong("_si", zzhr2.zzqw);
            return;
        }
        if (bundle != null && zzhr2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzhr zzhr2) {
        ((zzgf)this).zzo();
        zzhq zzhq2 = this;
        synchronized (zzhq2) {
            if (this.zzqt == null || this.zzqt.equals(string) || zzhr2 != null) {
                this.zzqt = string;
                this.zzqs = zzhr2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zzbh(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzhr zza(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzhr zzhr2 = this.zzqr.get(activity);
        if (zzhr2 == null) {
            String string = zzhq.zzbh(activity.getClass().getCanonicalName());
            zzhr2 = new zzhr(null, string, ((zzgf)this).zzz().zzjv());
            this.zzqr.put(activity, zzhr2);
        }
        return zzhr2;
    }

    @MainThread
    public final void onActivityCreated(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzhr zzhr2 = new zzhr(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzqr.put(activity, zzhr2);
    }

    @MainThread
    public final void onActivityResumed(Activity activity) {
        zzhr zzhr2 = this.zza(activity);
        this.zza(activity, zzhr2, false);
        zza zza2 = ((zzd)this).zzp();
        long l = ((zzgf)zza2).zzx().elapsedRealtime();
        ((zzgf)zza2).zzaa().zza(new zze(zza2, l));
    }

    @MainThread
    public final void onActivityPaused(Activity activity) {
        zzhr zzhr2 = this.zza(activity);
        this.zzqq = this.zzqp;
        this.zzqp = null;
        ((zzgf)this).zzaa().zza(new zzhs(this, zzhr2));
    }

    @MainThread
    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        if (bundle == null) {
            return;
        }
        zzhr zzhr2 = this.zzqr.get(activity);
        if (zzhr2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzhr2.zzqw);
        bundle2.putString("name", zzhr2.zzqu);
        bundle2.putString("referrer_name", zzhr2.zzqv);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @MainThread
    public final void onActivityDestroyed(Activity activity) {
        this.zzqr.remove(activity);
    }

    static /* synthetic */ void zza(zzhq zzhq2, zzhr zzhr2, boolean bl) {
        zzhq2.zza(zzhr2, bl);
    }
}

