/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgk;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzfi
extends zzgk {
    private zzfm zza;
    private zzfm zzb;
    private final PriorityBlockingQueue<zzfj<?>> zzc;
    private final BlockingQueue<zzfj<?>> zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzfi(zzfl zzfl2) {
        super(zzfl2);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        this.zze = new zzfk(this, "Thread death: Uncaught exception on worker thread");
        this.zzf = new zzfk(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @Override
    public final void zzd() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzc() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzg() {
        return Thread.currentThread() == this.zza;
    }

    public final <V> Future<V> zza(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfj zzfj2 = new zzfj(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                ((zzgh)this).zzr().zzi().zza("Callable skipped the worker queue.");
            }
            zzfj2.run();
        } else {
            this.zza(zzfj2);
        }
        return zzfj2;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull(callable);
        zzfj zzfj2 = new zzfj(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zza) {
            zzfj2.run();
        } else {
            this.zza(zzfj2);
        }
        return zzfj2;
    }

    public final void zza(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzfj(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzgh)this).zzq().zza(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzgh)this).zzr().zzi().zza(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzgh)this).zzr().zzi().zza(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzfj<?> zzfj2) {
        Object object = this.zzg;
        synchronized (object) {
            this.zzc.add(zzfj2);
            if (this.zza == null) {
                this.zza = new zzfm(this, "Measurement Worker", this.zzc);
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                this.zza.zza();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Runnable runnable) throws IllegalStateException {
        this.zzaa();
        Preconditions.checkNotNull((Object)runnable);
        zzfj zzfj2 = new zzfj(this, runnable, false, "Task exception on network thread");
        zzfi zzfi2 = this;
        Object object = zzfi2.zzg;
        synchronized (object) {
            zzfi2.zzd.add(zzfj2);
            if (zzfi2.zzb == null) {
                zzfi2.zzb = new zzfm(zzfi2, "Measurement Network", zzfi2.zzd);
                zzfi2.zzb.setUncaughtExceptionHandler(zzfi2.zzf);
                zzfi2.zzb.start();
            } else {
                zzfi2.zzb.zza();
            }
            return;
        }
    }

    static /* synthetic */ Semaphore zza(zzfi zzfi2) {
        return zzfi2.zzh;
    }

    static /* synthetic */ boolean zzb(zzfi zzfi2) {
        return zzfi2.zzi;
    }

    static /* synthetic */ Object zzc(zzfi zzfi2) {
        return zzfi2.zzg;
    }

    static /* synthetic */ zzfm zzd(zzfi zzfi2) {
        return zzfi2.zza;
    }

    static /* synthetic */ zzfm zza(zzfi zzfi2, zzfm zzfm2) {
        zzfi2.zza = null;
        return null;
    }

    static /* synthetic */ zzfm zze(zzfi zzfi2) {
        return zzfi2.zzb;
    }

    static /* synthetic */ zzfm zzb(zzfi zzfi2, zzfm zzfm2) {
        zzfi2.zzb = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzh() {
        return zzj;
    }
}

