/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzed;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzef;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzu;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfl
implements zzgj {
    private static volatile zzfl zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzp zzg;
    private final zzu zzh;
    private final zzeu zzi;
    private final zzeh zzj;
    private final zzfi zzk;
    private final zzje zzl;
    private final zzjy zzm;
    private final zzef zzn;
    private final Clock zzo;
    private final zzhy zzp;
    private final zzgr zzq;
    private final zzb zzr;
    private final zzhp zzs;
    private zzed zzt;
    private zzhz zzu;
    private zzae zzv;
    private zzee zzw;
    private zzfa zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzfl(zzgs zzgs2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgs2);
        Object object2 = zzgs2.zza;
        this.zzg = new zzp((Context)object2);
        zzam.zza(this.zzg);
        this.zzb = zzgs2.zza;
        this.zzc = zzgs2.zzb;
        this.zzd = zzgs2.zzc;
        this.zze = zzgs2.zzd;
        this.zzf = zzgs2.zzh;
        this.zzab = zzgs2.zze;
        zzv zzv2 = zzgs2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzu((zzfl)object2);
        object2 = this;
        object = new zzeu((zzfl)object2);
        ((zzgk)object).zzab();
        this.zzi = object;
        object2 = this;
        zzeh zzeh2 = new zzeh((zzfl)object2);
        zzeh2.zzab();
        this.zzj = zzeh2;
        object2 = this;
        zzjy zzjy2 = new zzjy((zzfl)object2);
        zzjy2.zzab();
        this.zzm = zzjy2;
        object2 = this;
        zzef zzef2 = new zzef((zzfl)object2);
        zzef2.zzab();
        this.zzn = zzef2;
        object2 = this;
        this.zzr = new zzb((zzfl)object2);
        object2 = this;
        zzhy zzhy2 = new zzhy((zzfl)object2);
        zzhy2.zzx();
        this.zzp = zzhy2;
        object2 = this;
        zzgr zzgr2 = new zzgr((zzfl)object2);
        zzgr2.zzx();
        this.zzq = zzgr2;
        object2 = this;
        zzje zzje2 = new zzje((zzfl)object2);
        zzje2.zzx();
        this.zzl = zzje2;
        object2 = this;
        zzhp zzhp2 = new zzhp((zzfl)object2);
        zzhp2.zzab();
        this.zzs = zzhp2;
        object2 = this;
        zzfi zzfi2 = new zzfi((zzfl)object2);
        zzfi2.zzab();
        this.zzk = zzfi2;
        boolean bl = zzgs2.zzg != null && zzgs2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzp zzp2 = ((zzfl)object2).zzg;
        if (((zzfl)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzgr zzgr3 = ((zzfl)object2).zzh();
            if (((zzgh)zzgr3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgh)zzgr3).zzn().getApplicationContext();
                if (zzgr3.zza == null) {
                    zzgr3.zza = new zzho(zzgr3, null);
                }
                if (bl3) {
                    zzho zzho2 = zzgr3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzho2);
                    zzho2 = zzgr3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzho2);
                    ((zzgh)zzgr3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfl)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzfn(this, zzgs2));
    }

    @WorkerThread
    private final void zza(zzgs zzgs2) {
        ((zzgh)this.zzq()).zzd();
        com.google.android.gms.measurement.internal.zzu.zze();
        Object object = this;
        zzae zzae2 = new zzae((zzfl)object);
        zzae2.zzab();
        this.zzv = zzae2;
        zzfl zzfl2 = this;
        object = zzgs2;
        zzee zzee2 = new zzee(zzfl2, ((zzgs)object).zzf);
        zzee2.zzx();
        this.zzw = zzee2;
        object = this;
        zzed zzed2 = new zzed((zzfl)object);
        zzed2.zzx();
        this.zzt = zzed2;
        object = this;
        zzhz zzhz2 = new zzhz((zzfl)object);
        zzhz2.zzx();
        this.zzu = zzhz2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzfa((zzfl)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement is starting up, version", this.zzh.zzf());
        zzp zzp2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzp2 = this.zzg;
        String string = zzee2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzej zzej2;
            if (this.zzi().zzf(string)) {
                zzej2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzej2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzej2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzgh)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzp zzp2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzz()) {
                    if (!zzfb.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzjy.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzp zzp3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzjy.zza(this.zzy().zzac(), this.zzc().zzg(), this.zzy().zzad(), this.zzc().zzh())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzj();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzp3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzh()) {
                    this.zzc().zzd(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzam.zzbm));
        this.zzc().zzp.zza(this.zzh.zza(zzam.zzbn));
    }

    @Override
    public final zzp zzu() {
        return this.zzg;
    }

    public final zzu zzb() {
        return this.zzh;
    }

    public final zzeu zzc() {
        zzfl.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzeh zzr() {
        zzfl.zzb(this.zzj);
        return this.zzj;
    }

    public final zzeh zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzfi zzq() {
        zzfl.zzb(this.zzk);
        return this.zzk;
    }

    public final zzje zze() {
        zzfl.zzb(this.zzl);
        return this.zzl;
    }

    public final zzfa zzf() {
        return this.zzx;
    }

    final zzfi zzg() {
        return this.zzk;
    }

    public final zzgr zzh() {
        zzfl.zzb(this.zzq);
        return this.zzq;
    }

    public final zzjy zzi() {
        zzfl.zza(this.zzm);
        return this.zzm;
    }

    public final zzef zzj() {
        zzfl.zza(this.zzn);
        return this.zzn;
    }

    public final zzed zzk() {
        zzfl.zzb(this.zzt);
        return this.zzt;
    }

    private final zzhp zzai() {
        zzfl.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zzhy zzv() {
        zzfl.zzb(this.zzp);
        return this.zzp;
    }

    public final zzhz zzw() {
        zzfl.zzb(this.zzu);
        return this.zzu;
    }

    public final zzae zzx() {
        zzfl.zzb(this.zzv);
        return this.zzv;
    }

    public final zzee zzy() {
        zzfl.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzfl zza(Context context, String string, String string2, Bundle bundle) {
        return zzfl.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfl zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzfl> clazz = zzfl.class;
            synchronized (zzfl.class) {
                if (zza == null) {
                    zzgs zzgs2 = new zzgs(context, zzv2);
                    zza = new zzfl(zzgs2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzaj() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzgk zzgk2) {
        if (zzgk2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgk2.zzz()) {
            String string = String.valueOf(zzgk2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgh zzgh2) {
        if (zzgh2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        boolean bl;
        ((zzgh)this.zzq()).zzd();
        this.zzaj();
        if (this.zzh.zza(zzam.zzbg)) {
            if (this.zzh.zzh()) {
                return false;
            }
            if (this.zzad != null && this.zzad.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzc().zzk();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzh.zzi();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzac != null) {
                return this.zzac;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzh.zza(zzam.zzbb) && this.zzab != null) {
                return this.zzab;
            }
            return true;
        }
        if (this.zzh.zzh()) {
            return false;
        }
        Boolean bl4 = this.zzh.zzi();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzab != null && ((Boolean)zzam.zzbb.zza(null)).booleanValue()) {
                bl = this.zzab;
            }
        }
        return this.zzc().zzc(bl);
    }

    final long zzac() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzad() {
        zzp zzp2 = this.zzg;
    }

    final void zzae() {
        zzp zzp2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgk zzgk2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzaf() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        this.zzaj();
        ((zzgh)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzp zzp2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzz() || zzfb.zza(this.zzb) && zzjy.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zzc(this.zzy().zzac(), this.zzy().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgh)this.zzq()).zzd();
        zzfl.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzj().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgh)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzfo zzfo2 = new zzfo(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzhp zzhp2 = this.zzai();
        ((zzgh)zzhp2).zzd();
        zzhp2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzfo2);
        ((zzgh)zzhp2).zzq().zzb(new zzhr(zzhp2, string2, uRL2, null, null, zzfo2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfl zzfl2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfl2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfl2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzfl2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = string3;
            zzjy zzjy2 = zzfl2.zzi();
            ((zzgh)zzjy2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgh)zzjy2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfl2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfl2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzjy2 = zzfl2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzjy2.zzg(string5)) {
                list = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgh)zzjy2).zzn().sendBroadcast((Intent)list);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfl2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfl zzfl2, zzgs zzgs2) {
        zzfl2.zza(zzgs2);
    }
}

