/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzgh;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zziy;

@VisibleForTesting
public final class zzir
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzei zzc;
    final /* synthetic */ zzhz zza;

    protected zzir(zzhz zzhz2) {
        this.zza = zzhz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgh)this.zza).zzd();
        Context context = ((zzgh)this.zza).zzn();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzir zzir2 = this;
        synchronized (zzir2) {
            if (this.zzb) {
                ((zzgh)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            ((zzgh)this.zza).zzr().zzx().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzhz.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzir zzir2 = this;
        synchronized (zzir2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgh)this.zza).zzr().zzf().zza("Service connected with null binder");
                return;
            }
            zzdz zzdz2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzdz2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzdz ? (zzdz)iInterface : new zzeb(iBinder2));
                    ((zzgh)this.zza).zzr().zzx().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgh)this.zza).zzr().zzf().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgh)this.zza).zzr().zzf().zza("Service connect failed to get IMeasurementService");
            }
            if (zzdz2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgh)this.zza).zzn(), (ServiceConnection)zzhz.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzdz2;
                ((zzgh)this.zza).zzq().zza(new zziu(this, (zzdz)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgh)this.zza).zzr().zzw().zza("Service disconnected");
        ((zzgh)this.zza).zzq().zza(new zzit(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgh)this.zza).zzd();
        Context context = ((zzgh)this.zza).zzn();
        zzir zzir2 = this;
        synchronized (zzir2) {
            if (this.zzb) {
                ((zzgh)this.zza).zzr().zzx().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgh)this.zza).zzr().zzx().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzei(context, Looper.getMainLooper(), this, this);
            ((zzgh)this.zza).zzr().zzx().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzir zzir2 = this;
        synchronized (zzir2) {
            try {
                zzdz zzdz2 = (zzdz)this.zzc.getService();
                ((zzgh)this.zza).zzq().zza(new zziw(this, zzdz2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgh)this.zza).zzr().zzw().zza("Service connection suspended");
        ((zzgh)this.zza).zzq().zza(new zziv(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzeh zzeh2 = this.zza.zzw.zzd();
        if (zzeh2 != null) {
            zzeh2.zzi().zza("Service connection failed", connectionResult);
        }
        zzir zzir2 = this;
        synchronized (zzir2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgh)this.zza).zzq().zza(new zziy(this));
    }

    static /* synthetic */ boolean zza(zzir zzir2, boolean bl) {
        zzir2.zzb = false;
        return false;
    }
}

