/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import java.util.Map;

public final class zzb
extends zzf {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb = new ArrayMap();
    private long zzc;

    public zzb(zzfx zzfx2) {
        super(zzfx2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgs)this).zzr().zzf().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgs)this).zzq().zza(new zza(this, string, l));
    }

    @WorkerThread
    private final void zzc(String string, long l) {
        Integer n;
        ((zzgs)this).zzb();
        ((zzgs)this).zzd();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzb.isEmpty()) {
            this.zzc = l;
        }
        if ((n = this.zzb.get(string)) != null) {
            this.zzb.put(string, n + 1);
            return;
        }
        if (this.zzb.size() >= 100) {
            ((zzgs)this).zzr().zzi().zza("Too many ads visible");
            return;
        }
        this.zzb.put(string, 1);
        this.zza.put(string, l);
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            ((zzgs)this).zzr().zzf().zza("Ad unit id must be a non-empty string");
            return;
        }
        ((zzgs)this).zzq().zza(new zzd(this, string, l));
    }

    @WorkerThread
    private final void zzd(String string, long l) {
        ((zzgs)this).zzb();
        ((zzgs)this).zzd();
        Preconditions.checkNotEmpty((String)string);
        Integer n = this.zzb.get(string);
        if (n != null) {
            zzig zzig2 = ((zzf)this).zzi().zzab();
            int n2 = n - 1;
            if (n2 == 0) {
                this.zzb.remove(string);
                Long l2 = this.zza.get(string);
                if (l2 == null) {
                    ((zzgs)this).zzr().zzf().zza("First ad unit exposure time was never set");
                } else {
                    long l3 = l - l2;
                    this.zza.remove(string);
                    this.zza(string, l3, zzig2);
                }
                if (this.zzb.isEmpty()) {
                    if (this.zzc == 0L) {
                        ((zzgs)this).zzr().zzf().zza("First ad exposure time was never set");
                        return;
                    }
                    this.zza(l - this.zzc, zzig2);
                    this.zzc = 0L;
                }
                return;
            }
            this.zzb.put(string, n2);
            return;
        }
        ((zzgs)this).zzr().zzf().zza("Call to endAdUnitExposure for unknown ad unit id", string);
    }

    @WorkerThread
    private final void zza(long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzgs)this).zzr().zzx().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgs)this).zzr().zzx().zza("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzif.zza(zzig2, bundle, true);
        ((zzf)this).zzf().zza("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zza(String string, long l, zzig zzig2) {
        if (zzig2 == null) {
            ((zzgs)this).zzr().zzx().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            ((zzgs)this).zzr().zzx().zza("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzif.zza(zzig2, bundle, true);
        ((zzf)this).zzf().zza("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zza(long l) {
        zzig zzig2 = ((zzf)this).zzi().zzab();
        for (String string : this.zza.keySet()) {
            long l2 = this.zza.get(string);
            this.zza(string, l - l2, zzig2);
        }
        if (!this.zza.isEmpty()) {
            this.zza(l - this.zzc, zzig2);
        }
        this.zzb(l);
    }

    @WorkerThread
    private final void zzb(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
        }
    }

    static /* synthetic */ void zza(zzb zzb2, String string, long l) {
        zzb2.zzc(string, l);
    }

    static /* synthetic */ void zzb(zzb zzb2, String string, long l) {
        zzb2.zzd(string, l);
    }

    static /* synthetic */ void zza(zzb zzb2, long l) {
        zzb2.zzb(l);
    }
}

