/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzkb;
import com.google.android.gms.internal.measurement.zzkn;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzeq;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfg;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class zzfx
implements zzgu {
    private static volatile zzfx zza;
    private final Context zzb;
    private final String zzc;
    private final String zzd;
    private final String zze;
    private final boolean zzf;
    private final zzw zzg;
    private final zzx zzh;
    private final zzfg zzi;
    private final zzet zzj;
    private final zzfu zzk;
    private final zzjl zzl;
    private final zzkk zzm;
    private final zzer zzn;
    private final Clock zzo;
    private final zzif zzp;
    private final zzhc zzq;
    private final zzb zzr;
    private final zzia zzs;
    private zzep zzt;
    private zzik zzu;
    private zzah zzv;
    private zzeq zzw;
    private zzfm zzx;
    private boolean zzy = false;
    private Boolean zzz;
    private long zzaa;
    private volatile Boolean zzab;
    @VisibleForTesting
    private Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    private int zzae;
    private AtomicInteger zzaf = new AtomicInteger(0);
    private final long zzag;

    private zzfx(zzgz zzgz2) {
        Object object;
        Preconditions.checkNotNull((Object)zzgz2);
        Object object2 = zzgz2.zza;
        this.zzg = new zzw((Context)object2);
        zzap.zza(this.zzg);
        this.zzb = zzgz2.zza;
        this.zzc = zzgz2.zzb;
        this.zzd = zzgz2.zzc;
        this.zze = zzgz2.zzd;
        this.zzf = zzgz2.zzh;
        this.zzab = zzgz2.zze;
        zzv zzv2 = zzgz2.zzg;
        if (zzv2 != null && zzv2.zzg != null) {
            object = zzv2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzac = (Boolean)object;
            }
            if ((object = zzv2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
        }
        zzcl.zza(this.zzb);
        this.zzo = DefaultClock.getInstance();
        this.zzag = this.zzo.currentTimeMillis();
        object2 = this;
        this.zzh = new zzx((zzfx)object2);
        object2 = this;
        object = new zzfg((zzfx)object2);
        ((zzgr)object).zzab();
        this.zzi = object;
        object2 = this;
        zzet zzet2 = new zzet((zzfx)object2);
        zzet2.zzab();
        this.zzj = zzet2;
        object2 = this;
        zzkk zzkk2 = new zzkk((zzfx)object2);
        zzkk2.zzab();
        this.zzm = zzkk2;
        object2 = this;
        zzer zzer2 = new zzer((zzfx)object2);
        zzer2.zzab();
        this.zzn = zzer2;
        object2 = this;
        this.zzr = new zzb((zzfx)object2);
        object2 = this;
        zzif zzif2 = new zzif((zzfx)object2);
        zzif2.zzx();
        this.zzp = zzif2;
        object2 = this;
        zzhc zzhc2 = new zzhc((zzfx)object2);
        zzhc2.zzx();
        this.zzq = zzhc2;
        object2 = this;
        zzjl zzjl2 = new zzjl((zzfx)object2);
        zzjl2.zzx();
        this.zzl = zzjl2;
        object2 = this;
        zzia zzia2 = new zzia((zzfx)object2);
        zzia2.zzab();
        this.zzs = zzia2;
        object2 = this;
        zzfu zzfu2 = new zzfu((zzfx)object2);
        zzfu2.zzab();
        this.zzk = zzfu2;
        boolean bl = zzgz2.zzg != null && zzgz2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        zzw zzw2 = ((zzfx)object2).zzg;
        if (((zzfx)object2).zzb.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            zzhc zzhc3 = ((zzfx)object2).zzh();
            if (((zzgs)zzhc3).zzn().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzgs)zzhc3).zzn().getApplicationContext();
                if (zzhc3.zza == null) {
                    zzhc3.zza = new zzhv(zzhc3, null);
                }
                if (bl3) {
                    zzhv zzhv2 = zzhc3.zza;
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhv2);
                    zzhv2 = zzhc3.zza;
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhv2);
                    ((zzgs)zzhc3).zzr().zzx().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzfx)object2).zzr().zzi().zza("Application context is not an Application");
        }
        this.zzk.zza(new zzfz(this, zzgz2));
    }

    @WorkerThread
    private final void zza(zzgz zzgz2) {
        ((zzgs)this.zzq()).zzd();
        com.google.android.gms.measurement.internal.zzx.zze();
        Object object = this;
        zzah zzah2 = new zzah((zzfx)object);
        zzah2.zzab();
        this.zzv = zzah2;
        zzfx zzfx2 = this;
        object = zzgz2;
        zzeq zzeq2 = new zzeq(zzfx2, ((zzgz)object).zzf);
        zzeq2.zzx();
        this.zzw = zzeq2;
        object = this;
        zzep zzep2 = new zzep((zzfx)object);
        zzep2.zzx();
        this.zzt = zzep2;
        object = this;
        zzik zzik2 = new zzik((zzfx)object);
        zzik2.zzx();
        this.zzu = zzik2;
        this.zzm.zzac();
        this.zzi.zzac();
        object = this;
        this.zzx = new zzfm((zzfx)object);
        this.zzw.zzy();
        this.zzr().zzv().zza("App measurement is starting up, version", this.zzh.zzf());
        zzw zzw2 = this.zzg;
        this.zzr().zzv().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzw2 = this.zzg;
        String string = zzeq2.zzab();
        if (TextUtils.isEmpty((CharSequence)this.zzc)) {
            String string2;
            zzev zzev2;
            if (this.zzi().zzf(string)) {
                zzev2 = this.zzr().zzv();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzev2 = this.zzr().zzv();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzev2.zza(string2);
        }
        this.zzr().zzw().zza("Debug-level message logging enabled");
        if (this.zzae != this.zzaf.get()) {
            this.zzr().zzf().zza("Not all components initialized", this.zzae, this.zzaf.get());
        }
        this.zzy = true;
    }

    @WorkerThread
    protected final void zza() {
        ((zzgs)this.zzq()).zzd();
        if (this.zzc().zzc.zza() == 0L) {
            this.zzc().zzc.zza(this.zzo.currentTimeMillis());
        }
        if (Long.valueOf(this.zzc().zzh.zza()) == 0L) {
            this.zzr().zzx().zza("Persisting first open", this.zzag);
            this.zzc().zzh.zza(this.zzag);
        }
        if (!this.zzag()) {
            if (this.zzab()) {
                if (!this.zzi().zzd("android.permission.INTERNET")) {
                    this.zzr().zzf().zza("App is missing INTERNET permission");
                }
                if (!this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzr().zzf().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzw zzw2 = this.zzg;
                if (!Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() && !this.zzh.zzz()) {
                    if (!zzfn.zza(this.zzb)) {
                        this.zzr().zzf().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzkk.zza(this.zzb, false)) {
                        this.zzr().zzf().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzr().zzf().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            zzw zzw3 = this.zzg;
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                this.zzi();
                if (zzkk.zza(this.zzy().zzac(), this.zzc().zzg(), this.zzy().zzad(), this.zzc().zzh())) {
                    this.zzr().zzv().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzc().zzj();
                    this.zzk().zzab();
                    this.zzu.zzah();
                    this.zzu.zzaf();
                    this.zzc().zzh.zza(this.zzag);
                    this.zzc().zzj.zza(null);
                }
                this.zzc().zzc(this.zzy().zzac());
                this.zzc().zzd(this.zzy().zzad());
            }
            this.zzh().zza(this.zzc().zzj.zza());
            zzw3 = this.zzg;
            if (zzkb.zzb() && this.zzh.zza(zzap.zzcr) && !this.zzi().zzv() && !TextUtils.isEmpty((CharSequence)this.zzc().zzw.zza())) {
                this.zzr().zzi().zza("Remote config removed with active feature rollouts");
                this.zzc().zzw.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzy().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad())) {
                boolean bl = this.zzab();
                if (!this.zzc().zzx() && !this.zzh.zzh()) {
                    this.zzc().zzd(!bl);
                }
                if (bl) {
                    this.zzh().zzai();
                }
                zzjt zzjt2 = this.zze().zza;
                if (((zzgs)zzjt2.zza).zzt().zzn(((zzf)zzjt2.zza).zzg().zzab()) && zzkn.zzb() && ((zzgs)zzjt2.zza).zzt().zze(((zzf)zzjt2.zza).zzg().zzab(), zzap.zzbc)) {
                    ((zzgs)zzjt2.zza).zzd();
                    if (((zzgs)zzjt2.zza).zzs().zza(((zzgs)zzjt2.zza).zzm().currentTimeMillis())) {
                        ((zzgs)zzjt2.zza).zzs().zzm.zza(true);
                        if (Build.VERSION.SDK_INT >= 16) {
                            ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                            ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
                            if (runningAppProcessInfo.importance == 100) {
                                ((zzgs)zzjt2.zza).zzr().zzx().zza("Detected application was in foreground");
                                zzjt2.zzb(((zzgs)zzjt2.zza).zzm().currentTimeMillis(), false);
                            }
                        }
                    }
                }
                this.zzw().zza(new AtomicReference<String>());
            }
        }
        this.zzc().zzo.zza(this.zzh.zza(zzap.zzbo));
        this.zzc().zzp.zza(this.zzh.zza(zzap.zzbp));
    }

    @Override
    public final zzw zzu() {
        return this.zzg;
    }

    public final zzx zzb() {
        return this.zzh;
    }

    public final zzfg zzc() {
        zzfx.zza(this.zzi);
        return this.zzi;
    }

    @Override
    public final zzet zzr() {
        zzfx.zzb(this.zzj);
        return this.zzj;
    }

    public final zzet zzd() {
        if (this.zzj != null && this.zzj.zzz()) {
            return this.zzj;
        }
        return null;
    }

    @Override
    public final zzfu zzq() {
        zzfx.zzb(this.zzk);
        return this.zzk;
    }

    public final zzjl zze() {
        zzfx.zzb(this.zzl);
        return this.zzl;
    }

    public final zzfm zzf() {
        return this.zzx;
    }

    final zzfu zzg() {
        return this.zzk;
    }

    public final zzhc zzh() {
        zzfx.zzb(this.zzq);
        return this.zzq;
    }

    public final zzkk zzi() {
        zzfx.zza(this.zzm);
        return this.zzm;
    }

    public final zzer zzj() {
        zzfx.zza(this.zzn);
        return this.zzn;
    }

    public final zzep zzk() {
        zzfx.zzb(this.zzt);
        return this.zzt;
    }

    private final zzia zzai() {
        zzfx.zzb(this.zzs);
        return this.zzs;
    }

    @Override
    public final Context zzn() {
        return this.zzb;
    }

    public final boolean zzl() {
        return TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final String zzo() {
        return this.zzc;
    }

    public final String zzp() {
        return this.zzd;
    }

    public final String zzs() {
        return this.zze;
    }

    public final boolean zzt() {
        return this.zzf;
    }

    @Override
    public final Clock zzm() {
        return this.zzo;
    }

    public final zzif zzv() {
        zzfx.zzb(this.zzp);
        return this.zzp;
    }

    public final zzik zzw() {
        zzfx.zzb(this.zzu);
        return this.zzu;
    }

    public final zzah zzx() {
        zzfx.zzb(this.zzv);
        return this.zzv;
    }

    public final zzeq zzy() {
        zzfx.zzb(this.zzw);
        return this.zzw;
    }

    public final zzb zzz() {
        if (this.zzr == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzr;
    }

    @VisibleForTesting
    public static zzfx zza(Context context, String string, String string2, Bundle bundle) {
        return zzfx.zza(context, new zzv(0L, 0L, true, null, null, null, bundle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzfx zza(Context context, zzv zzv2) {
        if (zzv2 != null && (zzv2.zze == null || zzv2.zzf == null)) {
            zzv2 = new zzv(zzv2.zza, zzv2.zzb, zzv2.zzc, zzv2.zzd, null, null, zzv2.zzg);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zza == null) {
            Class<zzfx> clazz = zzfx.class;
            synchronized (zzfx.class) {
                if (zza == null) {
                    zzgz zzgz2 = new zzgz(context, zzv2);
                    zza = new zzfx(zzgz2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzv2 != null && zzv2.zzg != null && zzv2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            zza.zza(zzv2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zza;
    }

    private final void zzaj() {
        if (!this.zzy) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zzb(zzgr zzgr2) {
        if (zzgr2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzgr2.zzz()) {
            String string = String.valueOf(zzgr2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zzb(zze zze2) {
        if (zze2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zze2.zzv()) {
            String string = String.valueOf(zze2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzgs zzgs2) {
        if (zzgs2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzab = bl;
    }

    @WorkerThread
    public final boolean zzaa() {
        return this.zzab != null && this.zzab != false;
    }

    @WorkerThread
    public final boolean zzab() {
        boolean bl;
        ((zzgs)this.zzq()).zzd();
        this.zzaj();
        if (this.zzh.zza(zzap.zzbi)) {
            if (this.zzh.zzh()) {
                return false;
            }
            if (this.zzad != null && this.zzad.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzc().zzk();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzh.zzi();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzac != null) {
                return this.zzac;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzh.zza(zzap.zzbd) && this.zzab != null) {
                return this.zzab;
            }
            return true;
        }
        if (this.zzh.zzh()) {
            return false;
        }
        Boolean bl4 = this.zzh.zzi();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzab != null && ((Boolean)zzap.zzbd.zza(null)).booleanValue()) {
                bl = this.zzab;
            }
        }
        return this.zzc().zzc(bl);
    }

    final long zzac() {
        Long l = this.zzc().zzh.zza();
        if (l == 0L) {
            return this.zzag;
        }
        return Math.min(this.zzag, l);
    }

    final void zzad() {
        zzw zzw2 = this.zzg;
    }

    final void zzae() {
        zzw zzw2 = this.zzg;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zza(zzgr zzgr2) {
        ++this.zzae;
    }

    final void zza(zze zze2) {
        ++this.zzae;
    }

    final void zzaf() {
        this.zzaf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzag() {
        this.zzaj();
        ((zzgs)this.zzq()).zzd();
        if (this.zzz == null || this.zzaa == 0L || this.zzz != null && !this.zzz.booleanValue() && Math.abs(this.zzo.elapsedRealtime() - this.zzaa) > 1000L) {
            this.zzaa = this.zzo.elapsedRealtime();
            zzw zzw2 = this.zzg;
            this.zzz = this.zzi().zzd("android.permission.INTERNET") && this.zzi().zzd("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzb).isCallerInstantApp() || this.zzh.zzz() || zzfn.zza(this.zzb) && zzkk.zza(this.zzb, false));
            if (this.zzz.booleanValue()) {
                this.zzz = this.zzi().zzc(this.zzy().zzac(), this.zzy().zzad()) || !TextUtils.isEmpty((CharSequence)this.zzy().zzad());
            }
        }
        return this.zzz;
    }

    @WorkerThread
    public final void zzah() {
        ((zzgs)this.zzq()).zzd();
        zzfx.zzb(this.zzai());
        String string = this.zzy().zzab();
        Pair<String, Boolean> pair = this.zzc().zza(string);
        if (!this.zzh.zzj().booleanValue() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzr().zzw().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return;
        }
        if (!this.zzai().zzg()) {
            this.zzr().zzi().zza("Network is not available for Deferred Deep Link request. Skipping");
            return;
        }
        URL uRL = this.zzi().zza(((zzgs)this.zzy()).zzt().zzf(), string, (String)pair.first, this.zzc().zzv.zza() - 1L);
        zzga zzga2 = new zzga(this);
        URL uRL2 = uRL;
        String string2 = string;
        zzia zzia2 = this.zzai();
        ((zzgs)zzia2).zzd();
        zzia2.zzaa();
        Preconditions.checkNotNull((Object)uRL2);
        Preconditions.checkNotNull((Object)zzga2);
        ((zzgs)zzia2).zzq().zzb(new zzic(zzia2, string2, uRL2, null, null, zzga2));
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzfx zzfx2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzfx2.zzr().zzi().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzfx2.zzc().zzu.zza(true);
        if (byArray2.length == 0) {
            zzfx2.zzr().zzw().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            List list;
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzfx2.zzr().zzw().zza("Deferred Deep Link is empty.");
                return;
            }
            String string5 = string3;
            zzkk zzkk2 = zzfx2.zzi();
            ((zzgs)zzkk2).zzb();
            if (!(!TextUtils.isEmpty((CharSequence)string5) && (list = ((zzgs)zzkk2).zzn().getPackageManager().queryIntentActivities(new Intent("android.intent.action.VIEW", Uri.parse((String)string5)), 0)) != null && !list.isEmpty())) {
                zzfx2.zzr().zzi().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            Bundle bundle = new Bundle();
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzfx2.zzq.zza("auto", "_cmp", bundle);
            string5 = string3;
            zzkk2 = zzfx2.zzi();
            if (!TextUtils.isEmpty((CharSequence)string5) && zzkk2.zza(string5, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzgs)zzkk2).zzn().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzfx2.zzr().zzf().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    static /* synthetic */ void zza(zzfx zzfx2, zzgz zzgz2) {
        zzfx2.zza(zzgz2);
    }
}

